/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.Iterator;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.scriptio.ScriptReaderBase;

class ScriptReaderBinary
extends ScriptReaderBase {
    RowInputBinary rowIn = new RowInputBinary();

    ScriptReaderBinary(Database database, String string) throws HsqlException, IOException {
        super(database, string);
    }

    protected void readDDL(Session session) throws IOException, HsqlException {
        this.rowIn.setSystemId(false);
        this.readSingleColumnResult(session);
    }

    protected void readSingleColumnResult(Session session) throws IOException, HsqlException {
        Result result = Result.read(this.rowIn, this.dataStreamIn);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            String string = (String)objectArray[0];
            session.sqlExecuteDirectNoPreChecks(string);
        }
    }

    protected void readExistingData(Session session) throws IOException, HsqlException {
        String string;
        this.rowIn.setSystemId(true);
        while ((string = this.readTableInit()) != null) {
            Table table = this.db.getTable(string, session);
            int n = 0;
            n = 0;
            while (this.readRow(table)) {
                ++n;
            }
            int n2 = this.readTableTerm();
            if (n == n2) continue;
            throw Trace.error(78, 96, (Object)new Object[]{string, new Integer(n), new Integer(n2)});
        }
    }

    public String readLoggedStatement() throws IOException {
        return null;
    }

    protected boolean readRow(Table table) throws IOException, HsqlException {
        boolean bl = this.readRow(this.rowIn, 0, this.dataStreamIn);
        if (!bl) {
            return false;
        }
        Object[] objectArray = this.rowIn.readData(table.getColumnTypes());
        table.insertNoCheck(objectArray, null, false);
        return true;
    }

    protected int readTableTerm() throws IOException, HsqlException {
        this.rowIn.reset();
        int n = 4;
        for (int i = 0; this.dataStreamIn.available() > 0 && i < n; i += this.dataStreamIn.read(this.rowIn.getBuffer(), i, n - i)) {
        }
        return this.rowIn.readInt();
    }

    protected String readTableInit() throws IOException, HsqlException {
        boolean bl = this.readRow(this.rowIn, 0, this.dataStreamIn);
        if (!bl) {
            return null;
        }
        String string = this.rowIn.readString();
        int n = this.rowIn.readIntData();
        if (n != 0) {
            throw Trace.error(78, 97, null);
        }
        return string;
    }

    boolean readRow(RowInputBase rowInputBase, int n, InputStream inputStream) throws IOException {
        int n2;
        rowInputBase.reset();
        int n3 = 4;
        for (n2 = 0; inputStream.available() > 0 && n2 < n3; n2 += this.dataStreamIn.read(rowInputBase.getBuffer(), n2, n3 - n2)) {
        }
        n3 = rowInputBase.readInt();
        if (n3 == 0) {
            return false;
        }
        rowInputBase.resetRow(n, n3);
        while (inputStream.available() > 0 && n2 < n3) {
            n2 += this.dataStreamIn.read(rowInputBase.getBuffer(), n2, n3 - n2);
        }
        return true;
    }
}

