/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

import java.math.BigDecimal;
import java.sql.Date;
import org.hsqldb.store.ValuePoolHashMap;

public class ValuePool {
    static ValuePoolHashMap intPool;
    static ValuePoolHashMap longPool;
    static ValuePoolHashMap doublePool;
    static ValuePoolHashMap bigdecimalPool;
    static ValuePoolHashMap stringPool;
    static ValuePoolHashMap datePool;
    static final int[] defaultPoolLookupSize;
    static final int defaultSizeFactor = 2;
    static final int defaultMaxStringLength = 16;
    static ValuePoolHashMap[] poolList;
    static int maxStringLength;
    static /* synthetic */ Class class$org$hsqldb$store$ValuePool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPool() {
        int[] nArray = defaultPoolLookupSize;
        int n = 2;
        Class clazz = class$org$hsqldb$store$ValuePool == null ? (class$org$hsqldb$store$ValuePool = ValuePool.class$("org.hsqldb.store.ValuePool")) : class$org$hsqldb$store$ValuePool;
        synchronized (clazz) {
            maxStringLength = 16;
            poolList = new ValuePoolHashMap[6];
            for (int i = 0; i < poolList.length; ++i) {
                int n2 = nArray[i];
                ValuePool.poolList[i] = new ValuePoolHashMap(n2, n2 * n, 2);
            }
            intPool = poolList[0];
            longPool = poolList[1];
            doublePool = poolList[2];
            bigdecimalPool = poolList[3];
            stringPool = poolList[4];
            datePool = poolList[5];
        }
    }

    public static void resetPool(int[] nArray, int n) {
        for (int i = 0; i < poolList.length; ++i) {
            poolList[i].resetCapacity(nArray[i] * n, 2);
        }
    }

    public static void resetPool() {
        ValuePool.resetPool(defaultPoolLookupSize, 2);
    }

    public static void clearPool() {
        for (int i = 0; i < poolList.length; ++i) {
            poolList[i].clear();
        }
    }

    public static synchronized Integer getInt(int n) {
        return intPool.getOrAddInteger(n);
    }

    public static synchronized Long getLong(long l) {
        return longPool.getOrAddLong(l);
    }

    public static synchronized Double getDouble(long l) {
        return doublePool.getOrAddDouble(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String string) {
        if (string == null || string.length() > maxStringLength) {
            return string;
        }
        ValuePoolHashMap valuePoolHashMap = stringPool;
        synchronized (valuePoolHashMap) {
            return stringPool.getOrAddString(string);
        }
    }

    public static synchronized Date getDate(long l) {
        return datePool.getOrAddDate(l);
    }

    public static synchronized BigDecimal getBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return bigDecimal;
        }
        return (BigDecimal)bigdecimalPool.getOrAddObject(bigDecimal);
    }

    public static Boolean getBoolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        defaultPoolLookupSize = new int[]{10000, 10000, 10000, 10000, 10000, 10000};
        ValuePool.initPool();
    }

    public static class poolSettings {
        String[] propertyStrings = new String[]{"runtime.pool.int_size", "runtime.pool.long_size", "runtime.pool.double_size", "runtime.pool.decimal_size", "runtime.pool.string_size", "runtime.pool.date_size", "runtime.pool.factor", "runtime.pool.string_length"};
        static final int[] defaultPoolLookupSize = new int[]{1000, 1000, 1000, 1000, 1000, 1000};
    }
}

