/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.export;

import dori.jasper.engine.JRAbstractExporter;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JRFont;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRPrintEllipse;
import dori.jasper.engine.JRPrintImage;
import dori.jasper.engine.JRPrintLine;
import dori.jasper.engine.JRPrintPage;
import dori.jasper.engine.JRPrintRectangle;
import dori.jasper.engine.JRPrintText;
import dori.jasper.engine.base.JRBaseFont;
import dori.jasper.engine.base.JRBasePrintElement;
import dori.jasper.engine.base.JRBasePrintPage;
import dori.jasper.engine.export.JRExportProgressMonitor;
import dori.jasper.engine.export.JRExporterGridCell;
import dori.jasper.engine.export.JRXlsExporterParameter;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.Region;

public class JRXlsExporter
extends JRAbstractExporter {
    protected int pageHeight = 0;
    protected HSSFWorkbook workbook = null;
    protected HSSFSheet sheet = null;
    protected HSSFRow row = null;
    protected HSSFCell cell = null;
    protected HSSFCellStyle emptyCellStyle = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected JRFont defaultFont = null;
    protected List loadedFonts = new ArrayList();
    protected List loadedCellStyles = new ArrayList();
    protected boolean isOnePagePerSheet = false;
    protected boolean isRemoveEmptySpace = false;
    protected boolean isAutoDetectCellType = true;
    protected short whiteIndex = new HSSFColor.WHITE().getIndex();
    protected short backgroundMode = 1;
    protected JRExporterGridCell[][] grid = null;
    protected boolean[] isRowNotEmpty = null;
    protected List xCuts = null;
    protected List yCuts = null;

    protected JRFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRBaseFont();
            }
        }
        return this.defaultFont;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportReport() throws JRException {
        OutputStream os;
        Boolean isAutoDetectCellTypeParameter;
        Boolean isWhitePageBackgroundParameter;
        Boolean isRemoveEmptySpaceParameter;
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setInput();
        this.setPageRange();
        Boolean isOnePagePerSheetParameter = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET);
        if (isOnePagePerSheetParameter != null) {
            this.isOnePagePerSheet = isOnePagePerSheetParameter;
        }
        if ((isRemoveEmptySpaceParameter = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS)) != null) {
            this.isRemoveEmptySpace = isRemoveEmptySpaceParameter;
        }
        if ((isWhitePageBackgroundParameter = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND)) != null && !isWhitePageBackgroundParameter.booleanValue()) {
            this.backgroundMode = 0;
        }
        if ((isAutoDetectCellTypeParameter = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_AUTO_DETECT_CELL_TYPE)) != null) {
            this.isAutoDetectCellType = isAutoDetectCellTypeParameter;
        }
        if ((os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM)) != null) {
            this.exportReportToStream(os);
            return;
        }
        File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (fileName == null) throw new JRException("No output specified for the exporter.");
            destFile = new File(fileName);
        }
        try {
            try {
                os = new FileOutputStream(destFile);
                this.exportReportToStream(os);
                os.flush();
            }
            catch (IOException e) {
                throw new JRException("Error trying to export to file : " + destFile, e);
            }
            Object var9_9 = null;
            if (os == null) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        os.close();
        return;
    }

    protected void exportReportToStream(OutputStream os) throws JRException {
        this.workbook = new HSSFWorkbook();
        this.emptyCellStyle = this.workbook.createCellStyle();
        this.emptyCellStyle.setFillForegroundColor(new HSSFColor.WHITE().getIndex());
        this.emptyCellStyle.setFillPattern(this.backgroundMode);
        try {
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                JRPrintPage page = null;
                if (this.isOnePagePerSheet) {
                    this.pageHeight = this.jasperPrint.getPageHeight();
                    int i = this.startPageIndex;
                    while (i <= this.endPageIndex) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        page = (JRPrintPage)pages.get(i);
                        this.sheet = this.workbook.createSheet("Page " + (i + 1));
                        this.exportPage(page, page);
                        ++i;
                    }
                } else {
                    this.pageHeight = this.jasperPrint.getPageHeight() * pages.size();
                    JRBasePrintPage alterYAllPages = new JRBasePrintPage();
                    JRBasePrintPage allPages = new JRBasePrintPage();
                    List elements = null;
                    JRBasePrintElement alterYElement = null;
                    JRPrintElement element = null;
                    int i = this.startPageIndex;
                    while (i <= this.endPageIndex) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        page = (JRPrintPage)pages.get(i);
                        elements = page.getElements();
                        if (elements != null && elements.size() > 0) {
                            Iterator it = elements.iterator();
                            while (it.hasNext()) {
                                element = (JRPrintElement)it.next();
                                allPages.addElement(element);
                                alterYElement = new JRBasePrintElement();
                                alterYElement.setY(element.getY() + this.jasperPrint.getPageHeight() * i);
                                alterYAllPages.addElement(alterYElement);
                            }
                        }
                        ++i;
                    }
                    this.sheet = this.workbook.createSheet("Sheet1");
                    this.exportPage(alterYAllPages, allPages);
                }
            }
            this.workbook.write(os);
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void exportPage(JRPrintPage alterYPage, JRPrintPage page) throws JRException {
        this.layoutGrid(alterYPage, page);
        width = 0;
        i = 1;
        while (i < this.xCuts.size()) {
            width = (Integer)this.xCuts.get(i) - (Integer)this.xCuts.get(i - 1);
            this.sheet.setColumnWidth((short)(i - 1), (short)(width * 43));
            ++i;
        }
        element = null;
        emptyCell = null;
        y = 0;
        while (y < this.grid.length) {
            if (this.isRowNotEmpty[y] || !this.isRemoveEmptySpace) {
                this.row = this.sheet.createRow((int)((short)y));
                emptyCellColSpan = 0;
                emptyCellWidth = 0;
                lastRowHeight = this.grid[y][0].height;
                this.row.setHeightInPoints((float)((short)lastRowHeight));
                x = 0;
                x = 0;
                while (x < this.grid[y].length) {
                    emptyCell = this.row.createCell((short)x);
                    emptyCell.setCellStyle(this.emptyCellStyle);
                    if (this.grid[y][x].element != null) {
                        if (emptyCellColSpan > 0) {
                            if (emptyCellColSpan > 1) {
                                // empty if block
                            }
                            emptyCellColSpan = 0;
                            emptyCellWidth = 0;
                        }
                        if ((element = this.grid[y][x].element) instanceof JRPrintLine) {
                            this.exportLine((JRPrintLine)element, this.grid[y][x], x, y);
                        } else if (element instanceof JRPrintRectangle) {
                            this.exportRectangle(element, this.grid[y][x], x, y);
                        } else if (element instanceof JRPrintEllipse) {
                            this.exportRectangle(element, this.grid[y][x], x, y);
                        } else if (element instanceof JRPrintText) {
                            this.exportText((JRPrintText)element, this.grid[y][x], x, y);
                        }
                        x += this.grid[y][x].colSpan - 1;
                    } else {
                        ++emptyCellColSpan;
                        emptyCellWidth += this.grid[y][x].width;
                    }
                    ++x;
                }
                ** if (emptyCellColSpan > 0 && emptyCellColSpan <= 1) goto lbl57
            }
            this.row = this.sheet.createRow((int)((short)y));
            this.row.setHeight((short)0);
            x = 0;
            while (x < this.grid[y].length) {
                emptyCell = this.row.createCell((short)x);
                emptyCell.setCellStyle(this.emptyCellStyle);
                ++x;
            }
lbl-1000:
            // 1 sources

            {
                // empty if block
            }
lbl57:
            // 3 sources

            ++y;
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int x, int y) {
        if (gridCell.colSpan > 1 || gridCell.rowSpan > 1) {
            this.sheet.addMergedRegion(new Region(y, (short)x, y + gridCell.rowSpan - 1, (short)(x + gridCell.colSpan - 1)));
        }
        short forecolor = JRXlsExporter.getNearestColor(line.getForecolor()).getIndex();
        HSSFFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor);
        HSSFCellStyle cellStyle = this.getLoadedCellStyle((short)1, forecolor, (short)1, (short)0, (short)0, cellFont);
        this.cell = this.row.createCell((short)x);
        this.cell.setEncoding((short)1);
        this.cell.setCellValue("");
        this.cell.setCellStyle(cellStyle);
    }

    protected void exportRectangle(JRPrintElement element, JRExporterGridCell gridCell, int x, int y) {
        if (gridCell.colSpan > 1 || gridCell.rowSpan > 1) {
            this.sheet.addMergedRegion(new Region(y, (short)x, y + gridCell.rowSpan - 1, (short)(x + gridCell.colSpan - 1)));
        }
        short forecolor = JRXlsExporter.getNearestColor(element.getForecolor()).getIndex();
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (element.getMode() == 1) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(element.getBackcolor()).getIndex();
        }
        HSSFFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor);
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, cellFont);
        this.cell = this.row.createCell((short)x);
        this.cell.setEncoding((short)1);
        this.cell.setCellValue("");
        this.cell.setCellStyle(cellStyle);
    }

    protected void exportText(JRPrintText text, JRExporterGridCell gridCell, int x, int y) {
        if (gridCell.colSpan > 1 || gridCell.rowSpan > 1) {
            this.sheet.addMergedRegion(new Region(y, (short)x, y + gridCell.rowSpan - 1, (short)(x + gridCell.colSpan - 1)));
        }
        if (text.getText() != null) {
            JRFont font = text.getFont();
            if (font == null) {
                font = this.getDefaultFont();
            }
            short forecolor = JRXlsExporter.getNearestColor(text.getForecolor()).getIndex();
            HSSFFont cellFont = this.getLoadedFont(font, forecolor);
            short horizontalAlignment = 1;
            short verticalAlignment = 1;
            short rotation = 0;
            block1 : switch (text.getRotation()) {
                case 1: {
                    rotation = 90;
                    switch (text.getTextAlignment()) {
                        case 1: {
                            verticalAlignment = 2;
                            break;
                        }
                        case 2: {
                            verticalAlignment = 1;
                            break;
                        }
                        case 3: {
                            verticalAlignment = 0;
                            break;
                        }
                        case 4: {
                            verticalAlignment = 3;
                            break;
                        }
                        default: {
                            verticalAlignment = 2;
                        }
                    }
                    switch (text.getVerticalAlignment()) {
                        case 1: {
                            horizontalAlignment = 1;
                            break block1;
                        }
                        case 2: {
                            horizontalAlignment = 2;
                            break block1;
                        }
                        case 3: {
                            horizontalAlignment = 3;
                            break block1;
                        }
                    }
                    horizontalAlignment = 1;
                    break;
                }
                case 2: {
                    rotation = -90;
                    switch (text.getTextAlignment()) {
                        case 1: {
                            verticalAlignment = 0;
                            break;
                        }
                        case 2: {
                            verticalAlignment = 1;
                            break;
                        }
                        case 3: {
                            verticalAlignment = 2;
                            break;
                        }
                        case 4: {
                            verticalAlignment = 3;
                            break;
                        }
                        default: {
                            verticalAlignment = 0;
                        }
                    }
                    switch (text.getVerticalAlignment()) {
                        case 1: {
                            horizontalAlignment = 3;
                            break block1;
                        }
                        case 2: {
                            horizontalAlignment = 2;
                            break block1;
                        }
                        case 3: {
                            horizontalAlignment = 1;
                            break block1;
                        }
                    }
                    horizontalAlignment = 3;
                    break;
                }
                default: {
                    rotation = 0;
                    switch (text.getTextAlignment()) {
                        case 1: {
                            horizontalAlignment = 1;
                            break;
                        }
                        case 2: {
                            horizontalAlignment = 2;
                            break;
                        }
                        case 3: {
                            horizontalAlignment = 3;
                            break;
                        }
                        case 4: {
                            horizontalAlignment = 5;
                            break;
                        }
                        default: {
                            horizontalAlignment = 1;
                        }
                    }
                    switch (text.getVerticalAlignment()) {
                        case 1: {
                            verticalAlignment = 0;
                            break block1;
                        }
                        case 2: {
                            verticalAlignment = 1;
                            break block1;
                        }
                        case 3: {
                            verticalAlignment = 2;
                            break block1;
                        }
                    }
                    verticalAlignment = 0;
                }
            }
            short mode = this.backgroundMode;
            short backcolor = this.whiteIndex;
            if (text.getMode() == 1) {
                mode = 1;
                backcolor = JRXlsExporter.getNearestColor(text.getBackcolor()).getIndex();
            }
            HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, cellFont);
            this.cell = this.row.createCell((short)x);
            this.cell.setEncoding((short)1);
            if (this.isAutoDetectCellType) {
                try {
                    this.cell.setCellValue(Double.parseDouble(text.getText()));
                }
                catch (NumberFormatException e) {
                    this.cell.setCellValue(text.getText());
                }
            } else {
                this.cell.setCellValue(text.getText());
            }
            this.cell.setCellStyle(cellStyle);
        }
    }

    protected void layoutGrid(JRPrintPage alterYPage, JRPrintPage page) {
        this.xCuts = new ArrayList();
        this.yCuts = new ArrayList();
        this.xCuts.add(new Integer(0));
        this.xCuts.add(new Integer(this.jasperPrint.getPageWidth()));
        this.yCuts.add(new Integer(0));
        this.yCuts.add(new Integer(this.pageHeight));
        Integer x = null;
        Integer y = null;
        JRPrintElement alterYElement = null;
        JRPrintElement element = null;
        List alterYElems = alterYPage.getElements();
        List elems = page.getElements();
        int i = 0;
        while (i < elems.size()) {
            alterYElement = (JRPrintElement)alterYElems.get(i);
            element = (JRPrintElement)elems.get(i);
            if (!(element instanceof JRPrintImage)) {
                x = new Integer(element.getX());
                if (!this.xCuts.contains(x)) {
                    this.xCuts.add(x);
                }
                if (!this.xCuts.contains(x = new Integer(element.getX() + element.getWidth()))) {
                    this.xCuts.add(x);
                }
                if (!this.yCuts.contains(y = new Integer(alterYElement.getY()))) {
                    this.yCuts.add(y);
                }
                if (!this.yCuts.contains(y = new Integer(alterYElement.getY() + element.getHeight()))) {
                    this.yCuts.add(y);
                }
            }
            ++i;
        }
        Collections.sort(this.xCuts);
        Collections.sort(this.yCuts);
        int xCellCount = this.xCuts.size() - 1;
        int yCellCount = this.yCuts.size() - 1;
        this.grid = new JRExporterGridCell[yCellCount][xCellCount];
        this.isRowNotEmpty = new boolean[yCellCount];
        int j = 0;
        while (j < yCellCount) {
            int i2 = 0;
            while (i2 < xCellCount) {
                this.grid[j][i2] = new JRExporterGridCell(null, (Integer)this.xCuts.get(i2 + 1) - (Integer)this.xCuts.get(i2), (Integer)this.yCuts.get(j + 1) - (Integer)this.yCuts.get(j), 1, 1);
                ++i2;
            }
            ++j;
        }
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int xi = 0;
        int yi = 0;
        boolean isOverlap = false;
        int i3 = elems.size() - 1;
        while (i3 >= 0) {
            alterYElement = (JRPrintElement)alterYElems.get(i3);
            element = (JRPrintElement)elems.get(i3);
            if (!(element instanceof JRPrintImage)) {
                x1 = this.xCuts.indexOf(new Integer(element.getX()));
                y1 = this.yCuts.indexOf(new Integer(alterYElement.getY()));
                x2 = this.xCuts.indexOf(new Integer(element.getX() + element.getWidth()));
                y2 = this.yCuts.indexOf(new Integer(alterYElement.getY() + element.getHeight()));
                isOverlap = false;
                yi = y1;
                while (yi < y2 && !isOverlap) {
                    xi = x1;
                    while (xi < x2 && !isOverlap) {
                        if (this.grid[yi][xi].element != null) {
                            isOverlap = true;
                        }
                        ++xi;
                    }
                    ++yi;
                }
                if (!isOverlap) {
                    yi = y1;
                    while (yi < y2) {
                        xi = x1;
                        while (xi < x2) {
                            this.grid[yi][xi] = JRExporterGridCell.OCCUPIED_CELL;
                            ++xi;
                        }
                        this.isRowNotEmpty[yi] = true;
                        ++yi;
                    }
                    if (x2 - x1 != 0 && y2 - y1 != 0) {
                        this.grid[y1][x1] = new JRExporterGridCell(element, element.getWidth(), element.getHeight(), x2 - x1, y2 - y1);
                    }
                }
            }
            --i3;
        }
    }

    protected static HSSFColor getNearestColor(Color awtColor) {
        Set keys;
        HSSFColor color = null;
        Hashtable triplets = HSSFColor.getTripletHash();
        if (triplets != null && (keys = triplets.keySet()) != null && keys.size() > 0) {
            Object key = null;
            HSSFColor crtColor = null;
            short[] rgb = null;
            int diff = 0;
            int minDiff = 999;
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                key = it.next();
                crtColor = (HSSFColor)triplets.get(key);
                rgb = crtColor.getTriplet();
                diff = Math.abs(rgb[0] - awtColor.getRed()) + Math.abs(rgb[1] - awtColor.getGreen()) + Math.abs(rgb[2] - awtColor.getBlue());
                if (diff >= minDiff) continue;
                minDiff = diff;
                color = crtColor;
            }
        }
        return color;
    }

    protected HSSFFont getLoadedFont(JRFont font, short forecolor) {
        HSSFFont cellFont = null;
        if (this.loadedFonts != null && this.loadedFonts.size() > 0) {
            HSSFFont cf = null;
            int i = 0;
            while (i < this.loadedFonts.size()) {
                cf = (HSSFFont)this.loadedFonts.get(i);
                if (cf.getFontName().equals(font.getFontName()) && cf.getColor() == forecolor && cf.getFontHeightInPoints() == (short)font.getSize() && (cf.getUnderline() == 1 ? font.isUnderline() : !font.isUnderline()) && cf.getStrikeout() == font.isStrikeThrough() && (cf.getBoldweight() == 700 ? font.isBold() : !font.isBold()) && cf.getItalic() == font.isItalic()) {
                    cellFont = cf;
                    break;
                }
                ++i;
            }
        }
        if (cellFont == null) {
            cellFont = this.workbook.createFont();
            cellFont.setFontName(font.getFontName());
            cellFont.setColor(forecolor);
            cellFont.setFontHeightInPoints((short)font.getSize());
            if (font.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (font.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (font.isBold()) {
                cellFont.setBoldweight((short)700);
            }
            if (font.isItalic()) {
                cellFont.setItalic(true);
            }
            this.loadedFonts.add(cellFont);
        }
        return cellFont;
    }

    protected HSSFCellStyle getLoadedCellStyle(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font) {
        HSSFCellStyle cellStyle = null;
        if (this.loadedCellStyles != null && this.loadedCellStyles.size() > 0) {
            HSSFCellStyle cs = null;
            int i = 0;
            while (i < this.loadedCellStyles.size()) {
                cs = (HSSFCellStyle)this.loadedCellStyles.get(i);
                if (cs.getFillPattern() == mode && cs.getFillForegroundColor() == backcolor && cs.getAlignment() == horizontalAlignment && cs.getVerticalAlignment() == verticalAlignment && cs.getRotation() == rotation && cs.getFontIndex() == font.getIndex()) {
                    cellStyle = cs;
                    break;
                }
                ++i;
            }
        }
        if (cellStyle == null) {
            cellStyle = this.workbook.createCellStyle();
            cellStyle.setFillForegroundColor(backcolor);
            cellStyle.setFillPattern(mode);
            cellStyle.setAlignment(horizontalAlignment);
            cellStyle.setVerticalAlignment(verticalAlignment);
            cellStyle.setRotation(rotation);
            cellStyle.setFont(font);
            cellStyle.setWrapText(true);
            this.loadedCellStyles.add(cellStyle);
        }
        return cellStyle;
    }
}

