/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRStaticText;
import dori.jasper.engine.fill.JRBaseFiller;
import dori.jasper.engine.fill.JRFillObjectFactory;
import dori.jasper.engine.fill.JRFillTextElement;
import dori.jasper.engine.fill.JRTemplatePrintText;
import dori.jasper.engine.fill.JRTemplateText;
import dori.jasper.engine.util.JRStringUtil;

public class JRFillStaticText
extends JRFillTextElement
implements JRStaticText {
    private String text = null;

    protected JRFillStaticText(JRBaseFiller filler, JRStaticText staticText, JRFillObjectFactory factory) {
        super(filler, staticText, factory);
        this.text = JRStringUtil.treatNewLineChars(staticText.getText());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
    }

    protected int getTextStart() {
        return 0;
    }

    protected int getTextEnd() {
        return 0;
    }

    protected JRTemplateText getJRTemplateText() {
        if (this.template == null) {
            this.template = new JRTemplateText((JRStaticText)this.parent, this.getFont());
        }
        return (JRTemplateText)this.template;
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
    }

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        super.prepare(availableStretchHeight, isOverflow);
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
            isToPrint = false;
        }
        if (!(!isToPrint || !this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || this.isPrintInFirstWholeBand() && this.getBand().isNewPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
            isToPrint = false;
        }
        if (isToPrint && availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
            isToPrint = false;
            willOverflow = true;
        }
        if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
            isReprinted = true;
        }
        if (isToPrint) {
            this.chopTextElement(0);
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintText text = null;
        text = new JRTemplatePrintText(this.getJRTemplateText());
        text.setX(this.getX());
        text.setY(this.getRelativeY());
        if (this.getRotation() == 0) {
            text.setHeight(this.getStretchHeight());
        } else {
            text.setHeight(this.getHeight());
        }
        text.setAbsoluteLineSpacing(this.getAbsoluteLineSpacing());
        text.setAbsoluteLeading(this.getAbsoluteLeading());
        text.setTextHeight(this.getTextHeight());
        text.setText(this.getText());
        return text;
    }
}

