/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.DrawableLegendItem;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.event.LegendChangeEvent;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.MeterDataset;

public class MeterLegend
extends StandardLegend {
    private String legendText;
    private boolean showNormal = true;
    private boolean showWarning = true;
    private boolean showCritical = true;

    public MeterLegend(JFreeChart jFreeChart, String string) {
        super(jFreeChart);
        this.legendText = string;
    }

    public String getLegendText() {
        return this.legendText;
    }

    public void setLegendText(String string) {
        this.legendText = string;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Rectangle2D draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        return this.draw(graphics2D, rectangle2D, (this.getAnchor() & 1) != 0, (this.getAnchor() & 2) != 0);
    }

    private boolean updateInformation(MeterPlot meterPlot, MeterDataset meterDataset, int n, int n2, LegendItem[] legendItemArray, Paint[] paintArray) {
        boolean bl = false;
        String string = null;
        Number number = null;
        Number number2 = null;
        Paint paint = null;
        switch (n) {
            case 0: {
                number = meterDataset.getMinimumNormalValue();
                number2 = meterDataset.getMaximumNormalValue();
                paint = meterPlot.getNormalPaint();
                string = "Normal";
                break;
            }
            case 1: {
                number = meterDataset.getMinimumWarningValue();
                number2 = meterDataset.getMaximumWarningValue();
                paint = meterPlot.getWarningPaint();
                string = "Warning";
                break;
            }
            case 2: {
                number = meterDataset.getMinimumCriticalValue();
                number2 = meterDataset.getMaximumCriticalValue();
                paint = meterPlot.getCriticalPaint();
                string = "Critical";
                break;
            }
            case 3: {
                number = meterDataset.getMinimumValue();
                number2 = meterDataset.getMaximumValue();
                paint = MeterPlot.DEFAULT_BACKGROUND_PAINT;
                string = "Meter Graph";
                break;
            }
            default: {
                return false;
            }
        }
        if (number != null && number2 != null) {
            string = meterDataset.getBorderType() == n ? string + "  Range: " + meterDataset.getMinimumValue().toString() + " to " + number.toString() + "  and  " + number2.toString() + " to " + meterDataset.getMaximumValue().toString() : string + "  Range: " + number.toString() + " to " + number2.toString();
            legendItemArray[n2] = new LegendItem(string, string, null, null, null, null);
            paintArray[n2] = paint;
            bl = true;
        }
        return bl;
    }

    protected Rectangle2D draw(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl, boolean bl2) {
        int n = 0;
        Plot plot = this.getChart().getPlot();
        if (!(plot instanceof MeterPlot)) {
            throw new IllegalArgumentException("Plot must be MeterPlot");
        }
        MeterPlot meterPlot = (MeterPlot)plot;
        MeterDataset meterDataset = meterPlot.getMeterDataset();
        n = 1;
        ++n;
        if (this.showCritical && meterDataset.getMinimumCriticalValue() != null) {
            ++n;
        }
        if (this.showWarning && meterDataset.getMinimumWarningValue() != null) {
            ++n;
        }
        if (this.showNormal && meterDataset.getMinimumNormalValue() != null) {
            ++n;
        }
        LegendItem[] legendItemArray = new LegendItem[n];
        Paint[] paintArray = new Color[n];
        int n2 = 0;
        String string = this.legendText + (meterDataset.isValueValid() ? "   Current Value: " + meterDataset.getValue().toString() : "");
        legendItemArray[n2] = new LegendItem(string, string, null, null, null, null);
        paintArray[n2] = null;
        if (this.updateInformation(meterPlot, meterDataset, 3, ++n2, legendItemArray, paintArray)) {
            ++n2;
        }
        if (this.showCritical && this.updateInformation(meterPlot, meterDataset, 2, n2, legendItemArray, paintArray)) {
            ++n2;
        }
        if (this.showWarning && this.updateInformation(meterPlot, meterDataset, 1, n2, legendItemArray, paintArray)) {
            ++n2;
        }
        if (this.showNormal && this.updateInformation(meterPlot, meterDataset, 0, n2, legendItemArray, paintArray)) {
            ++n2;
        }
        if (legendItemArray != null) {
            double d;
            double d2;
            Rectangle2D rectangle2D2 = new Rectangle2D.Double();
            double d3 = rectangle2D.getWidth();
            double d4 = rectangle2D.getHeight();
            Point2D.Double double_ = new Point2D.Double();
            DrawableLegendItem[] drawableLegendItemArray = new DrawableLegendItem[legendItemArray.length];
            graphics2D.setFont(this.getItemFont());
            if (bl) {
                d2 = rectangle2D.getX() + this.getOuterGap().getLeftSpace(d3);
                d = rectangle2D.getMaxX() + this.getOuterGap().getRightSpace(d3) - 1.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                boolean bl3 = true;
                int n3 = 0;
                while (n3 < legendItemArray.length) {
                    drawableLegendItemArray[n3] = this.createLegendItem(graphics2D, legendItemArray[n3], d6, d8);
                    if (!bl3 && drawableLegendItemArray[n3].getX() + drawableLegendItemArray[n3].getWidth() + d2 > d) {
                        d5 = Math.max(d5, d6);
                        d6 = 0.0;
                        d8 += d7;
                        --n3;
                        bl3 = true;
                    } else {
                        d7 = Math.max(d7, drawableLegendItemArray[n3].getHeight());
                        d6 += drawableLegendItemArray[n3].getWidth();
                        bl3 = false;
                    }
                    ++n3;
                }
                d5 = Math.max(d5, d6);
                rectangle2D2 = new Rectangle2D.Double(0.0, 0.0, d5, d8 += d7);
                double d9 = bl2 ? rectangle2D.getMaxY() - d8 - this.getOuterGap().getBottomSpace(d4) : rectangle2D.getY() + this.getOuterGap().getTopSpace(d4);
                double d10 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - d5 / 2.0;
                double_ = new Point2D.Double(d10, d9);
            } else {
                d2 = 0.0;
                d = 0.0;
                graphics2D.setFont(this.getItemFont());
                int n4 = 0;
                while (n4 < drawableLegendItemArray.length) {
                    drawableLegendItemArray[n4] = this.createLegendItem(graphics2D, legendItemArray[n4], 0.0, d2);
                    d2 += drawableLegendItemArray[n4].getHeight();
                    d = Math.max(d, drawableLegendItemArray[n4].getWidth());
                    ++n4;
                }
                rectangle2D2 = new Rectangle2D.Float(0.0f, 0.0f, (float)d, (float)d2);
                double d11 = bl2 ? rectangle2D.getMaxX() - d - this.getOuterGap().getRightSpace(d3) : rectangle2D.getX() + this.getOuterGap().getLeftSpace(d3);
                double d12 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - d2 / 2.0;
                double_ = new Point2D.Double(d11, d12);
            }
            graphics2D.translate(((Point2D)double_).getX(), ((Point2D)double_).getY());
            graphics2D.setPaint(this.getBackgroundPaint());
            graphics2D.fill(rectangle2D2);
            graphics2D.setPaint(this.getOutlinePaint());
            graphics2D.setStroke(this.getOutlineStroke());
            graphics2D.draw(rectangle2D2);
            int n5 = 0;
            while (n5 < drawableLegendItemArray.length) {
                Paint paint = paintArray[n5];
                if (paint != null) {
                    graphics2D.setPaint(paint);
                    graphics2D.fill(drawableLegendItemArray[n5].getMarker());
                }
                graphics2D.setPaint(this.getItemPaint());
                graphics2D.drawString(drawableLegendItemArray[n5].getItem().getLabel(), (float)drawableLegendItemArray[n5].getLabelPosition().getX(), (float)drawableLegendItemArray[n5].getLabelPosition().getY());
                ++n5;
            }
            graphics2D.translate(-((Point2D)double_).getX(), -((Point2D)double_).getY());
            if (bl) {
                double d13 = rectangle2D.getY();
                double d14 = bl2 ? d13 : d13 + rectangle2D2.getHeight() + this.getOuterGap().getBottomSpace(d4);
                return new Rectangle2D.Double(rectangle2D.getX(), d14, d3, d4 - rectangle2D2.getHeight() - this.getOuterGap().getTopSpace(d4) - this.getOuterGap().getBottomSpace(d4));
            }
            double d15 = bl2 ? rectangle2D.getX() : rectangle2D.getX() + rectangle2D2.getWidth() + this.getOuterGap().getLeftSpace(d3) + this.getOuterGap().getRightSpace(d3);
            return new Rectangle2D.Double(d15, rectangle2D.getY(), d3 - rectangle2D2.getWidth() - this.getOuterGap().getLeftSpace(d3) - this.getOuterGap().getRightSpace(d3), d4);
        }
        return rectangle2D;
    }

    private DrawableLegendItem createLegendItem(Graphics graphics, LegendItem legendItem, double d, double d2) {
        int n = 2;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        LineMetrics lineMetrics = fontMetrics.getLineMetrics(legendItem.getLabel(), graphics);
        float f = lineMetrics.getHeight();
        DrawableLegendItem drawableLegendItem = new DrawableLegendItem(legendItem);
        float f2 = (float)(d + (double)n + (double)(1.15f * f));
        float f3 = (float)(d2 + (double)n + (double)(f - lineMetrics.getLeading() - lineMetrics.getDescent()));
        drawableLegendItem.setLabelPosition(new Point2D.Float(f2, f3));
        float f4 = f * 0.7f;
        f2 = (float)(d + (double)n + (double)(0.15f * f));
        f3 = (float)(d2 + (double)n + (double)(0.15f * f));
        drawableLegendItem.setMarker(new Rectangle2D.Float(f2, f3, f4, f4));
        float f5 = (float)(drawableLegendItem.getLabelPosition().getX() - d + fontMetrics.getStringBounds(legendItem.getLabel(), graphics).getWidth() + 0.5 * (double)f);
        float f6 = (float)(2 * n) + f;
        drawableLegendItem.setBounds(d, d2, f5, f6);
        return drawableLegendItem;
    }
}

