/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.chart.axis.ColorBarAxis;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.VerticalLogarithmicAxis;
import org.jfree.chart.plot.ContourValuePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.VerticalValuePlot;
import org.jfree.chart.ui.ColorPalette;
import org.jfree.chart.ui.RainbowPalette;
import org.jfree.data.Range;
import org.jfree.ui.RefineryUtilities;

public class VerticalLogarithmicColorBarAxis
extends VerticalLogarithmicAxis
implements ColorBarAxis,
Serializable {
    public static final int DEFAULT_COLORBAR_THICKNESS = 0;
    public static final double DEFAULT_COLORBAR_THICKNESS_PCT = 0.05;
    public static final int DEFAULT_OUTERGAP = 20;
    private ColorPalette colorPalette = new RainbowPalette();
    private int colorBarLength = 0;
    private int colorBarThickness = 0;
    private double colorBarThicknessPercent = 0.05;
    private int outerGap = 20;

    public VerticalLogarithmicColorBarAxis(String string) {
        super(string);
        this.colorPalette.setMinZ(this.getRange().getLowerBound());
        this.colorPalette.setMaxZ(this.getRange().getUpperBound());
        this.setLowerMargin(0.0);
        this.setUpperMargin(0.0);
        this.colorPalette.setLogscale(true);
    }

    public ColorPalette getColorPalette() {
        return this.colorPalette;
    }

    public Paint getPaint(double d) {
        return this.colorPalette.getPaint(d);
    }

    public void setColorPalette(ColorPalette colorPalette) {
        this.colorPalette = colorPalette;
    }

    public void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof VerticalValuePlot) {
            double d;
            ContourValuePlot contourValuePlot = (ContourValuePlot)((Object)plot);
            Range range = contourValuePlot.getContourDataRange();
            if (range == null) {
                range = new Range(0.0, 1.0);
            }
            double d2 = this.computeLogFloor(range.getLowerBound());
            if (!this.getAllowNegativesFlag() && d2 >= 0.0 && d2 < 1.0E-100) {
                d2 = range.getLowerBound();
            }
            double d3 = range.getUpperBound();
            if (!this.getAllowNegativesFlag() && d3 < 1.0 && d3 > 0.0 && d2 > 0.0) {
                d = Math.log(d3) / VerticalLogarithmicAxis.LOG10_VALUE;
                d = Math.ceil(-d + 0.001);
                d3 = (d = Math.pow(10.0, d)) > 0.0 ? Math.ceil(d3 * d) / d : Math.ceil(d3);
            } else {
                d3 = this.computeLogCeil(d3);
            }
            d = this.getAutoRangeMinimumSize();
            if (d3 - d2 < d) {
                d3 = (d3 + d2 + d) / 2.0;
                d2 = (d3 + d2 - d) / 2.0;
            }
            this.setRangeAttribute(new Range(d2, d3));
            this.setupSmallLogFlag();
            this.colorPalette.setMinZ(d2);
            this.colorPalette.setMaxZ(d3);
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        Object object;
        double d = rectangle2D2.getHeight();
        if (this.colorBarLength > 0) {
            d = this.colorBarLength;
        }
        double d2 = this.colorBarThicknessPercent * rectangle2D2.getWidth();
        if (this.colorBarThickness > 0) {
            d2 = this.colorBarThickness;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D2.getMaxX() + (double)this.outerGap, rectangle2D2.getY(), d2, d);
        this.refreshTicks(graphics2D, rectangle2D, double_, n);
        this.drawColorBar(graphics2D, double_);
        double d3 = ((RectangularShape)double_).getX();
        graphics2D.setFont(this.getTickLabelFont());
        double d4 = -1.0E20;
        Iterator iterator = this.getTicks().iterator();
        while (iterator.hasNext()) {
            object = (Tick)iterator.next();
            float f = (float)this.translateValueToJava2D(((Tick)object).getNumericalValue(), double_);
            if (this.isTickLabelsVisible()) {
                d4 = Math.max(d4, (double)((Tick)object).getX() + this.tickLabelWidth(graphics2D, ((Tick)object).getText()));
                graphics2D.setPaint(this.getTickLabelPaint());
                graphics2D.drawString(((Tick)object).getText(), ((Tick)object).getX(), ((Tick)object).getY());
            }
            if (!this.isTickMarksVisible()) continue;
            graphics2D.setStroke(this.getTickMarkStroke());
            Line2D.Double double_2 = new Line2D.Double(((RectangularShape)double_).getX() + ((RectangularShape)double_).getWidth() - 2.0, f, ((RectangularShape)double_).getX() + ((RectangularShape)double_).getWidth() + 2.0, f);
            graphics2D.draw(double_2);
        }
        if (this.getLabel() != null) {
            graphics2D.setFont(this.getLabelFont());
            graphics2D.setPaint(this.getLabelPaint());
            object = this.getLabelFont().getStringBounds(this.getLabel(), graphics2D.getFontRenderContext());
            if (this.isVerticalLabel()) {
                d3 = d4 + (double)this.getLabelInsets().right + ((RectangularShape)object).getHeight();
                double d5 = ((RectangularShape)double_).getY() + ((RectangularShape)double_).getHeight() / 2.0 + ((RectangularShape)object).getWidth() / 2.0;
                RefineryUtilities.drawRotatedString((String)this.getLabel(), (Graphics2D)graphics2D, (float)((float)d3), (float)((float)d5), (double)-1.5707963267948966);
            } else {
                d3 = ((RectangularShape)double_).getX() + (double)this.getLabelInsets().left;
                double d6 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - ((RectangularShape)object).getHeight() / 2.0;
                graphics2D.drawString(this.getLabel(), (float)d3, (float)d6);
            }
        }
    }

    public void drawColorBar(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.colorPalette.setTickValues(this.getTicks());
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(1.0f));
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getMaxX();
        double d3 = rectangle2D.getY();
        while (d3 <= rectangle2D.getY() + rectangle2D.getHeight()) {
            double d4 = this.translateJava2DtoValue((float)d3, rectangle2D);
            System.out.println(d4);
            Line2D.Double double_ = new Line2D.Double(d, d3, d2, d3);
            graphics2D.setPaint(this.getPaint(d4));
            graphics2D.draw(double_);
            d3 += 1.0;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setStroke(stroke);
    }

    public double tickLabelWidth(Graphics2D graphics2D, String string) {
        Rectangle2D rectangle2D = this.getTickLabelFont().getStringBounds(string, graphics2D.getFontRenderContext());
        return rectangle2D.getWidth();
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof ContourValuePlot;
    }

    public void setMaximumAxisValue(double d) {
        this.colorPalette.setMaxZ(d);
        super.setMaximumAxisValue(d);
    }

    public void setMinimumAxisValue(double d) {
        this.colorPalette.setMinZ(d);
        super.setMinimumAxisValue(d);
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        super.refreshTicks(graphics2D, rectangle2D, rectangle2D2, n);
        Iterator iterator = this.getTicks().iterator();
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            float f = tick.getX();
            String string = tick.getText();
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Rectangle2D rectangle2D3 = this.getTickLabelFont().getStringBounds(string, fontRenderContext);
            f += (float)(rectangle2D3.getWidth() + (double)this.getTickLabelInsets().right);
            f = (float)((double)f + (rectangle2D2.getWidth() + (double)this.colorBarThickness + (double)this.getTickLabelInsets().right));
            float f2 = tick.getY();
            double d = tick.getNumericalValue();
            Tick tick2 = new Tick(new Double(d), string, f += (float)this.getTickLabelInsets().left, f2);
            arrayList.add(tick2);
        }
        this.getTicks().clear();
        this.getTicks().addAll(arrayList);
    }

    public double reserveWidth(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n) {
        double d = super.reserveWidth(graphics2D, plot, rectangle2D, n);
        return d + rectangle2D.getWidth() * this.colorBarThicknessPercent + (double)this.outerGap + (double)this.getTickLabelInsets().left + (double)this.getTickLabelInsets().right;
    }

    public void doAutoRange() {
        this.autoAdjustRange();
    }
}

