/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.jfree.chart.AbstractTitle;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.JFreeChartConstants;
import org.jfree.chart.TextTitle;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.data.DefaultValueDataset;

public class JThermometer
extends JPanel
implements Serializable {
    private DefaultValueDataset data;
    private JFreeChart chart;
    private ChartPanel panel;
    private ThermometerPlot plot = new ThermometerPlot();

    public JThermometer() {
        super(new CardLayout());
        this.plot.setInsets(new Insets(5, 5, 5, 5));
        this.data = new DefaultValueDataset();
        this.plot.setData(this.data);
        this.chart = new JFreeChart(null, JFreeChartConstants.DEFAULT_TITLE_FONT, this.plot, false);
        this.panel = new ChartPanel(this.chart);
        this.add((Component)this.panel, "Panel");
        this.setBackground(this.getBackground());
    }

    public void addSubitle(AbstractTitle abstractTitle) {
        this.chart.addSubtitle(abstractTitle);
    }

    public void addSubtitle(String string) {
        this.chart.addSubtitle(new TextTitle(string));
    }

    public void addSubtitle(String string, Font font) {
        this.chart.addSubtitle(new TextTitle(string, font));
    }

    public void setValueFormat(DecimalFormat decimalFormat) {
        this.plot.setValueFormat(decimalFormat);
    }

    public void setRange(double d, double d2) {
        this.plot.setRange(d, d2);
    }

    public void setSubrangeInfo(int n, double d, double d2) {
        this.plot.setSubrangeInfo(n, d, d2);
    }

    public void setSubrangeInfo(int n, double d, double d2, double d3, double d4) {
        this.plot.setSubrangeInfo(n, d, d2, d3, d4);
    }

    public void setValueLocation(int n) {
        this.plot.setValueLocation(n);
        this.panel.repaint();
    }

    public Number getValue() {
        if (this.data != null) {
            return this.data.getValue();
        }
        return null;
    }

    public void setValue(double d) {
        this.setValue(new Double(d));
    }

    public void setValue(Number number) {
        if (this.data != null) {
            this.data.setValue(number);
        }
    }

    public void setUnits(int n) {
        if (this.plot != null) {
            this.plot.setUnits(n);
        }
    }

    public void setOutlinePaint(Paint paint) {
        if (this.plot != null) {
            this.plot.setOutlinePaint(paint);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.plot != null) {
            this.plot.setThermometerPaint(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.plot != null) {
            this.plot.setBackgroundPaint(color);
        }
        if (this.chart != null) {
            this.chart.setBackgroundPaint(color);
        }
        if (this.panel != null) {
            this.panel.setBackground(color);
        }
    }

    public void setValueFont(Font font) {
        if (this.plot != null) {
            this.plot.setValueFont(font);
        }
    }

    public void setFollowDataInSubranges(boolean bl) {
        this.plot.setFollowDataInSubranges(bl);
    }

    public void setShowValueLines(boolean bl) {
        this.plot.setShowValueLines(bl);
    }
}

