/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.VerticalXYBarRenderer;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.XYDataset;

public class ClusteredXYBarRenderer
extends VerticalXYBarRenderer
implements Serializable {
    private double margin;
    private double translatedRangeZero;
    private boolean centerBarAtStartValue;

    public ClusteredXYBarRenderer() {
        this(0.0, false);
    }

    public ClusteredXYBarRenderer(double d, boolean bl) {
        super(d);
        this.margin = d;
        this.centerBarAtStartValue = bl;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, chartRenderingInfo);
        ValueAxis valueAxis = xYPlot.getRangeAxis();
        this.translatedRangeZero = valueAxis.translateValueToJava2D(0.0, rectangle2D);
    }

    public void setMargin(double d) {
        this.margin = d;
        super.setMargin(d);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, int n3, CrosshairInfo crosshairInfo) {
        EntityCollection entityCollection;
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        Paint paint = this.getItemPaint(n, n2, n3);
        Paint paint2 = this.getItemOutlinePaint(n, n2, n3);
        Number number = intervalXYDataset.getYValue(n2, n3);
        double d = valueAxis2.translateValueToJava2D(number.doubleValue(), rectangle2D);
        Number number2 = intervalXYDataset.getStartXValue(n2, n3);
        double d2 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        Number number3 = intervalXYDataset.getEndXValue(n2, n3);
        double d3 = valueAxis.translateValueToJava2D(number3.doubleValue(), rectangle2D);
        double d4 = Math.max(1.0, d3 - d2);
        double d5 = Math.abs(d - this.translatedRangeZero);
        if (this.centerBarAtStartValue) {
            d2 -= d4 / 2.0;
        }
        if (this.margin > 0.0) {
            double d6 = d4 * this.margin;
            d4 -= d6;
            d2 += d6 / 2.0;
        }
        int n4 = xYDataset.getSeriesCount();
        double d7 = d4 / (double)n4;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2 + d7 * (double)n2, Math.min(this.translatedRangeZero, d), d7, d5);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (d3 - d2 > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2, n3));
            graphics2D.setPaint(paint2);
            graphics2D.draw(double_);
        }
        if (chartRenderingInfo != null && (entityCollection = chartRenderingInfo.getEntityCollection()) != null) {
            String string = null;
            if (this.getToolTipGenerator() != null) {
                string = this.getToolTipGenerator().generateToolTip(xYDataset, n2, n3);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n2, n3);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, string, string2, n2, n3);
            entityCollection.addEntity(xYItemEntity);
        }
    }
}

