/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.tooltips.XYToolTipGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.WindDataset;
import org.jfree.data.XYDataset;

public class WindItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Serializable {
    public WindItemRenderer() {
        this(null, null);
    }

    public WindItemRenderer(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(xYToolTipGenerator, xYURLGenerator);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, int n3, CrosshairInfo crosshairInfo) {
        WindDataset windDataset = (WindDataset)xYDataset;
        Paint paint = this.getItemPaint(n, n2, n3);
        Stroke stroke = this.getItemStroke(n, n2, n3);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = windDataset.getXValue(n2, n3);
        Number number2 = windDataset.getWindDirection(n2, n3);
        Number number3 = windDataset.getWindForce(n2, n3);
        double d = number3.doubleValue();
        double d2 = Math.toRadians(number2.doubleValue() * -30.0 - 90.0);
        double d3 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        double d4 = valueAxis2.translateValueToJava2D(0.0, rectangle2D);
        double d5 = number.doubleValue() + d * Math.cos(d2) * 8000000.0;
        double d6 = d * Math.sin(d2);
        double d7 = valueAxis.translateValueToJava2D(d5, rectangle2D);
        double d8 = valueAxis2.translateValueToJava2D(d6, rectangle2D);
        int n4 = number2.intValue();
        int n5 = number3.intValue();
        String string = n4 + "-" + n5;
        Line2D.Double double_ = new Line2D.Double(d3, d4, d7, d8);
        graphics2D.draw(double_);
        graphics2D.setPaint(Color.blue);
        graphics2D.setFont(new Font("foo", 1, 9));
        graphics2D.drawString(string, (float)d3, (float)d4);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        double d9 = Math.toRadians(number2.doubleValue() * -30.0 - 90.0 - 5.0);
        double d10 = number3.doubleValue() * Math.cos(d9) * 8000000.0 * 0.8 + number.doubleValue();
        double d11 = number3.doubleValue() * Math.sin(d9) * 0.8;
        double d12 = valueAxis.translateValueToJava2D(d10, rectangle2D);
        double d13 = valueAxis2.translateValueToJava2D(d11, rectangle2D);
        double_ = new Line2D.Double(d12, d13, d7, d8);
        graphics2D.draw(double_);
        double d14 = Math.toRadians(number2.doubleValue() * -30.0 - 90.0 + 5.0);
        double d15 = number3.doubleValue() * Math.cos(d14) * 8000000.0 * 0.8 + number.doubleValue();
        double d16 = number3.doubleValue() * Math.sin(d14) * 0.8;
        double d17 = valueAxis.translateValueToJava2D(d15, rectangle2D);
        double d18 = valueAxis2.translateValueToJava2D(d16, rectangle2D);
        double_ = new Line2D.Double(d17, d18, d7, d8);
        graphics2D.draw(double_);
    }
}

