/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.tooltips.XYToolTipGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.XYDataset;

public class XYStepRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Serializable {
    private transient Line2D line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);

    public XYStepRenderer() {
        this(null, null);
    }

    public XYStepRenderer(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(xYToolTipGenerator, xYURLGenerator);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, int n3, CrosshairInfo crosshairInfo) {
        Paint paint = this.getItemPaint(n, n2, n3);
        Stroke stroke = this.getItemStroke(n, n2, n3);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getXValue(n2, n3);
        Number number2 = xYDataset.getYValue(n2, n3);
        if (number2 == null) {
            return;
        }
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        if (n3 > 0) {
            Number number3 = xYDataset.getXValue(n2, n3 - 1);
            Number number4 = xYDataset.getYValue(n2, n3 - 1);
            if (number4 != null) {
                double d3 = valueAxis.translateValueToJava2D(number3.doubleValue(), rectangle2D);
                double d4 = valueAxis2.translateValueToJava2D(number4.doubleValue(), rectangle2D);
                if (d4 == d2) {
                    this.line.setLine(d3, d4, d, d2);
                    graphics2D.draw(this.line);
                } else {
                    this.line.setLine(d3, d4, d, d4);
                    graphics2D.draw(this.line);
                    this.line.setLine(d, d4, d, d2);
                    graphics2D.draw(this.line);
                }
            }
        }
        if (xYPlot.isDomainCrosshairLockedOnData()) {
            if (xYPlot.isRangeCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairPoint(number.doubleValue(), number2.doubleValue());
            } else {
                crosshairInfo.updateCrosshairX(number.doubleValue());
            }
        } else if (xYPlot.isRangeCrosshairLockedOnData()) {
            crosshairInfo.updateCrosshairY(number2.doubleValue());
        }
    }
}

