/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.ui;

import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.jfree.chart.axis.Tick;

public abstract class ColorPalette
implements Serializable {
    protected double minZ = -1.0;
    protected double maxZ = -1.0;
    protected int[] r;
    protected int[] g;
    protected int[] b;
    protected double[] tickValues = null;
    protected boolean logscale = false;
    protected boolean inverse = false;
    protected String paletteName = null;
    protected boolean stepped = false;
    protected static final double log10 = Math.log(10.0);

    public Paint getColor(double d) {
        int n = (int)(253.0 * (d - this.minZ) / (this.maxZ - this.minZ)) + 2;
        return new Color(this.r[n], this.g[n], this.b[n]);
    }

    public Color getColor(int n) {
        return new Color(this.r[n], this.g[n], this.b[n]);
    }

    public Color getColorLinear(double d) {
        int n = 0;
        if (this.stepped) {
            int n2 = this.tickValues.length;
            int n3 = Arrays.binarySearch(this.tickValues, d);
            if (n3 < 0) {
                n3 = -1 * n3 - 2;
            }
            d = n3 < 0 ? this.minZ : this.tickValues[n3];
        }
        n = (int)(253.0 * (d - this.minZ) / (this.maxZ - this.minZ)) + 2;
        n = Math.min(n, 255);
        n = Math.max(n, 2);
        return this.getColor(n);
    }

    public Color getColorLog(double d) {
        int n = 0;
        double d2 = this.minZ;
        double d3 = this.maxZ;
        if (this.minZ <= 0.0) {
            this.maxZ = d3 - d2 + 1.0;
            this.minZ = 1.0;
            d = d - d2 + 1.0;
        }
        double d4 = Math.log(this.minZ) / log10;
        double d5 = Math.log(this.maxZ) / log10;
        d = Math.log(d) / log10;
        if (this.stepped) {
            int n2 = this.tickValues.length;
            int n3 = 256 / (n2 - 1);
            n = n3 * (int)((double)n2 * (d - d4) / (d5 - d4)) + 2;
        } else {
            n = (int)(253.0 * (d - d4) / (d5 - d4)) + 2;
        }
        n = Math.min(n, 255);
        n = Math.max(n, 2);
        this.minZ = d2;
        this.maxZ = d3;
        return this.getColor(n);
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public Paint getPaint(double d) {
        if (this.isLogscale()) {
            return this.getColorLog(d);
        }
        return this.getColorLinear(d);
    }

    public String getPaletteName() {
        return this.paletteName;
    }

    public double[] getTickValues() {
        return this.tickValues;
    }

    public abstract void initialize();

    public void invertPalette() {
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[256];
        int n = 0;
        while (n < 256) {
            nArray[n] = this.r[n];
            nArray2[n] = this.g[n];
            nArray3[n] = this.b[n];
            ++n;
        }
        int n2 = 2;
        while (n2 < 256) {
            this.r[n2] = nArray[257 - n2];
            this.g[n2] = nArray2[257 - n2];
            this.b[n2] = nArray3[257 - n2];
            ++n2;
        }
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public boolean isLogscale() {
        return this.logscale;
    }

    public boolean isStepped() {
        return this.stepped;
    }

    public void setInverse(boolean bl) {
        this.inverse = bl;
        this.initialize();
        if (bl) {
            this.invertPalette();
        }
    }

    public void setLogscale(boolean bl) {
        this.logscale = bl;
    }

    public void setMaxZ(double d) {
        this.maxZ = d;
    }

    public void setMinZ(double d) {
        this.minZ = d;
    }

    public void setPaletteName(String string) {
        String string2 = this.paletteName;
        this.paletteName = string;
    }

    public void setStepped(boolean bl) {
        this.stepped = bl;
    }

    public void setTickValues(double[] dArray) {
        this.tickValues = dArray;
    }

    public void setTickValues(List list) {
        this.tickValues = new double[list.size()];
        int n = 0;
        while (n < this.tickValues.length) {
            this.tickValues[n] = ((Tick)list.get(n)).getNumericalValue();
            ++n;
        }
    }
}

