/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.ui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.ContourPlot;
import org.jfree.chart.plot.HorizontalValuePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.VerticalValuePlot;
import org.jfree.chart.ui.AxisPropertyEditPanel;
import org.jfree.chart.ui.ColorBarPropertyEditPanel;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.InsetsChooserPanel;
import org.jfree.ui.InsetsTextField;
import org.jfree.ui.PaintSample;
import org.jfree.ui.StrokeChooserPanel;
import org.jfree.ui.StrokeSample;

public class PlotPropertyEditPanel
extends JPanel
implements ActionListener {
    private PaintSample backgroundPaintSample;
    private StrokeSample outlineStrokeSample;
    private PaintSample outlinePaintSample;
    private AxisPropertyEditPanel domainAxisPropertyPanel;
    private AxisPropertyEditPanel rangeAxisPropertyPanel;
    private AxisPropertyEditPanel colorBarAxisPropertyPanel;
    private StrokeSample[] availableStrokeSamples;
    private Insets plotInsets;
    private InsetsTextField insetsTextField;

    public PlotPropertyEditPanel(Plot plot) {
        this.plotInsets = plot.getInsets();
        this.backgroundPaintSample = new PaintSample(plot.getBackgroundPaint());
        this.outlineStrokeSample = new StrokeSample(plot.getOutlineStroke());
        this.outlinePaintSample = new PaintSample(plot.getOutlinePaint());
        this.setLayout(new BorderLayout());
        this.availableStrokeSamples = new StrokeSample[3];
        this.availableStrokeSamples[0] = new StrokeSample((Stroke)new BasicStroke(1.0f));
        this.availableStrokeSamples[1] = new StrokeSample((Stroke)new BasicStroke(2.0f));
        this.availableStrokeSamples[2] = new StrokeSample((Stroke)new BasicStroke(3.0f));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), plot.getPlotType() + ":"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General:"));
        JPanel jPanel3 = new JPanel((LayoutManager)new LCBLayout(4));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jPanel3.add(new JLabel("Insets:"));
        JButton jButton = new JButton("Edit...");
        jButton.setActionCommand("Insets");
        jButton.addActionListener(this);
        this.insetsTextField = new InsetsTextField(this.plotInsets);
        this.insetsTextField.setEnabled(false);
        jPanel3.add((Component)this.insetsTextField);
        jPanel3.add(jButton);
        jPanel3.add(new JLabel("Outline stroke:"));
        jButton = new JButton("Select...");
        jButton.setActionCommand("OutlineStroke");
        jButton.addActionListener(this);
        jPanel3.add((Component)this.outlineStrokeSample);
        jPanel3.add(jButton);
        jPanel3.add(new JLabel("Outline paint:"));
        jButton = new JButton("Select...");
        jButton.setActionCommand("OutlinePaint");
        jButton.addActionListener(this);
        jPanel3.add((Component)this.outlinePaintSample);
        jPanel3.add(jButton);
        jPanel3.add(new JLabel("Background paint:"));
        jButton = new JButton("Select...");
        jButton.setActionCommand("BackgroundPaint");
        jButton.addActionListener(this);
        jPanel3.add((Component)this.backgroundPaintSample);
        jPanel3.add(jButton);
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel4.add((Component)jPanel2, "North");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        Axis axis = null;
        if (plot instanceof CategoryPlot) {
            axis = ((CategoryPlot)plot).getDomainAxis();
        } else if (plot instanceof HorizontalValuePlot) {
            axis = ((HorizontalValuePlot)((Object)plot)).getHorizontalValueAxis();
        }
        this.domainAxisPropertyPanel = AxisPropertyEditPanel.getInstance(axis);
        if (this.domainAxisPropertyPanel != null) {
            this.domainAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            jTabbedPane.add("Domain Axis", this.domainAxisPropertyPanel);
        }
        ValueAxis valueAxis = null;
        if (plot instanceof CategoryPlot) {
            valueAxis = ((CategoryPlot)plot).getRangeAxis();
        } else if (plot instanceof VerticalValuePlot) {
            valueAxis = ((VerticalValuePlot)((Object)plot)).getVerticalValueAxis();
        }
        this.rangeAxisPropertyPanel = AxisPropertyEditPanel.getInstance(valueAxis);
        if (this.rangeAxisPropertyPanel != null) {
            this.rangeAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            jTabbedPane.add("Range Axis", this.rangeAxisPropertyPanel);
        }
        ValueAxis valueAxis2 = null;
        if (plot instanceof ContourPlot) {
            valueAxis2 = ((ContourPlot)plot).getColorBarValueAxis();
        }
        this.colorBarAxisPropertyPanel = ColorBarPropertyEditPanel.getInstance(valueAxis2);
        if (this.colorBarAxisPropertyPanel != null) {
            this.colorBarAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            jTabbedPane.add("Color Bar", this.colorBarAxisPropertyPanel);
        }
        jTabbedPane.add("Appearance", jPanel4);
        jPanel.add(jTabbedPane);
        this.add(jPanel);
    }

    public Insets getPlotInsets() {
        if (this.plotInsets == null) {
            this.plotInsets = new Insets(0, 0, 0, 0);
        }
        return this.plotInsets;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaintSample.getPaint();
    }

    public Stroke getOutlineStroke() {
        return this.outlineStrokeSample.getStroke();
    }

    public Paint getOutlinePaint() {
        return this.outlinePaintSample.getPaint();
    }

    public AxisPropertyEditPanel getDomainAxisPropertyEditPanel() {
        return this.domainAxisPropertyPanel;
    }

    public AxisPropertyEditPanel getRangeAxisPropertyEditPanel() {
        return this.rangeAxisPropertyPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("BackgroundPaint")) {
            this.attemptBackgroundPaintSelection();
        } else if (string.equals("OutlineStroke")) {
            this.attemptOutlineStrokeSelection();
        } else if (string.equals("OutlinePaint")) {
            this.attemptOutlinePaintSelection();
        } else if (string.equals("Insets")) {
            this.editInsets();
        }
    }

    private void attemptBackgroundPaintSelection() {
        Color color = JColorChooser.showDialog(this, "Background Color", Color.blue);
        if (color != null) {
            this.backgroundPaintSample.setPaint((Paint)color);
        }
    }

    private void attemptOutlineStrokeSelection() {
        StrokeChooserPanel strokeChooserPanel = new StrokeChooserPanel(null, this.availableStrokeSamples);
        int n = JOptionPane.showConfirmDialog(this, strokeChooserPanel, "Stroke Selection", 2, -1);
        if (n == 0) {
            this.outlineStrokeSample.setStroke(strokeChooserPanel.getSelectedStroke());
        }
    }

    private void attemptOutlinePaintSelection() {
        Color color = JColorChooser.showDialog(this, "Outline Color", Color.blue);
        if (color != null) {
            this.outlinePaintSample.setPaint((Paint)color);
        }
    }

    private void editInsets() {
        InsetsChooserPanel insetsChooserPanel = new InsetsChooserPanel(this.plotInsets);
        int n = JOptionPane.showConfirmDialog(this, insetsChooserPanel, "Edit Insets", 2, -1);
        if (n == 0) {
            this.plotInsets = insetsChooserPanel.getInsets();
            this.insetsTextField.setInsets(this.plotInsets);
        }
    }

    public void updatePlotProperties(Plot plot) {
        Object object;
        Axis axis;
        plot.setOutlinePaint(this.getOutlinePaint());
        plot.setOutlineStroke(this.getOutlineStroke());
        plot.setBackgroundPaint(this.getBackgroundPaint());
        plot.setInsets(this.getPlotInsets());
        if (this.domainAxisPropertyPanel != null) {
            axis = null;
            if (plot instanceof CategoryPlot) {
                object = (CategoryPlot)plot;
                axis = ((CategoryPlot)object).getDomainAxis();
            } else if (plot instanceof HorizontalValuePlot) {
                object = (HorizontalValuePlot)((Object)plot);
                axis = object.getHorizontalValueAxis();
            }
            if (axis != null) {
                this.domainAxisPropertyPanel.setAxisProperties(axis);
            }
        }
        if (this.rangeAxisPropertyPanel != null) {
            axis = null;
            if (plot instanceof CategoryPlot) {
                object = (CategoryPlot)plot;
                axis = ((CategoryPlot)object).getRangeAxis();
            } else if (plot instanceof VerticalValuePlot) {
                object = (VerticalValuePlot)((Object)plot);
                axis = object.getVerticalValueAxis();
            }
            if (axis != null) {
                this.rangeAxisPropertyPanel.setAxisProperties(axis);
            }
        }
        if (this.colorBarAxisPropertyPanel != null) {
            axis = null;
            if (plot instanceof ContourPlot) {
                object = (ContourPlot)plot;
                axis = ((ContourPlot)object).getColorBarValueAxis();
            }
            if (axis != null) {
                this.colorBarAxisPropertyPanel.setAxisProperties(axis);
            }
        }
    }
}

