/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jfree.data.Series;
import org.jfree.data.SeriesException;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeriesDataItem;

public class TimeSeries
extends Series
implements Serializable {
    protected static final String DEFAULT_DOMAIN_DESCRIPTION = "Time";
    protected static final String DEFAULT_RANGE_DESCRIPTION = "Value";
    private String domain;
    private String range;
    private Class timePeriodClass;
    private List data;
    private int maximumItemCount;
    private int historyCount;
    static /* synthetic */ Class class$org$jfree$data$time$Day;

    public TimeSeries(String string) {
        this(string, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION, class$org$jfree$data$time$Day == null ? (class$org$jfree$data$time$Day = TimeSeries.class$("org.jfree.data.time.Day")) : class$org$jfree$data$time$Day);
    }

    public TimeSeries(String string, Class clazz) {
        this(string, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION, clazz);
    }

    public TimeSeries(String string, String string2, String string3, Class clazz) {
        super(string);
        this.domain = string2;
        this.range = string3;
        this.timePeriodClass = clazz;
        this.data = new ArrayList();
        this.maximumItemCount = Integer.MAX_VALUE;
        this.historyCount = 0;
    }

    public String getDomainDescription() {
        return this.domain;
    }

    public void setDomainDescription(String string) {
        String string2 = this.domain;
        this.domain = string;
        this.firePropertyChange("Domain", string2, string);
    }

    public String getRangeDescription() {
        return this.range;
    }

    public void setRangeDescription(String string) {
        String string2 = this.range;
        this.range = string;
        this.firePropertyChange("Range", string2, string);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int n) {
        this.maximumItemCount = n;
    }

    public int getHistoryCount() {
        return this.historyCount;
    }

    public void setHistoryCount(int n) {
        this.historyCount = n;
    }

    public Class getTimePeriodClass() {
        return this.timePeriodClass;
    }

    public TimeSeriesDataItem getDataPair(int n) {
        return (TimeSeriesDataItem)this.data.get(n);
    }

    public TimeSeriesDataItem getDataPair(RegularTimePeriod regularTimePeriod) {
        if (regularTimePeriod == null) {
            throw new IllegalArgumentException("TimeSeries.getDataPair(...): null time period not allowed.");
        }
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, new Integer(0));
        int n = Collections.binarySearch(this.data, timeSeriesDataItem);
        if (n >= 0) {
            return (TimeSeriesDataItem)this.data.get(n);
        }
        return null;
    }

    public RegularTimePeriod getTimePeriod(int n) {
        return this.getDataPair(n).getPeriod();
    }

    public RegularTimePeriod getNextTimePeriod() {
        RegularTimePeriod regularTimePeriod = this.getTimePeriod(this.getItemCount() - 1);
        return regularTimePeriod.next();
    }

    public Collection getTimePeriods() {
        ArrayList<RegularTimePeriod> arrayList = new ArrayList<RegularTimePeriod>();
        int n = 0;
        while (n < this.getItemCount()) {
            arrayList.add(this.getTimePeriod(n));
            ++n;
        }
        return arrayList;
    }

    public Collection getTimePeriodsUniqueToOtherSeries(TimeSeries timeSeries) {
        ArrayList<RegularTimePeriod> arrayList = new ArrayList<RegularTimePeriod>();
        int n = 0;
        while (n < timeSeries.getItemCount()) {
            RegularTimePeriod regularTimePeriod = timeSeries.getTimePeriod(n);
            int n2 = this.getIndex(regularTimePeriod);
            if (n2 < 0) {
                arrayList.add(regularTimePeriod);
            }
            ++n;
        }
        return arrayList;
    }

    public int getIndex(RegularTimePeriod regularTimePeriod) {
        if (regularTimePeriod != null) {
            TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, new Integer(0));
            int n = Collections.binarySearch(this.data, timeSeriesDataItem);
            return n;
        }
        return -1;
    }

    public Number getValue(int n) {
        return this.getDataPair(n).getValue();
    }

    public Number getValue(RegularTimePeriod regularTimePeriod) {
        int n = this.getIndex(regularTimePeriod);
        if (n >= 0) {
            return this.getValue(n);
        }
        return null;
    }

    public void add(TimeSeriesDataItem timeSeriesDataItem) throws SeriesException {
        if (timeSeriesDataItem == null) {
            throw new IllegalArgumentException("TimeSeries.add(...): null item not allowed.");
        }
        if (!timeSeriesDataItem.getPeriod().getClass().equals(this.timePeriodClass)) {
            String string = "TimeSeries.add(): you are trying to add data where the time ";
            string = string + "period class is " + timeSeriesDataItem.getPeriod().getClass().getName() + ", ";
            string = string + "but the TimeSeries is expecting an instance of " + this.timePeriodClass.getName() + ".";
            throw new SeriesException(string);
        }
        int n = Collections.binarySearch(this.data, timeSeriesDataItem);
        if (n < 0) {
            this.data.add(-n - 1, timeSeriesDataItem);
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
            if (this.getItemCount() > 1 && this.historyCount > 0) {
                long l = this.getTimePeriod(this.getItemCount() - 1).getSerialIndex();
                while (l - this.getTimePeriod(0).getSerialIndex() >= (long)this.historyCount) {
                    this.data.remove(0);
                }
            }
        } else {
            throw new SeriesException("TimeSeries.add(...): time period already exists.");
        }
        this.fireSeriesChanged();
    }

    public void add(RegularTimePeriod regularTimePeriod, double d) throws SeriesException {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, d);
        this.add(timeSeriesDataItem);
    }

    public void add(RegularTimePeriod regularTimePeriod, Number number) throws SeriesException {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, number);
        this.add(timeSeriesDataItem);
    }

    public void update(RegularTimePeriod regularTimePeriod, Number number) throws SeriesException {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, number);
        int n = Collections.binarySearch(this.data, timeSeriesDataItem);
        if (n < 0) {
            throw new SeriesException("TimeSeries.update(TimePeriod, Number): period does not exist.");
        }
        TimeSeriesDataItem timeSeriesDataItem2 = (TimeSeriesDataItem)this.data.get(n);
        timeSeriesDataItem2.setValue(number);
        this.fireSeriesChanged();
    }

    public void update(int n, Number number) {
        TimeSeriesDataItem timeSeriesDataItem = this.getDataPair(n);
        timeSeriesDataItem.setValue(number);
        this.fireSeriesChanged();
    }

    public TimeSeries addAndOrUpdate(TimeSeries timeSeries) {
        TimeSeries timeSeries2 = new TimeSeries("Overwritten values from: " + this.getName());
        int n = 0;
        while (n < timeSeries.getItemCount()) {
            TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataPair(n);
            TimeSeriesDataItem timeSeriesDataItem2 = this.addOrUpdate(timeSeriesDataItem.getPeriod(), timeSeriesDataItem.getValue());
            if (timeSeriesDataItem2 != null) {
                try {
                    timeSeries2.add(timeSeriesDataItem2);
                }
                catch (SeriesException seriesException) {
                    System.err.println("TimeSeries.addAndOrUpdate(series): unable to add data to overwritten series.");
                }
            }
            ++n;
        }
        return timeSeries2;
    }

    public TimeSeriesDataItem addOrUpdate(RegularTimePeriod regularTimePeriod, Number number) {
        TimeSeriesDataItem timeSeriesDataItem = null;
        TimeSeriesDataItem timeSeriesDataItem2 = new TimeSeriesDataItem(regularTimePeriod, number);
        int n = Collections.binarySearch(this.data, timeSeriesDataItem2);
        if (n >= 0) {
            TimeSeriesDataItem timeSeriesDataItem3 = (TimeSeriesDataItem)this.data.get(n);
            timeSeriesDataItem = (TimeSeriesDataItem)timeSeriesDataItem3.clone();
            timeSeriesDataItem3.setValue(number);
            this.fireSeriesChanged();
        } else {
            this.data.add(-n - 1, new TimeSeriesDataItem(regularTimePeriod, number));
            this.fireSeriesChanged();
        }
        return timeSeriesDataItem;
    }

    public void delete(RegularTimePeriod regularTimePeriod) {
        int n = this.getIndex(regularTimePeriod);
        this.data.remove(n);
    }

    public void delete(int n, int n2) {
        int n3 = 0;
        while (n3 <= n2 - n) {
            this.data.remove(n);
            ++n3;
        }
        this.fireSeriesChanged();
    }

    public Object clone() {
        TimeSeries timeSeries = this.createCopy(0, this.getItemCount() - 1);
        return timeSeries;
    }

    public TimeSeries createCopy(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)super.clone();
        timeSeries.data = new ArrayList();
        if (this.data.size() > 0) {
            int n3 = n;
            while (n3 <= n2) {
                TimeSeriesDataItem timeSeriesDataItem = (TimeSeriesDataItem)this.data.get(n3);
                TimeSeriesDataItem timeSeriesDataItem2 = (TimeSeriesDataItem)timeSeriesDataItem.clone();
                try {
                    timeSeries.add(timeSeriesDataItem2);
                }
                catch (SeriesException seriesException) {
                    System.err.println("TimeSeries.createCopy(): unable to add cloned data pair.");
                }
                ++n3;
            }
        }
        return timeSeries;
    }

    public TimeSeries createCopy(RegularTimePeriod regularTimePeriod, RegularTimePeriod regularTimePeriod2) {
        int n = this.getIndex(regularTimePeriod);
        int n2 = this.getIndex(regularTimePeriod2);
        TimeSeries timeSeries = this.createCopy(n, n2);
        return timeSeries;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof TimeSeries) {
            TimeSeries timeSeries = (TimeSeries)object;
            int n = this.getItemCount();
            boolean bl2 = true;
            if (timeSeries.getItemCount() == n) {
                int n2 = 0;
                while (n2 < n) {
                    boolean bl3 = bl2 = bl2 && this.getDataPair(n2).equals(timeSeries.getDataPair(n2));
                    if (!bl2) {
                        // empty if block
                    }
                    ++n2;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

