/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jfree.ui.NumberCellRenderer;

public class RefineryUtilities {
    private static boolean useDrawRotatedStringWorkaround = true;
    static /* synthetic */ Class class$java$lang$Number;

    public static void setUseDrawRotatedStringWorkaround(boolean bl) {
        useDrawRotatedStringWorkaround = bl;
    }

    public static void centerFrameOnScreen(Window window) {
        RefineryUtilities.positionFrameOnScreen(window, 0.5, 0.5);
    }

    public static void positionFrameOnScreen(Window window, double d, double d2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        int n = Math.max(dimension.width - dimension2.width, 0);
        int n2 = Math.max(dimension.height - dimension2.height, 0);
        int n3 = (int)(d * (double)n);
        int n4 = (int)(d2 * (double)n2);
        window.setBounds(n3, n4, dimension2.width, dimension2.height);
    }

    public static void positionFrameRandomly(Window window) {
        RefineryUtilities.positionFrameOnScreen(window, Math.random(), Math.random());
    }

    public static void centerDialogInParent(Dialog dialog) {
        RefineryUtilities.positionDialogRelativeToParent(dialog, 0.5, 0.5);
    }

    public static void positionDialogRelativeToParent(Dialog dialog, double d, double d2) {
        Dimension dimension = dialog.getSize();
        Container container = dialog.getParent();
        Dimension dimension2 = container.getSize();
        int n = container.getX() - dimension.width;
        int n2 = container.getY() - dimension.height;
        int n3 = dimension.width + dimension2.width;
        int n4 = dimension.height + dimension2.height;
        int n5 = n + (int)(d * (double)n3);
        int n6 = n2 + (int)(d2 * (double)n4);
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        n5 = Math.min(n5, dimension3.width - dimension.width);
        n5 = Math.max(n5, 0);
        n6 = Math.min(n6, dimension3.height - dimension.height);
        n6 = Math.max(n6, 0);
        dialog.setBounds(n5, n6, dimension.width, dimension.height);
    }

    public static JPanel createTablePanel(TableModel tableModel) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTable jTable = new JTable(tableModel);
        int n = 0;
        while (n < tableModel.getColumnCount()) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
            Class<?> clazz = tableModel.getColumnClass(n);
            if (clazz.equals(class$java$lang$Number == null ? RefineryUtilities.class$("java.lang.Number") : class$java$lang$Number)) {
                tableColumn.setCellRenderer(new NumberCellRenderer());
            }
            ++n;
        }
        jPanel.add(new JScrollPane(jTable));
        return jPanel;
    }

    public static JLabel createJLabel(String string, Font font) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(font);
        return jLabel;
    }

    public static JLabel createJLabel(String string, Font font, Color color) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(font);
        jLabel.setForeground(color);
        return jLabel;
    }

    public static JButton createJButton(String string, Font font) {
        JButton jButton = new JButton(string);
        jButton.setFont(font);
        return jButton;
    }

    public static void drawRotatedString(String string, Graphics2D graphics2D, float f, float f2, double d) {
        if (string == null || string.equals("")) {
            return;
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(d, f, f2);
        graphics2D.transform(affineTransform2);
        if (useDrawRotatedStringWorkaround) {
            TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
            textLayout.draw(graphics2D, f, f2);
        } else {
            graphics2D.drawString(string, f, f2);
        }
        graphics2D.setTransform(affineTransform);
    }

    public static Point2D getPointInRectangle(double d, double d2, Rectangle2D rectangle2D) {
        d = Math.max(rectangle2D.getMinX(), Math.min(d, rectangle2D.getMaxX()));
        d2 = Math.max(rectangle2D.getMinY(), Math.min(d2, rectangle2D.getMaxY()));
        return new Point2D.Double(d, d2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

