/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RkRec;
import org.apache.poi.hssf.util.RKUtil;
import org.apache.poi.util.LittleEndian;

public class MulRKRecord
extends Record {
    public static final short sid = 189;
    private short field_1_row;
    private short field_2_first_col;
    private ArrayList field_3_rks;
    private short field_4_last_col;

    public MulRKRecord() {
    }

    public MulRKRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public MulRKRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public short getRow() {
        return this.field_1_row;
    }

    public short getFirstColumn() {
        return this.field_2_first_col;
    }

    public short getLastColumn() {
        return this.field_4_last_col;
    }

    public int getNumColumns() {
        return this.field_4_last_col - this.field_2_first_col + 1;
    }

    public short getXFAt(int coffset) {
        return ((RkRec)this.field_3_rks.get((int)coffset)).xf;
    }

    public double getRKNumberAt(int coffset) {
        return RKUtil.decodeNumber(((RkRec)this.field_3_rks.get((int)coffset)).rk);
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_row = LittleEndian.getShort(data, 0 + offset);
        this.field_2_first_col = LittleEndian.getShort(data, 2 + offset);
        this.field_3_rks = this.parseRKs(data, 4, offset, size);
        this.field_4_last_col = LittleEndian.getShort(data, this.field_3_rks.size() * 6 + 4 + offset);
    }

    private ArrayList parseRKs(byte[] data, int offset, int recoffset, short size) {
        ArrayList<RkRec> retval = new ArrayList<RkRec>();
        while (offset < size - 2) {
            RkRec rec = new RkRec();
            rec.xf = LittleEndian.getShort(data, offset + recoffset);
            rec.rk = LittleEndian.getInt(data, (offset += 2) + recoffset);
            offset += 4;
            retval.add(rec);
        }
        return retval;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[MULRK]\n");
        buffer.append("firstcol  = ").append(Integer.toHexString(this.getFirstColumn())).append("\n");
        buffer.append(" lastcol  = ").append(Integer.toHexString(this.getLastColumn())).append("\n");
        int k = 0;
        while (k < this.getNumColumns()) {
            buffer.append("xf").append(k).append("        = ").append(Integer.toHexString(this.getXFAt(k))).append("\n");
            buffer.append("rk").append(k).append("        = ").append(this.getRKNumberAt(k)).append("\n");
            ++k;
        }
        buffer.append("[/MULRK]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 189) {
            throw new RecordFormatException("Not a MulRKRecord!");
        }
    }

    public short getSid() {
        return 189;
    }

    public int serialize(int offset, byte[] data) {
        throw new RecordFormatException("Sorry, you can't serialize a MulRK in this release");
    }
}

