/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.File;

public class POIFSDocumentPath {
    private String[] components;
    private int hashcode = 0;

    public POIFSDocumentPath(String[] components) throws IllegalArgumentException {
        if (components == null) {
            this.components = new String[0];
        } else {
            this.components = new String[components.length];
            int j = 0;
            while (j < components.length) {
                if (components[j] == null || components[j].length() == 0) {
                    throw new IllegalArgumentException("components cannot contain null or empty strings");
                }
                this.components[j] = components[j];
                ++j;
            }
        }
    }

    public POIFSDocumentPath() {
        this.components = new String[0];
    }

    public POIFSDocumentPath(POIFSDocumentPath path, String[] components) throws IllegalArgumentException {
        this.components = components == null ? new String[path.components.length] : new String[path.components.length + components.length];
        int j = 0;
        while (j < path.components.length) {
            this.components[j] = path.components[j];
            ++j;
        }
        if (components != null) {
            int j2 = 0;
            while (j2 < components.length) {
                if (components[j2] == null || components[j2].length() == 0) {
                    throw new IllegalArgumentException("components cannot contain null or empty strings");
                }
                this.components[j2 + path.components.length] = components[j2];
                ++j2;
            }
        }
    }

    public boolean equals(Object o) {
        boolean rval = false;
        if (o != null && o.getClass() == this.getClass()) {
            if (this == o) {
                rval = true;
            } else {
                POIFSDocumentPath path = (POIFSDocumentPath)o;
                if (path.components.length == this.components.length) {
                    rval = true;
                    int j = 0;
                    while (j < this.components.length) {
                        if (!path.components[j].equals(this.components[j])) {
                            rval = false;
                            break;
                        }
                        ++j;
                    }
                }
            }
        }
        return rval;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            int j = 0;
            while (j < this.components.length) {
                this.hashcode += this.components[j].hashCode();
                ++j;
            }
        }
        return this.hashcode;
    }

    public int length() {
        return this.components.length;
    }

    public String getComponent(int n) throws ArrayIndexOutOfBoundsException {
        return this.components[n];
    }

    public POIFSDocumentPath getParent() {
        int length = this.components.length - 1;
        if (length < 0) {
            return null;
        }
        POIFSDocumentPath parent = new POIFSDocumentPath(null);
        parent.components = new String[length];
        System.arraycopy(this.components, 0, parent.components, 0, length);
        return parent;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        int l = this.length();
        b.append(File.separatorChar);
        int i = 0;
        while (i < l) {
            b.append(this.getComponent(i));
            if (i < l - 1) {
                b.append(File.separatorChar);
            }
            ++i;
        }
        return b.toString();
    }
}

