/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobImpl
implements Blob {
    public static final String cvsVersion = "$Id: BlobImpl.java,v 1.4 2004/02/06 19:25:32 bheineman Exp $";
    private byte[] _blob;

    BlobImpl(byte[] blob) throws SQLException {
        if (blob == null) {
            throw new SQLException("blob cannot be null.");
        }
        this._blob = blob;
    }

    public synchronized InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this._blob);
    }

    public synchronized byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 0L) {
            throw new SQLException("pos must be >= 0.");
        }
        if (pos >= (long)(this._blob.length - 1)) {
            throw new SQLException("pos must be < length of blob.");
        }
        if (pos > Integer.MAX_VALUE) {
            throw new SQLException("pos must be <= 2147483647");
        }
        if (length < 0) {
            throw new SQLException("length must be >= 0.");
        }
        if (pos + (long)length > (long)this._blob.length) {
            throw new SQLException("more bytes requested than exist in blob.");
        }
        byte[] value = new byte[length];
        System.arraycopy(this._blob, (int)pos, value, 0, length);
        return value;
    }

    public synchronized long length() throws SQLException {
        return this._blob.length;
    }

    public synchronized long position(Blob pattern, long start) throws SQLException {
        if (pattern == null) {
            throw new SQLException("pattern cannot be null.");
        }
        long length = pattern.length();
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("pattern.length() must be <= 2147483647");
        }
        return this.position(pattern.getBytes(0L, (int)length), start);
    }

    public synchronized long position(byte[] pattern, long start) throws SQLException {
        int length = this._blob.length - pattern.length;
        if (pattern == null) {
            throw new SQLException("pattern cannot be null.");
        }
        if (start < 0L) {
            throw new SQLException("start must be >= 0.");
        }
        if (start >= Integer.MAX_VALUE) {
            throw new SQLException("start must be < 2147483647");
        }
        int i = (int)start;
        while (i < length) {
            boolean found = true;
            int x = 0;
            while (x < pattern.length) {
                if (pattern[x] != this._blob[i + x]) {
                    found = false;
                    break;
                }
                ++x;
            }
            if (found) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    public synchronized OutputStream setBinaryStream(final long pos) throws SQLException {
        if (pos < 0L) {
            throw new SQLException("pos must be >= 0.");
        }
        if (pos > (long)this._blob.length) {
            throw new SQLException("pos specified is past length of value.");
        }
        if (pos >= Integer.MAX_VALUE) {
            throw new SQLException("pos must be < 2147483647");
        }
        return new ByteArrayOutputStream(){
            {
                this.write(BlobImpl.this._blob, 0, (int)pos);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void flush() throws IOException {
                BlobImpl blobImpl = BlobImpl.this;
                synchronized (blobImpl) {
                    byte[] blob = this.toByteArray();
                    if (blob.length < BlobImpl.this._blob.length) {
                        System.arraycopy(blob, 0, BlobImpl.this._blob, 0, blob.length);
                    } else {
                        BlobImpl.access$002(BlobImpl.this, blob);
                    }
                }
            }

            public void close() throws IOException {
                this.flush();
            }
        };
    }

    public synchronized int setBytes(long pos, byte[] bytes) throws SQLException {
        if (bytes == null) {
            throw new SQLException("bytes cannot be null.");
        }
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    public synchronized int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        OutputStream outputStream = this.setBinaryStream(pos);
        try {
            outputStream.write(bytes, offset, len);
            outputStream.close();
        }
        catch (IOException e) {
            throw new SQLException("Unable to write value: " + e.getMessage());
        }
        return len;
    }

    public synchronized void truncate(long len) throws SQLException {
        if (len < 0L) {
            throw new SQLException("len must be >= 0.");
        }
        if (len > (long)this._blob.length) {
            throw new SQLException("length specified is more than length of value.");
        }
        int length = (int)len;
        byte[] blob = new byte[length];
        System.arraycopy(this._blob, 0, blob, 0, length);
        this._blob = blob;
    }

    public synchronized String toString() {
        return this._blob.toString();
    }

    static /* synthetic */ byte[] access$002(BlobImpl x0, byte[] x1) {
        x0._blob = x1;
        return x1;
    }
}

