/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import net.sourceforge.jtds.jdbc.AbstractResultSet;
import net.sourceforge.jtds.jdbc.Columns;
import net.sourceforge.jtds.jdbc.Context;
import net.sourceforge.jtds.jdbc.OutputParamHandler;
import net.sourceforge.jtds.jdbc.PacketOutputParamResult;
import net.sourceforge.jtds.jdbc.PacketRetStatResult;
import net.sourceforge.jtds.jdbc.PacketRowResult;
import net.sourceforge.jtds.jdbc.ParameterListItem;
import net.sourceforge.jtds.jdbc.SQLWarningChain;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsConnection;
import net.sourceforge.jtds.jdbc.TdsException;
import net.sourceforge.jtds.jdbc.TdsStatement;

public class CursorResultSet
extends AbstractResultSet
implements OutputParamHandler {
    public static final int FETCH_FIRST = 1;
    public static final int FETCH_NEXT = 2;
    public static final int FETCH_PREVIOUS = 4;
    public static final int FETCH_LAST = 8;
    public static final int FETCH_ABSOLUTE = 16;
    public static final int FETCH_RELATIVE = 32;
    public static final int FETCH_REPEAT = 128;
    public static final int FETCH_INFO = 256;
    public static final int CURSOR_TYPE_KEYSET = 1;
    public static final int CURSOR_TYPE_DYNAMIC = 2;
    public static final int CURSOR_TYPE_FORWARD = 4;
    public static final int CURSOR_TYPE_STATIC = 8;
    public static final int CURSOR_CONCUR_READ_ONLY = 1;
    public static final int CURSOR_CONCUR_SCROLL_LOCKS = 2;
    public static final int CURSOR_CONCUR_OPTIMISTIC = 4;
    public static final int CURSOR_OP_INSERT = 4;
    public static final int CURSOR_OP_UPDATE = 33;
    public static final int CURSOR_OP_DELETE = 34;
    public static final int SQL_ROW_SUCCESS = 1;
    public static final int SQL_ROW_DELETED = 2;
    public static final int SQL_ROW_UPDATED = 3;
    public static final int SQL_ROW_NOROW = 4;
    public static final int SQL_ROW_ADDED = 5;
    public static final int SQL_ROW_ERROR = 6;
    private static final int POS_BEFORE_FIRST = -100000;
    private static final int POS_AFTER_LAST = -200000;
    private int pos = -100000;
    private Integer cursorHandle;
    private int rowsInResult;
    private String sql;
    private TdsStatement stmt;
    private TdsConnection conn;
    private int direction = 1000;
    private boolean open = false;
    private Context context;
    private PacketRowResult current;
    private ParameterListItem[] parameterList;
    private Integer retVal;
    private int lastOutParam = -1;
    private int type;
    private int concurrency;
    private boolean onInsertRow = false;
    private PacketRowResult insertRow;

    public CursorResultSet(TdsStatement stmt, String sql, int fetchDir, ParameterListItem[] parameters) throws SQLException {
        this.stmt = stmt;
        this.conn = (TdsConnection)stmt.getConnection();
        this.sql = sql;
        this.direction = fetchDir == 1002 ? 1000 : fetchDir;
        this.type = stmt.getResultSetType();
        this.concurrency = stmt.getResultSetConcurrency();
        this.warningChain = stmt.warningChain;
        this.cursorCreate(parameters);
        this.warningChain = new SQLWarningChain();
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException ex) {}
    }

    public Context getContext() {
        return this.context;
    }

    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1001: 
            case 1002: {
                if (this.type != 1003) {
                    throw new SQLException("ResultSet is forward-only.");
                }
            }
            case 1000: {
                this.direction = direction;
                break;
            }
            default: {
                throw new SQLException("Invalid fetch direction: " + direction);
            }
        }
    }

    public void setFetchSize(int rows) throws SQLException {
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Positioned update not supported.");
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.pos == -100000 && this.rowsInResult != 0;
    }

    public boolean isAfterLast() throws SQLException {
        return this.pos == -200000 && this.rowsInResult != 0;
    }

    public boolean isFirst() throws SQLException {
        return this.pos == 1;
    }

    public boolean isLast() throws SQLException {
        return this.pos == this.rowsInResult;
    }

    public int getRow() throws SQLException {
        return this.pos > 0 ? this.pos : 0;
    }

    public int getFetchDirection() throws SQLException {
        return this.direction;
    }

    public int getFetchSize() throws SQLException {
        return 1;
    }

    public int getType() throws SQLException {
        return this.type;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.open) {
            try {
                this.warningChain.clearWarnings();
                if (!this.conn.isClosed()) {
                    this.cursorClose();
                }
                this.stmt.cursorResults.remove(this);
                Object var2_1 = null;
                this.open = false;
                this.stmt = null;
                this.conn = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.open = false;
                this.stmt = null;
                this.conn = null;
                throw throwable;
            }
        }
        this.warningChain.checkForExceptions();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain.getWarnings();
    }

    public boolean next() throws SQLException {
        if (this.cursorFetch(2, 0)) {
            this.pos += this.pos < 0 ? 1 - this.pos : 1;
            return true;
        }
        this.pos = -200000;
        return false;
    }

    public void clearWarnings() throws SQLException {
        this.warningChain.clearWarnings();
    }

    public void beforeFirst() throws SQLException {
        if (this.pos != -100000) {
            this.cursorFetch(16, 0);
            this.pos = -100000;
        }
    }

    public void afterLast() throws SQLException {
        if (this.pos != -200000) {
            this.cursorFetch(16, this.rowsInResult + 1);
            this.pos = -200000;
        }
    }

    public boolean first() throws SQLException {
        boolean res = this.cursorFetch(1, 0);
        this.pos = 1;
        return res;
    }

    public boolean last() throws SQLException {
        boolean res = this.cursorFetch(8, 0);
        this.pos = this.rowsInResult;
        return res;
    }

    public boolean absolute(int row) throws SQLException {
        if (!this.cursorFetch(16, row)) {
            this.pos = row > 0 ? -200000 : -100000;
            return false;
        }
        this.pos = row;
        return true;
    }

    public boolean relative(int rows) throws SQLException {
        if (!this.cursorFetch(32, rows)) {
            this.pos = rows > 0 ? -200000 : -100000;
            return false;
        }
        if (this.pos < 0) {
            this.pos = this.pos == -100000 ? 0 : this.rowsInResult;
        }
        this.pos += rows;
        return true;
    }

    public boolean previous() throws SQLException {
        if (this.cursorFetch(4, 0)) {
            this.pos -= this.pos < 0 ? this.pos - this.rowsInResult : 1;
            return true;
        }
        this.pos = -100000;
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return this.getRowStat() == 3;
    }

    private int getRowStat() throws SQLException {
        return (int)this.current.getLong(this.context.getColumnInfo().realColumnCount());
    }

    public boolean rowInserted() throws SQLException {
        return this.getRowStat() == 5;
    }

    public boolean rowDeleted() throws SQLException {
        return this.getRowStat() == 2;
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException("The cursor is on the insert row.");
        }
        this.refreshRow();
    }

    public void moveToInsertRow() throws SQLException {
        this.onInsertRow = true;
    }

    public void moveToCurrentRow() throws SQLException {
        this.onInsertRow = false;
    }

    public PacketRowResult currentRow() throws SQLException {
        if (this.onInsertRow) {
            if (this.insertRow == null) {
                this.insertRow = new PacketRowResult(this.context);
            }
            return this.insertRow;
        }
        if (this.current == null) {
            throw new SQLException("No current row in the ResultSet");
        }
        return this.current;
    }

    public void insertRow() throws SQLException {
        if (!this.onInsertRow) {
            throw new SQLException("The cursor is not on the insert row.");
        }
        if (this.insertRow == null) {
            this.insertRow = new PacketRowResult(this.context);
        }
        this.cursor(4, this.insertRow);
        this.cursorFetch(256, 1);
        this.insertRow = new PacketRowResult(this.context);
    }

    public void updateRow() throws SQLException {
        if (this.current == null) {
            throw new SQLException("No current row in the ResultSet");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is on the insert row.");
        }
        this.cursor(33, this.current);
        this.cursorFetch(256, 1);
        this.refreshRow();
    }

    public void deleteRow() throws SQLException {
        if (this.current == null) {
            throw new SQLException("No current row in the ResultSet");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is on the insert row.");
        }
        this.cursor(34, null);
        this.cursorFetch(128, 1);
    }

    public void refreshRow() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException("The cursor is on the insert row.");
        }
        this.cursorFetch(128, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cursorCreate(ParameterListItem[] procedureParams) throws SQLException {
        int ccOpt;
        int scrollOpt;
        this.warningChain.clearWarnings();
        this.parameterList = new ParameterListItem[5];
        switch (this.type) {
            case 1004: {
                scrollOpt = 8;
                break;
            }
            case 1005: {
                scrollOpt = 1;
                break;
            }
            default: {
                scrollOpt = 4;
            }
        }
        switch (this.concurrency) {
            default: {
                ccOpt = 1;
                break;
            }
            case 1008: {
                ccOpt = 2;
            }
        }
        ParameterListItem[] param = this.parameterList;
        param[0] = new ParameterListItem();
        param[0].isSet = true;
        param[0].type = 4;
        param[0].isOutput = true;
        param[1] = new ParameterListItem();
        param[1].isSet = true;
        param[1].type = -1;
        param[1].maxLength = Integer.MAX_VALUE;
        param[1].formalType = this.conn.getTdsVer() >= 70 ? "ntext" : "text";
        param[1].value = this.sql;
        param[2] = new ParameterListItem();
        param[2].isSet = true;
        param[2].type = 4;
        param[2].value = new Integer(scrollOpt);
        param[2].isOutput = true;
        param[3] = new ParameterListItem();
        param[3].isSet = true;
        param[3].type = 4;
        param[3].value = new Integer(ccOpt);
        param[3].isOutput = true;
        param[4] = new ParameterListItem();
        param[4].isSet = true;
        param[4].type = 4;
        param[4].isOutput = true;
        if (procedureParams != null) {
            param = new ParameterListItem[5 + procedureParams.length];
            System.arraycopy(this.parameterList, 0, param, 0, 5);
            int i = 0;
            while (i < procedureParams.length) {
                param[5 + i] = procedureParams[i];
                ++i;
            }
        }
        this.lastOutParam = -1;
        this.retVal = null;
        Object object = this.conn.mainTdsMonitor;
        synchronized (object) {
            this.stmt.outParamHandler = this;
            Tds tds = this.conn.allocateTds(true);
            try {
                tds.executeProcedure("sp_cursoropen", param, param, this.stmt, this.warningChain, this.stmt.getQueryTimeout(), false);
                if (this.stmt.getMoreResults(tds, this.warningChain, true)) {
                    this.context = this.stmt.results.context;
                    this.context.getColumnInfo().setFakeColumnCount(this.context.getColumnInfo().realColumnCount() - 1);
                    this.stmt.results.close();
                } else {
                    this.warningChain.addException(new SQLException("Expected a ResultSet."));
                }
                if (this.stmt.getMoreResults(tds, this.warningChain, true) || this.stmt.getUpdateCount() != -1) {
                    this.warningChain.addException(new SQLException("No more results expected."));
                }
            }
            finally {
                try {
                    this.conn.freeTds(tds);
                }
                catch (TdsException ex) {
                    this.warningChain.addException(new SQLException(ex.getMessage()));
                }
                this.stmt.outParamHandler = null;
            }
        }
        this.cursorHandle = (Integer)param[0].value;
        this.rowsInResult = ((Number)param[4].value).intValue();
        int actualScroll = ((Number)param[2].value).intValue();
        int actualCc = ((Number)param[3].value).intValue();
        if (actualScroll != scrollOpt || actualCc != ccOpt) {
            if (actualScroll != scrollOpt) {
                switch (actualScroll) {
                    case 4: {
                        this.type = 1003;
                        break;
                    }
                    case 8: {
                        this.type = 1004;
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.type = 1005;
                        break;
                    }
                    default: {
                        this.warningChain.addException(new SQLException("Don't know how to handle cursor type " + actualScroll));
                    }
                }
            }
            if (actualCc != ccOpt) {
                switch (actualCc) {
                    case 1: {
                        this.concurrency = 1007;
                        break;
                    }
                    case 2: 
                    case 4: {
                        this.concurrency = 1008;
                        break;
                    }
                    default: {
                        this.warningChain.addException(new SQLException("Don't know how to handle concurrency type " + actualScroll));
                    }
                }
            }
            this.warningChain.addWarning(new SQLWarning("ResultSet type/concurrency downgraded."));
        }
        if (this.retVal == null || this.retVal != 0) {
            this.warningChain.addException(new SQLException("Cursor open failed."));
        }
        this.warningChain.checkForExceptions();
        this.open = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cursorFetch(int fetchType, int rowNum) throws SQLException {
        boolean isInfo;
        this.warningChain.clearWarnings();
        ParameterListItem[] param = new ParameterListItem[4];
        System.arraycopy(this.parameterList, 0, param, 0, 4);
        boolean bl = isInfo = fetchType == 256;
        if (fetchType != 16 && fetchType != 32) {
            rowNum = 1;
        }
        param[0].clear();
        param[0].isSet = true;
        param[0].type = 4;
        param[0].value = this.cursorHandle;
        param[1].clear();
        param[1].isSet = true;
        param[1].type = 4;
        param[1].value = new Integer(fetchType);
        param[2].clear();
        param[2].isSet = true;
        param[2].type = 4;
        param[2].value = isInfo ? null : new Integer(rowNum);
        param[2].isOutput = isInfo;
        param[3].clear();
        param[3].isSet = true;
        param[3].type = 4;
        param[3].value = isInfo ? null : new Integer(1);
        param[3].isOutput = isInfo;
        this.lastOutParam = -1;
        this.retVal = null;
        Object object = this.conn.mainTdsMonitor;
        synchronized (object) {
            this.stmt.outParamHandler = this;
            Tds tds = this.conn.allocateTds(true);
            try {
                tds.executeProcedure("sp_cursorfetch", param, param, this.stmt, this.warningChain, this.stmt.getQueryTimeout(), true);
                this.current = tds.fetchRow(this.stmt, this.warningChain, this.context);
                if (this.stmt.getMoreResults(tds, this.warningChain, true) || this.stmt.getUpdateCount() != -1) {
                    this.warningChain.addException(new SQLException("No results expected."));
                }
            }
            finally {
                try {
                    this.conn.freeTds(tds);
                }
                catch (TdsException ex) {
                    this.warningChain.addException(new SQLException(ex.getMessage()));
                }
                this.stmt.outParamHandler = null;
            }
        }
        this.warningChain.checkForExceptions();
        return this.current != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cursorClose() throws SQLException {
        this.warningChain.clearWarnings();
        ParameterListItem[] param = new ParameterListItem[]{this.parameterList[0]};
        param[0].clear();
        param[0].isSet = true;
        param[0].type = 4;
        param[0].value = this.cursorHandle;
        this.lastOutParam = -1;
        this.retVal = null;
        Object object = this.conn.mainTdsMonitor;
        synchronized (object) {
            this.stmt.outParamHandler = this;
            Tds tds = this.conn.allocateTds(true);
            try {
                tds.executeProcedure("sp_cursorclose", param, param, this.stmt, this.warningChain, this.stmt.getQueryTimeout(), false);
                if (this.stmt.getMoreResults(tds, this.warningChain, true) || this.stmt.getUpdateCount() != -1) {
                    this.warningChain.addException(new SQLException("No results expected."));
                }
                if (this.retVal == null || this.retVal != 0) {
                    this.warningChain.addException(new SQLException("Cursor close failed."));
                }
            }
            finally {
                try {
                    this.conn.freeTds(tds);
                }
                catch (TdsException ex) {
                    this.warningChain.addException(new SQLException(ex.getMessage()));
                }
                this.stmt.outParamHandler = null;
            }
        }
        this.warningChain.checkForExceptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cursor(int opType, PacketRowResult row) throws SQLException {
        ParameterListItem[] param;
        this.warningChain.clearWarnings();
        if (opType == 34) {
            if (row != null) {
                throw new SQLException("Non-null row provided to delete operation.");
            }
            param = new ParameterListItem[3];
            System.arraycopy(this.parameterList, 0, param, 0, 3);
        } else {
            if (row == null) {
                throw new SQLException("Null row provided to insert/update operation.");
            }
            param = new ParameterListItem[4 + row.context.getColumnInfo().fakeColumnCount()];
            System.arraycopy(this.parameterList, 0, param, 0, 4);
        }
        param[0].clear();
        param[0].isSet = true;
        param[0].type = 4;
        param[0].value = this.cursorHandle;
        param[1].clear();
        param[1].isSet = true;
        param[1].type = 4;
        param[1].value = new Integer(opType);
        param[2].clear();
        param[2].isSet = true;
        param[2].type = 4;
        param[2].value = new Integer(1);
        if (row != null) {
            param[3].clear();
            param[3].isSet = true;
            param[3].type = 12;
            param[3].value = "";
            if (this.conn.getTdsVer() >= 70) {
                param[3].formalType = "nvarchar(4000)";
                param[3].maxLength = 4000;
            } else {
                param[3].formalType = "varchar(255)";
                param[3].maxLength = 255;
            }
            Columns cols = row.context.getColumnInfo();
            int colCnt = cols.fakeColumnCount();
            int crtCol = 4;
            int i = 1;
            while (i <= colCnt) {
                if (!cols.isReadOnly(i).booleanValue()) {
                    param[crtCol] = new ParameterListItem();
                    param[crtCol].isSet = true;
                    param[crtCol].type = cols.getJdbcType(i);
                    param[crtCol].value = row.getObject(i);
                    param[crtCol].formalName = '@' + cols.getName(i);
                    param[crtCol].maxLength = cols.getBufferSize(i);
                    param[crtCol].scale = cols.getScale(i);
                    switch (cols.getNativeType(i)) {
                        case -25: 
                        case -17: 
                        case 103: {
                            param[crtCol].formalType = "nvarchar(4000)";
                            break;
                        }
                        case 99: {
                            param[crtCol].formalType = "ntext";
                        }
                    }
                    ++crtCol;
                } else if (opType == 4 && row.getObject(i) != null) {
                    throw new SQLException("Column " + i + "/" + cols.getName(i) + " is read-only.");
                }
                ++i;
            }
            if (crtCol != colCnt + 4) {
                ParameterListItem[] newParam = new ParameterListItem[crtCol];
                System.arraycopy(param, 0, newParam, 0, crtCol);
                param = newParam;
            }
        }
        this.lastOutParam = -1;
        this.retVal = null;
        Object object = this.conn.mainTdsMonitor;
        synchronized (object) {
            this.stmt.outParamHandler = this;
            Tds tds = this.conn.allocateTds(true);
            try {
                tds.executeProcedure("sp_cursor", param, param, this.stmt, this.warningChain, this.stmt.getQueryTimeout(), false);
                if (this.stmt.getMoreResults(tds, this.warningChain, true) || this.stmt.getUpdateCount() != -1) {
                    this.warningChain.addException(new SQLException("No results expected."));
                }
                if (this.retVal == null || this.retVal != 0) {
                    this.warningChain.addException(new SQLException("Cursor operation failed."));
                }
            }
            finally {
                try {
                    this.conn.freeTds(tds);
                }
                catch (TdsException ex) {
                    this.warningChain.addException(new SQLException(ex.getMessage()));
                }
                this.stmt.outParamHandler = null;
            }
        }
        this.warningChain.checkForExceptions();
    }

    public boolean handleRetStat(PacketRetStatResult packet) {
        this.retVal = new Integer(packet.getRetStat());
        return true;
    }

    public boolean handleParamResult(PacketOutputParamResult packet) throws SQLException {
        ++this.lastOutParam;
        while (this.lastOutParam < this.parameterList.length) {
            if (this.parameterList[this.lastOutParam].isOutput) {
                this.parameterList[this.lastOutParam].value = packet.value;
                return true;
            }
            ++this.lastOutParam;
        }
        throw new SQLException("More output params than expected.");
    }
}

