/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import net.sourceforge.jtds.jdbc.AbstractResultSet;
import net.sourceforge.jtds.jdbc.Columns;
import net.sourceforge.jtds.jdbc.Context;
import net.sourceforge.jtds.jdbc.Microsoft7MetaData;
import net.sourceforge.jtds.jdbc.PacketRowResult;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsConnection;
import net.sourceforge.jtds.jdbc.TdsResultSet;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    public static final String cvsVersion = "$Id: DatabaseMetaData.java,v 1.19 2004/02/16 20:14:31 alin_sinpalean Exp $";
    Tds tds;
    TdsConnection connection;
    int sysnameLength = 30;
    Boolean caseSensitive = null;

    public DatabaseMetaData(TdsConnection connection_, Tds tds_) throws SQLException {
        this.connection = connection_;
        this.tds = tds_;
    }

    public static DatabaseMetaData getInstance(TdsConnection connection_, Tds tds_) throws SQLException {
        if (tds_.getTdsVer() >= 70) {
            return new Microsoft7MetaData(connection_, tds_);
        }
        return new DatabaseMetaData(connection_, tds_);
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String query = "exec sp_special_columns ?, ?, ?, ?, ?, ?, ?";
        if (catalog != null) {
            query = this.tds.getTdsVer() == 70 ? "exec [" + catalog + "]..sp_special_columns ?, ?, ?, ?, ?, ?, ?" : "exec " + catalog + "..sp_special_columns ?, ?, ?, ?, ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, table);
        s.setString(2, schema);
        s.setString(3, catalog);
        s.setString(4, "R");
        s.setString(5, "T");
        s.setString(6, "U");
        s.setInt(7, 3);
        TdsResultSet rs = (TdsResultSet)s.executeQuery();
        Columns col = rs.getContext().getColumnInfo();
        col.setName(5, "COLUMN_SIZE");
        col.setLabel(5, "COLUMN_SIZE");
        col.setName(6, "BUFFER_LENGTH");
        col.setLabel(6, "BUFFER_LENGTH");
        col.setName(7, "DECIMAL_DIGITS");
        col.setLabel(7, "DECIMAL_DIGITS");
        return rs;
    }

    public ResultSet getCatalogs() throws SQLException {
        String query = "exec sp_tables '', '', '%', NULL";
        Statement s = this.connection.createStatement();
        TdsResultSet rs = (TdsResultSet)s.executeQuery(query);
        Columns col = rs.getContext().getColumnInfo();
        col.setFakeColumnCount(1);
        col.setName(1, "TABLE_CAT");
        col.setLabel(1, "TABLE_CAT");
        return rs;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        String query = "exec sp_column_privileges ?, ?, ?, ?";
        if (catalog != null) {
            query = this.tds.getTdsVer() == 70 ? "exec [" + catalog + "]..sp_column_privileges ?, ?, ?, ?" : "exec " + catalog + "..sp_column_privileges ?, ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, table);
        s.setString(2, schema);
        s.setString(3, catalog);
        s.setString(4, columnNamePattern);
        TdsResultSet rs = (TdsResultSet)s.executeQuery();
        Columns col = rs.getContext().getColumnInfo();
        col.setName(1, "TABLE_CAT");
        col.setLabel(1, "TABLE_CAT");
        col.setName(2, "TABLE_SCHEM");
        col.setLabel(2, "TABLE_SCHEM");
        return rs;
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String query = "exec sp_columns ?, ?, ?, ?, ?";
        if (catalog != null) {
            query = this.tds.getTdsVer() == 70 ? "exec [" + catalog + "]..sp_columns ?, ?, ?, ?, ?" : "exec " + catalog + "..sp_columns ?, ?, ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, tableNamePattern);
        s.setString(2, schemaPattern);
        s.setString(3, catalog);
        s.setString(4, columnNamePattern);
        s.setInt(5, 3);
        TdsResultSet rs = (TdsResultSet)s.executeQuery();
        Columns col = rs.getContext().getColumnInfo();
        col.setName(1, "TABLE_CAT");
        col.setLabel(1, "TABLE_CAT");
        col.setName(2, "TABLE_SCHEM");
        col.setLabel(2, "TABLE_SCHEM");
        col.setName(7, "COLUMN_SIZE");
        col.setLabel(7, "COLUMN_SIZE");
        col.setName(8, "BUFFER_LENGTH");
        col.setLabel(8, "BUFFER_LENGTH");
        col.setName(9, "DECIMAL_DIGITS");
        col.setLabel(9, "DECIMAL_DIGITS");
        col.setName(10, "NUM_PREC_RADIX");
        col.setLabel(10, "NUM_PREC_RADIX");
        col.setFakeColumnCount(18);
        return rs;
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String query = "exec sp_fkeys ?, ?, ?, ?, ?, ?";
        if (primaryCatalog != null) {
            query = this.tds.getTdsVer() == 70 ? "exec [" + primaryCatalog + "]..sp_fkeys ?, ?, ?, ?, ?, ?" : "exec " + primaryCatalog + "..sp_fkeys ?, ?, ?, ?, ?, ?";
        } else if (foreignCatalog != null) {
            query = this.tds.getTdsVer() == 70 ? "exec [" + foreignCatalog + "]..sp_fkeys ?, ?, ?, ?, ?, ?" : "exec " + foreignCatalog + "..sp_fkeys ?, ?, ?, ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, primaryTable);
        s.setString(2, primarySchema);
        s.setString(3, primaryCatalog);
        s.setString(4, foreignTable);
        s.setString(5, foreignSchema);
        s.setString(6, foreignCatalog);
        TdsResultSet rs = (TdsResultSet)s.executeQuery();
        Columns col = rs.getContext().getColumnInfo();
        col.setName(1, "PKTABLE_CAT");
        col.setLabel(1, "PKTABLE_CAT");
        col.setName(2, "PKTABLE_SCHEM");
        col.setLabel(2, "PKTABLE_SCHEM");
        col.setName(5, "FKTABLE_CAT");
        col.setLabel(5, "FKTABLE_CAT");
        col.setName(6, "FKTABLE_SCHEM");
        col.setLabel(6, "FKTABLE_SCHEM");
        return rs;
    }

    public String getDatabaseProductName() throws SQLException {
        return this.tds.getDatabaseProductName();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.tds.getDatabaseProductVersion();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public int getDriverMajorVersion() {
        return 0;
    }

    public int getDriverMinorVersion() {
        return 7;
    }

    public String getDriverName() throws SQLException {
        return "jTDS Type 4 JDBC Driver for MS SQL Server";
    }

    public String getDriverVersion() throws SQLException {
        return this.getDriverMajorVersion() + "." + this.getDriverMinorVersion();
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getCrossReference(catalog, schema, table, null, null, null);
    }

    public String getExtraNameCharacters() throws SQLException {
        return "#$";
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getCrossReference(null, null, null, catalog, schema, table);
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String query = "exec sp_statistics ?, ?, ?, ?, ?, ?";
        if (catalog != null) {
            query = this.tds.getTdsVer() == 70 ? "exec [" + catalog + "]..sp_statistics ?, ?, ?, ?, ?, ?" : "exec " + catalog + "..sp_statistics ?, ?, ?, ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, table);
        s.setString(2, schema);
        s.setString(3, catalog);
        s.setString(4, "%");
        s.setString(5, unique ? "Y" : "N");
        s.setString(6, approximate ? "Q" : "E");
        TdsResultSet rs = (TdsResultSet)s.executeQuery();
        Columns col = rs.getContext().getColumnInfo();
        col.setName(1, "TABLE_CAT");
        col.setLabel(1, "TABLE_CAT");
        col.setName(2, "TABLE_SCHEM");
        col.setLabel(2, "TABLE_SCHEM");
        col.setName(8, "ORDINAL_POSITION");
        col.setLabel(8, "ORDINAL_POSITION");
        col.setName(10, "ASC_OR_DESC");
        col.setLabel(10, "ASC_OR_DESC");
        return rs;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 131072;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 131072;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 4000;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 250;
    }

    public int getMaxConnections() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxIndexLength() throws SQLException {
        return 900;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxRowSize() throws SQLException {
        return 1962;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxStatementLength() throws SQLException {
        return 131072;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 16;
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN";
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String query = "exec sp_pkeys ?, ?, ?";
        if (catalog != null) {
            query = this.tds.getTdsVer() == 70 ? "exec [" + catalog + "]..sp_pkeys ?, ?, ?" : "exec " + catalog + "..sp_pkeys ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, table);
        s.setString(2, schema);
        s.setString(3, catalog);
        TdsResultSet rs = (TdsResultSet)s.executeQuery();
        Columns col = rs.getContext().getColumnInfo();
        col.setName(1, "TABLE_CAT");
        col.setLabel(1, "TABLE_CAT");
        col.setName(2, "TABLE_SCHEM");
        col.setLabel(2, "TABLE_SCHEM");
        return rs;
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String query = "exec sp_sproc_columns ?, ?, ?, ?, ?";
        if (catalog != null) {
            query = this.tds.getTdsVer() == 70 ? "exec [" + catalog + "]..sp_sproc_columns ?, ?, ?, ?, ?" : "exec " + catalog + "..sp_sproc_columns ?, ?, ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, procedureNamePattern);
        s.setString(2, schemaPattern);
        s.setString(3, catalog);
        s.setString(4, columnNamePattern);
        s.setInt(5, 3);
        TdsResultSet rs = (TdsResultSet)s.executeQuery();
        Columns col = rs.getContext().getColumnInfo();
        col.setName(1, "PROCEDURE_CAT");
        col.setLabel(1, "PROCEDURE_CAT");
        col.setName(2, "PROCEDURE_SCHEM");
        col.setLabel(2, "PROCEDURE_SCHEM");
        return rs;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String query = "exec sp_stored_procedures ?, ?, ?";
        if (catalog != null) {
            query = this.tds.getTdsVer() == 70 ? "exec [" + catalog + "]..sp_stored_procedures ?, ?, ?" : "exec " + catalog + "..sp_stored_procedures ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, procedureNamePattern);
        s.setString(2, schemaPattern);
        s.setString(3, catalog);
        TdsResultSet rs = (TdsResultSet)s.executeQuery();
        return rs;
    }

    public String getProcedureTerm() throws SQLException {
        return "stored procedure";
    }

    public ResultSet getSchemas() throws SQLException {
        Statement statement = this.connection.createStatement();
        String sql = this.tds.getTdsVer() >= 70 ? "SELECT name AS TABLE_SCHEM FROM dbo.sysusers WHERE islogin=1" : "SELECT name AS TABLE_SCHEM FROM dbo.sysusers WHERE uid>0";
        return statement.executeQuery(sql);
    }

    public String getSchemaTerm() throws SQLException {
        return "owner";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getSQLKeywords() throws SQLException {
        return "BREAK,BROWSE,BULK,CHECKPOINT,CLUSTERED,COMMITTED,COMPUTE,CONFIRM,CONTROLROW,DATABASE,DBCC,DISK,DISTRIBUTED,DUMMY,DUMP,ERRLVL,ERROREXIT,EXIT,FILE,FILLFACTOR,FLOPPY,HOLDLOCK,IDENTITY_INSERT,IDENTITYCOL,IF,KILL,LINENO,LOAD,MIRROREXIT,NONCLUSTERED,OFF,OFFSETS,ONCE,OVER,PERCENT,PERM,PERMANENT,PLAN,PRINT,PROC,PROCESSEXIT,RAISERROR,READ,READTEXT,RECONFIGURE,REPEATABLE,RETURN,ROWCOUNT,RULE,SAVE,SERIALIZABLE,SETUSER,SHUTDOWN,STATISTICS,TAPE,TEMP,TEXTSIZE,TOP,TRAN,TRIGGER,TRUNCATE,TSEQUEL,UNCOMMITTED,UPDATETEXT,USE,WAITFOR,WHILE,WRITETEXT";
    }

    public String getStringFunctions() throws SQLException {
        return "ASCII,CHAR,CONCAT,DIFFERENCE,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTRING,UCASE";
    }

    public String getSystemFunctions() throws SQLException {
        return "DATABASE,IFNULL,USER";
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String query = "exec sp_table_privileges ?, ?, ?";
        if (catalog != null) {
            query = this.tds.getTdsVer() == 70 ? "exec [" + catalog + "]..sp_table_privileges ?, ?, ?" : "exec " + catalog + "..sp_table_privileges ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, tableNamePattern);
        s.setString(2, schemaPattern);
        s.setString(3, catalog);
        TdsResultSet rs = (TdsResultSet)s.executeQuery();
        Columns col = rs.getContext().getColumnInfo();
        col.setName(1, "TABLE_CAT");
        col.setLabel(1, "TABLE_CAT");
        col.setName(2, "TABLE_SCHEM");
        col.setLabel(2, "TABLE_SCHEM");
        return rs;
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String query = "exec sp_tables ?, ?, ?, ?";
        if (catalog != null) {
            query = this.tds.getTdsVer() == 70 ? "exec [" + catalog + "]..sp_tables ?, ?, ?, ?" : "exec " + catalog + "..sp_tables ?, ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, tableNamePattern);
        s.setString(2, schemaPattern);
        s.setString(3, catalog);
        if (types == null) {
            s.setString(4, null);
        } else {
            StringBuffer buf = new StringBuffer(64);
            buf.append('\"');
            int i = 0;
            while (i < types.length) {
                buf.append('\'').append(types[i]).append("',");
                ++i;
            }
            if (buf.length() > 1) {
                buf.setLength(buf.length() - 1);
            }
            buf.append('\"');
            s.setString(4, buf.toString());
        }
        TdsResultSet rs = (TdsResultSet)s.executeQuery();
        Columns col = rs.getContext().getColumnInfo();
        col.setName(1, "TABLE_CAT");
        col.setLabel(1, "TABLE_CAT");
        col.setName(2, "TABLE_SCHEM");
        col.setLabel(2, "TABLE_SCHEM");
        return rs;
    }

    public ResultSet getTableTypes() throws SQLException {
        String sql = "select 'TABLE' TABLE_TYPE              union select 'VIEW' TABLE_TYPE         union select 'SYSTEM TABLE' TABLE_TYPE ";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        return rs;
    }

    public String getTimeDateFunctions() throws SQLException {
        return "GETDATE,DATEPART,DATENAME,DATEDIFF,DATEADD";
    }

    public ResultSet getTypeInfo() throws SQLException {
        Statement s = this.connection.createStatement();
        TdsResultSet rs = (TdsResultSet)s.executeQuery("exec sp_datatype_info @ODBCVer=3");
        Columns col = rs.getContext().getColumnInfo();
        col.setFakeColumnCount(18);
        col.setName(11, "FIXED_PREC_SCALE");
        col.setLabel(11, "FIXED_PREC_SCALE");
        return rs;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String[] colNames = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS"};
        Columns cols = new Columns(6);
        final Context ctx = new Context(cols, null);
        int i = 0;
        while (i < 6) {
            cols.setNativeType(i + 1, 39);
            cols.setLabel(i + 1, colNames[i]);
            cols.setName(i + 1, colNames[i]);
            ++i;
        }
        return new AbstractResultSet(){

            public SQLWarning getWarnings() throws SQLException {
                return null;
            }

            public String getCursorName() throws SQLException {
                return null;
            }

            public boolean isBeforeFirst() throws SQLException {
                return false;
            }

            public boolean isFirst() throws SQLException {
                return false;
            }

            public boolean first() throws SQLException {
                return false;
            }

            public boolean last() throws SQLException {
                return false;
            }

            public boolean absolute(int row) throws SQLException {
                return false;
            }

            public boolean relative(int rows) throws SQLException {
                return false;
            }

            public boolean previous() throws SQLException {
                return false;
            }

            public void setFetchDirection(int direction) throws SQLException {
            }

            public int getFetchDirection() throws SQLException {
                return 1000;
            }

            public int getFetchSize() throws SQLException {
                return 0;
            }

            public int getType() throws SQLException {
                return 1003;
            }

            public boolean rowUpdated() throws SQLException {
                return false;
            }

            public boolean rowInserted() throws SQLException {
                return false;
            }

            public boolean rowDeleted() throws SQLException {
                return false;
            }

            public void insertRow() throws SQLException {
            }

            public void updateRow() throws SQLException {
            }

            public void deleteRow() throws SQLException {
            }

            public void refreshRow() throws SQLException {
            }

            public void cancelRowUpdates() throws SQLException {
            }

            public void moveToInsertRow() throws SQLException {
            }

            public void moveToCurrentRow() throws SQLException {
            }

            public Statement getStatement() throws SQLException {
                return null;
            }

            public boolean isLast() throws SQLException {
                return false;
            }

            public boolean isAfterLast() throws SQLException {
                return false;
            }

            public void setFetchSize(int rows) throws SQLException {
            }

            public void clearWarnings() throws SQLException {
            }

            public void beforeFirst() throws SQLException {
            }

            public int getRow() throws SQLException {
                return 0;
            }

            public void close() throws SQLException {
            }

            public void afterLast() {
            }

            public boolean next() throws SQLException {
                return false;
            }

            public int getConcurrency() {
                return 1003;
            }

            public Context getContext() {
                return ctx;
            }

            public PacketRowResult currentRow() throws SQLException {
                return null;
            }
        };
    }

    public String getURL() throws SQLException {
        return this.connection.getUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() throws SQLException {
        Statement s = null;
        ResultSet rs = null;
        String result = "";
        try {
            s = this.connection.createStatement();
            rs = this.tds.getServerType() == 2 ? s.executeQuery("select suser_name()") : s.executeQuery("select system_user");
            if (!rs.next()) {
                throw new SQLException("Couldn't determine user name");
            }
            result = rs.getString(1);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (s != null) {
                s.close();
            }
        }
        return result;
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String query = "exec sp_special_columns ?, ?, ?, ?, ?, ?, ?";
        if (catalog != null) {
            query = this.tds.getTdsVer() == 70 ? "exec [" + catalog + "]..sp_special_columns ?, ?, ?, ?, ?, ?, ?" : "exec " + catalog + "..sp_special_columns ?, ?, ?, ?, ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, table);
        s.setString(2, schema);
        s.setString(3, catalog);
        s.setString(4, "V");
        s.setString(5, "C");
        s.setString(6, "O");
        s.setInt(7, 3);
        TdsResultSet rs = (TdsResultSet)s.executeQuery();
        Columns col = rs.getContext().getColumnInfo();
        col.setName(5, "COLUMN_SIZE");
        col.setLabel(5, "COLUMN_SIZE");
        col.setName(6, "BUFFER_LENGTH");
        col.setLabel(6, "BUFFER_LENGTH");
        col.setName(7, "DECIMAL_DIGITS");
        col.setLabel(7, "DECIMAL_DIGITS");
        return rs;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive == false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive == false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return true;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        if (fromType == toType) {
            return true;
        }
        switch (fromType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return toType != -1 && toType != -4;
            }
            case -3: 
            case -2: {
                return toType != 6 && toType != 7 && toType != 8 && toType != -4;
            }
            case -4: {
                return toType == -2 || toType == -3;
            }
            case -1: {
                return toType == 1 || toType == 12;
            }
            case 0: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.tds.getServerType() == 1;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.tds.getServerType() != 1;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return true;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return true;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return true;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return type == 1005;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return type == 1005;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    private void setCaseSensitiveFlag() throws SQLException {
        if (this.caseSensitive == null) {
            Statement s = this.connection.createStatement();
            ResultSet rs = s.executeQuery("sp_server_info 16");
            rs.next();
            this.caseSensitive = rs.getString(3).equalsIgnoreCase("MIXED") ? Boolean.FALSE : Boolean.TRUE;
            s.close();
        }
    }

    public ResultSet getAttributes(String str, String str1, String str2, String str3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.tds.getDatabaseMajorVersion();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.tds.getDatabaseMinorVersion();
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 2;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 1;
    }

    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getSQLStateType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getSuperTables(String str, String str1, String str2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getSuperTypes(String str, String str1, String str2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsNamedParameters() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsResultSetHoldability(int param) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        throw new UnsupportedOperationException();
    }
}

