/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import net.sourceforge.jtds.jdbc.TdsConnection;
import net.sourceforge.jtds.jdbc.TdsException;

public class Driver
implements java.sql.Driver {
    public static final String cvsVersion = "$Id: Driver.java,v 1.8 2004/02/26 19:00:51 alin_sinpalean Exp $";
    static final int MAJOR_VERSION = 0;
    static final int MINOR_VERSION = 7;
    private static final String DEFAULT_SQL_SERVER_PORT = "1433";
    private static final String DEFAULT_SYBASE_PORT = "7100";

    public boolean acceptsURL(String url) throws SQLException {
        return this.parseUrl(url, null);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.parseUrl(url, info = info == null ? new Properties() : this.processProperties(info))) {
            return null;
        }
        return Driver.getConnection(info);
    }

    public static Connection getConnection(Properties properties) throws SQLException {
        if (properties == null) {
            throw new SQLException("properties cannot be null.");
        }
        try {
            return new TdsConnection(properties);
        }
        catch (NumberFormatException e) {
            throw new SQLException("NumberFormatException converting port number.");
        }
        catch (TdsException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 7;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[]{new DriverPropertyInfo("SERVERTYPE", null), new DriverPropertyInfo("HOST", null), new DriverPropertyInfo("PORT", null), new DriverPropertyInfo("DBNAME", null), new DriverPropertyInfo("USER", null), new DriverPropertyInfo("PASSWORD", null), new DriverPropertyInfo("CHARSET", null), new DriverPropertyInfo("TDS", null), new DriverPropertyInfo("DOMAIN", null), new DriverPropertyInfo("INSTANCE", null), new DriverPropertyInfo("LASTUPDATECOUNT", null), new DriverPropertyInfo("SENDSTRINGPARAMETERSASUNICODE", null)};
        if (!this.parseUrl(url, info = info == null ? new Properties() : this.processProperties(info))) {
            throw new SQLException("Invalid URL supplied: " + url);
        }
        int i = 0;
        while (i < dpi.length) {
            String name = dpi[i].name;
            String value = info.getProperty(name);
            if (value != null) {
                dpi[i].value = value;
            }
            if (name.equals("SERVERTYPE")) {
                dpi[i].description = "The type of database (1 is SQL Server, 2 is Sybase).";
                dpi[i].required = true;
                dpi[i].choices = new String[]{String.valueOf(1), String.valueOf(2)};
                if (dpi[i].value == null) {
                    dpi[i].value = dpi[i].choices[0];
                }
            } else if (name.equals("HOST")) {
                dpi[i].description = "The database hostname.";
                dpi[i].required = true;
            } else if (name.equals("PORT")) {
                dpi[i].description = "The database port.";
                if (dpi[i].value == null) {
                    dpi[i].value = String.valueOf(2).equalsIgnoreCase(String.valueOf(info.get("SERVERTYPE"))) ? DEFAULT_SYBASE_PORT : DEFAULT_SQL_SERVER_PORT;
                }
            } else if (name.equals("DBNAME")) {
                dpi[i].description = "The database name.";
                if (dpi[i].value == null) {
                    dpi[i].value = "master";
                }
            } else if (name.equals("USER")) {
                dpi[i].description = "The database user.";
            } else if (name.equals("PASSWORD")) {
                dpi[i].description = "The database password.";
            } else if (name.equals("CHARSET")) {
                dpi[i].description = "Character set for non-Unicode character values.";
            } else if (name.equals("TDS")) {
                dpi[i].description = "The database protocol.";
                dpi[i].choices = new String[]{String.valueOf(42), String.valueOf(50), String.valueOf(70)};
                if (dpi[i].value == null) {
                    dpi[i].value = dpi[i].choices[2];
                }
            } else if (name.equals("DOMAIN")) {
                dpi[i].description = "The domain used for authentication.";
            } else if (name.equals("INSTANCE")) {
                dpi[i].description = "The database instance.";
            } else if (name.equals("LASTUPDATECOUNT")) {
                dpi[i].description = "Return only the last update count on executeUpdate.";
                dpi[i].choices = new String[]{"true", "false"};
                if (dpi[i].value == null) {
                    dpi[i].value = dpi[i].choices[1];
                }
            } else if (name.equals("SENDSTRINGPARAMETERSASUNICODE")) {
                dpi[i].description = "If strings should be sent as unicode values.";
                dpi[i].choices = new String[]{"true", "false"};
                if (dpi[i].value == null) {
                    dpi[i].value = dpi[i].choices[0];
                }
            }
            ++i;
        }
        return dpi;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    protected boolean parseUrl(String url, Properties result) {
        String database;
        String port;
        String server;
        int endPos;
        if (url == null) {
            return false;
        }
        String tmpUrl = url;
        int serverType = 1;
        int pos = tmpUrl.indexOf(58);
        if (pos == -1) {
            return false;
        }
        if ((pos = tmpUrl.indexOf(58, pos + 1)) == -1) {
            return false;
        }
        if (!tmpUrl.substring(0, pos + 1).equalsIgnoreCase("jdbc:jtds:")) {
            return false;
        }
        if ((endPos = tmpUrl.indexOf("//", ++pos)) == -1) {
            return false;
        }
        if (pos != endPos && !(server = tmpUrl.substring(pos, endPos).toLowerCase()).equals("sqlserver:")) {
            if (server.equals("sybase:")) {
                serverType = 2;
            } else {
                return false;
            }
        }
        if (result != null) {
            result.put("SERVERTYPE", String.valueOf(serverType));
        }
        tmpUrl = tmpUrl.substring(endPos + 2);
        int portStart = tmpUrl.indexOf(58);
        int databaseStart = tmpUrl.indexOf(47);
        int attributesStart = tmpUrl.indexOf(59);
        endPos = portStart != -1 ? portStart : (databaseStart != -1 ? databaseStart : (attributesStart != -1 ? attributesStart : tmpUrl.length()));
        if (endPos == 0) {
            return false;
        }
        String host = tmpUrl.substring(0, endPos);
        if (result != null) {
            result.put("HOST", host);
        }
        if (portStart == -1) {
            port = serverType == 2 ? DEFAULT_SYBASE_PORT : DEFAULT_SQL_SERVER_PORT;
        } else {
            endPos = databaseStart != -1 ? databaseStart : (attributesStart != -1 ? attributesStart : tmpUrl.length());
            if (endPos <= portStart) {
                return false;
            }
            port = tmpUrl.substring(portStart + 1, endPos);
        }
        if (result != null) {
            result.put("PORT", port);
        }
        if (databaseStart == -1) {
            database = "";
        } else {
            endPos = attributesStart != -1 ? attributesStart : tmpUrl.length();
            if (endPos <= portStart) {
                return false;
            }
            database = tmpUrl.substring(databaseStart + 1, endPos);
        }
        if (result != null) {
            result.put("DBNAME", database);
        }
        while (attributesStart != -1) {
            pos = attributesStart + 1;
            int assignment = tmpUrl.indexOf(61, pos);
            if (assignment == -1 || pos == assignment) {
                return false;
            }
            attributesStart = tmpUrl.indexOf(59, pos);
            if (attributesStart == -1) {
                endPos = tmpUrl.length();
            } else {
                if (assignment > attributesStart) {
                    return false;
                }
                endPos = attributesStart;
            }
            if (result == null) continue;
            result.put(tmpUrl.substring(pos, assignment).toUpperCase(), tmpUrl.substring(assignment + 1, endPos));
        }
        return true;
    }

    private Properties processProperties(Properties props) {
        Properties res = props;
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            res.setProperty(key.toUpperCase(), props.getProperty(key));
        }
        return res;
    }

    public String toString() {
        return "jTDS 0.7";
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {}
    }
}

