/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class EncodingHelper {
    public static final String cvsVersion = "$Id: EncodingHelper.java,v 1.4 2003/12/16 19:08:48 alin_sinpalean Exp $";
    private static byte[] convArray;
    private static Hashtable knownEncodings;
    private static boolean initialized;
    private String name;
    private boolean wideChars;
    static /* synthetic */ Class class$net$sourceforge$jtds$jdbc$EncodingHelper;

    private static void initialize() {
        convArray = new byte[256];
        int i = 0;
        while (i < 256) {
            EncodingHelper.convArray[i] = (byte)i;
            ++i;
        }
        knownEncodings = new Hashtable();
        try {
            knownEncodings.put("iso_1", new EncodingHelper("Cp1252"));
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        initialized = true;
    }

    private EncodingHelper(String name) throws UnsupportedEncodingException {
        this.name = name;
        this.wideChars = new String(convArray, name).length() != convArray.length;
    }

    public byte[] getBytes(String value) {
        try {
            return value.getBytes(this.name);
        }
        catch (UnsupportedEncodingException uee) {
            return value.getBytes();
        }
    }

    public String getString(byte[] value) {
        return this.getString(value, 0, value.length);
    }

    public String getString(byte[] value, int off, int len) {
        try {
            return new String(value, off, len, this.name);
        }
        catch (UnsupportedEncodingException uee) {
            return new String(value, off, len);
        }
    }

    public boolean isDBCS() {
        return this.wideChars;
    }

    public boolean canBeConverted(String value) {
        try {
            return new String(value.getBytes(this.name), this.name).equals(value);
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EncodingHelper getHelper(String encodingName) {
        EncodingHelper res;
        if (!initialized) {
            Class clazz = class$net$sourceforge$jtds$jdbc$EncodingHelper == null ? (class$net$sourceforge$jtds$jdbc$EncodingHelper = EncodingHelper.class$("net.sourceforge.jtds.jdbc.EncodingHelper")) : class$net$sourceforge$jtds$jdbc$EncodingHelper;
            synchronized (clazz) {
                if (!initialized) {
                    EncodingHelper.initialize();
                }
            }
        }
        if ((res = (EncodingHelper)knownEncodings.get(encodingName)) == null) {
            try {
                res = new EncodingHelper(encodingName);
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        if (res == null) {
            try {
                res = new EncodingHelper("Cp" + encodingName);
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        if (res == null) {
            try {
                res = new EncodingHelper("MS" + encodingName);
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        if (res != null) {
            knownEncodings.put(encodingName, res);
        }
        return res;
    }

    public String getName() {
        return this.name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        EncodingHelper.initialize();
    }
}

