/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import java.util.HashMap;

public class EscapeProcessor {
    public static final String cvsVersion = "$Id: EscapeProcessor.java,v 1.10 2004/02/14 01:02:46 bheineman Exp $";
    private static final String ESCAPE_PREFIX_DATE = "d ";
    private static final String ESCAPE_PREFIX_TIME = "t ";
    private static final String ESCAPE_PREFIX_TIMESTAMP = "ts ";
    private static final String ESCAPE_PREFIX_OUTER_JOIN = "oj ";
    private static final String ESCAPE_PREFIX_FUNCTION = "fn ";
    private static final String ESCAPE_PREFIX_CALL = "call ";
    private static final String ESCAPE_PREFIX_ESCAPE_CHAR = "escape ";
    private static final int NORMAL = 0;
    private static final int IN_STRING = 1;
    private static final int IN_ESCAPE = 2;
    private static HashMap _functionMap = new HashMap();

    public static String nativeSQL(String sql) throws SQLException {
        StringBuffer result = new StringBuffer(sql.length());
        EscapeProcessor.parameterNativeSQL(sql, result);
        return result.toString();
    }

    public static int parameterNativeSQL(String sql, StringBuffer result) throws SQLException {
        char[] chars = sql.toCharArray();
        StringBuffer escape = null;
        int state = 0;
        int parameters = 0;
        if (sql == null) {
            throw new SQLException("No statement");
        }
        if (result == null) {
            throw new SQLException("INTERNAL ERROR: result is null");
        }
        if (result.length() != 0) {
            throw new SQLException("INTERNAL ERROR: result.length() != 0");
        }
        int i = 0;
        while (i < chars.length) {
            char ch = chars[i];
            if (state == 0) {
                if (ch == '{') {
                    state = 2;
                    if (escape == null) {
                        escape = new StringBuffer();
                    } else {
                        escape.delete(0, escape.length());
                    }
                } else {
                    result.append(ch);
                    if (ch == '?') {
                        ++parameters;
                    } else if (ch == '\'') {
                        state = 1;
                    }
                }
            } else if (state == 1) {
                result.append(ch);
                if (ch == '\'') {
                    state = 0;
                }
            } else if (ch == '}') {
                EscapeProcessor.translateEscape(escape.toString(), result);
                state = 0;
            } else {
                if (ch == '?') {
                    ++parameters;
                }
                escape.append(ch);
            }
            ++i;
        }
        if (state == 2) {
            throw new SQLException("Syntax error in SQL escape syntax");
        }
        return parameters;
    }

    private static void translateEscape(String escapeSequence, StringBuffer result) throws SQLException {
        String str = escapeSequence.trim();
        int i = 0;
        int length = str.length();
        while (!Character.isWhitespace(str.charAt(i++)) && i < length) {
        }
        String escape = str.substring(0, i).toLowerCase();
        if (escape.equals(ESCAPE_PREFIX_FUNCTION)) {
            EscapeProcessor.translateFunction(str, result);
        } else if (escape.equals(ESCAPE_PREFIX_CALL) || escape.startsWith("?")) {
            EscapeProcessor.translateCall(str, result);
        } else if (escape.equals(ESCAPE_PREFIX_ESCAPE_CHAR)) {
            result.append(str);
        } else if (escape.equals(ESCAPE_PREFIX_OUTER_JOIN)) {
            result.append(str.substring(ESCAPE_PREFIX_OUTER_JOIN.length()));
        } else if (escape.equals(ESCAPE_PREFIX_DATE)) {
            EscapeProcessor.translateDate(str, result);
        } else if (escape.equals(ESCAPE_PREFIX_TIME)) {
            EscapeProcessor.translateTime(str, result);
        } else if (escape.equals(ESCAPE_PREFIX_TIMESTAMP)) {
            EscapeProcessor.translateTimestamp(str, result);
        } else {
            throw new SQLException("Unrecognized escape sequence: " + escapeSequence);
        }
    }

    private static void translateFunction(String str, StringBuffer result) throws SQLException {
        int pPos = (str = str.substring(ESCAPE_PREFIX_FUNCTION.length())).indexOf(40);
        if (pPos < 0) {
            throw new SQLException("Malformed function escape, expected '(': " + str);
        }
        if (str.charAt(str.length() - 1) != ')') {
            throw new SQLException("Malformed function escape, expected ')' at" + (str.length() - 1) + ": " + str);
        }
        String fName = str.substring(0, pPos).trim().toLowerCase();
        if (fName.equals("concat")) {
            EscapeProcessor.translateConcat(str.substring(pPos), result);
        } else if ((fName = (String)_functionMap.get(fName)) == null) {
            result.append(str);
        } else {
            result.append(fName);
            result.append(str.substring(pPos));
        }
    }

    private static void translateConcat(String str, StringBuffer result) throws SQLException {
        char[] chars = str.toCharArray();
        boolean inString = false;
        int i = 0;
        while (i < chars.length) {
            char ch = chars[i];
            if (!inString && ch == ',') {
                result.append('+');
            } else {
                if (ch == '\'') {
                    inString = !inString;
                }
                result.append(ch);
            }
            ++i;
        }
    }

    private static void translateCall(String str, StringBuffer result) throws SQLException {
        int pPos;
        String escapeSequence = str;
        boolean returnsValue = str.startsWith("?");
        if (returnsValue) {
            int i = EscapeProcessor.skipWhitespace(str, 1);
            if (str.charAt(i) != '=') {
                throw new SQLException("Malformed procedure call, '=' expected at " + i + ": " + escapeSequence);
            }
            if (!EscapeProcessor.startsWithIgnoreCase(str = str.substring(i = EscapeProcessor.skipWhitespace(str, i + 1)), ESCAPE_PREFIX_CALL)) {
                throw new SQLException("Malformed procedure call, 'call ' expected at " + i + ": " + escapeSequence);
            }
        }
        result.append("exec ");
        if (returnsValue) {
            result.append("?=");
        }
        if ((pPos = (str = str.substring(ESCAPE_PREFIX_CALL.length()).trim()).indexOf(40)) >= 0) {
            if (str.charAt(str.length() - 1) != ')') {
                throw new SQLException("Malformed procedure call, ')' expected at " + (escapeSequence.length() - 1) + ": " + escapeSequence);
            }
            result.append(str.substring(0, pPos));
            result.append(" ");
            result.append(str.substring(pPos + 1, str.length() - 1));
        } else {
            result.append(str);
        }
    }

    private static void translateDate(String str, StringBuffer result) throws SQLException {
        int i = 2;
        i = EscapeProcessor.skipWhitespace(str, i);
        i = EscapeProcessor.skipQuote(str, i);
        if (str.length() - i < 10 || str.charAt(i + 4) != '-' || str.charAt(i + 7) != '-') {
            throw new SQLException("Malformed date");
        }
        String year = str.substring(i, i + 4);
        String month = str.substring(i + 5, i + 5 + 2);
        String day = str.substring(i + 5 + 3, i + 5 + 3 + 2);
        if (!(EscapeProcessor.validDigits(year) && EscapeProcessor.validDigits(month) && EscapeProcessor.validDigits(day))) {
            throw new SQLException("Malformed date");
        }
        i += 10;
        i = EscapeProcessor.skipWhitespace(str, i);
        i = EscapeProcessor.skipQuote(str, i);
        if ((i = EscapeProcessor.skipWhitespace(str, i)) < str.length()) {
            throw new SQLException("Malformed date");
        }
        result.append("'");
        result.append(year);
        result.append(month);
        result.append(day);
        result.append("'");
    }

    private static void translateTime(String str, StringBuffer result) throws SQLException {
        int i = 2;
        i = EscapeProcessor.skipWhitespace(str, i);
        i = EscapeProcessor.skipQuote(str, i);
        if (str.length() - i < 8 || str.charAt(i + 2) != ':' || str.charAt(i + 5) != ':') {
            throw new SQLException("Malformed time");
        }
        String hour = str.substring(i, i + 2);
        String minute = str.substring(i + 3, i + 3 + 2);
        String second = str.substring(i + 3 + 3, i + 3 + 3 + 2);
        if (!(EscapeProcessor.validDigits(hour) && EscapeProcessor.validDigits(minute) && EscapeProcessor.validDigits(second))) {
            throw new SQLException("Malformed time");
        }
        i += 8;
        i = EscapeProcessor.skipWhitespace(str, i);
        i = EscapeProcessor.skipQuote(str, i);
        if ((i = EscapeProcessor.skipWhitespace(str, i)) < str.length()) {
            throw new SQLException("Malformed time");
        }
        result.append("'");
        result.append(hour);
        result.append(":");
        result.append(minute);
        result.append(":");
        result.append(second);
        result.append("'");
    }

    /*
     * Unable to fully structure code
     */
    private static void translateTimestamp(String str, StringBuffer result) throws SQLException {
        block7: {
            i = 3;
            i = EscapeProcessor.skipWhitespace(str, i);
            i = EscapeProcessor.skipQuote(str, i);
            if (str.length() - i < 19 || str.charAt(i + 4) != '-' || str.charAt(i + 7) != '-') {
                throw new SQLException("Malformed date");
            }
            year = str.substring(i, i + 4);
            month = str.substring(i + 5, i + 5 + 2);
            day = str.substring(i + 5 + 3, i + 5 + 3 + 2);
            if (!(EscapeProcessor.validDigits(year) && EscapeProcessor.validDigits(month) && EscapeProcessor.validDigits(day))) {
                throw new SQLException("Malformed date");
            }
            if (!Character.isWhitespace(str.charAt(i += 10))) {
                throw new SQLException("Malformed date");
            }
            i = EscapeProcessor.skipWhitespace(str, i);
            if (str.length() - i < 8 || str.charAt(i + 2) != ':' || str.charAt(i + 5) != ':') {
                throw new SQLException("Malformed time");
            }
            hour = str.substring(i, i + 2);
            minute = str.substring(i + 3, i + 3 + 2);
            second = str.substring(i + 3 + 3, i + 3 + 3 + 2);
            fraction = "000";
            if (str.length() <= (i += 8) || str.charAt(i) != '.') break block7;
            fraction = "";
            ++i;
            while (str.length() > i && EscapeProcessor.validDigits(str.substring(i, i + 1))) {
                fraction = fraction + str.substring(i++, i);
            }
            if (fraction.length() <= 3) ** GOTO lbl30
            fraction = fraction.substring(0, 3);
            break block7;
lbl-1000:
            // 1 sources

            {
                fraction = fraction + "0";
lbl30:
                // 2 sources

                ** while (fraction.length() < 3)
            }
        }
        i = EscapeProcessor.skipWhitespace(str, i);
        i = EscapeProcessor.skipQuote(str, i);
        if ((i = EscapeProcessor.skipWhitespace(str, i)) < str.length()) {
            throw new SQLException("Malformed date");
        }
        result.append("'");
        result.append(year);
        result.append(month);
        result.append(day);
        result.append(" ");
        result.append(hour);
        result.append(":");
        result.append(minute);
        result.append(":");
        result.append(second);
        result.append(".");
        result.append(fraction);
        result.append("'");
    }

    private static boolean validDigits(String str) {
        int i = 0;
        while (i < str.length()) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static int skipWhitespace(String str, int i) {
        while (i < str.length() && Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static int skipQuote(String str, int i) {
        if (i < str.length() && (str.charAt(i) == '\'' || str.charAt(i) == '\"')) {
            ++i;
        }
        return i;
    }

    private static boolean startsWithIgnoreCase(String s, String prefix) {
        if (s.length() < prefix.length()) {
            return false;
        }
        int i = prefix.length() - 1;
        while (i >= 0) {
            if (Character.toLowerCase(s.charAt(i)) != Character.toLowerCase(prefix.charAt(i))) {
                return false;
            }
            --i;
        }
        return true;
    }

    static {
        _functionMap.put("user", "user_name");
        _functionMap.put("database", "db_name");
        _functionMap.put("ifnull", "isnull");
        _functionMap.put("now", "translateDate");
        _functionMap.put("atan2", "atn2");
        _functionMap.put("length", "len");
        _functionMap.put("locate", "charindex");
        _functionMap.put("repeat", "replicate");
        _functionMap.put("insert", "stuff");
        _functionMap.put("lcase", "lower");
        _functionMap.put("ucase", "upper");
    }
}

