/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import net.sourceforge.jtds.jdbc.Context;
import net.sourceforge.jtds.jdbc.PacketResult;
import net.sourceforge.jtds.jdbc.TdsUtil;

public class PacketRowResult
extends PacketResult {
    Vector row = null;
    Context context;
    boolean wasNull = false;
    public static final String cvsVersion = "$Id: PacketRowResult.java,v 1.6 2004/02/19 00:14:37 alin_sinpalean Exp $";

    public PacketRowResult(Context context) {
        super((byte)-47);
        this.context = context;
        this.row = new Vector(this.realColumnCount());
        this.row.setSize(this.realColumnCount());
    }

    public Context getContext() {
        return this.context;
    }

    public void setElementAt(int index, Object obj) throws SQLException {
        if (index < 1 || index > this.realColumnCount()) {
            throw new SQLException("Bad index " + index);
        }
        if (obj != null) {
            int colType = this.context.getColumnInfo().getNativeType(index);
            switch (colType) {
                case 38: 
                case 48: 
                case 52: 
                case 56: {
                    if (obj instanceof Number) break;
                    obj = Integer.valueOf(obj.toString());
                    break;
                }
                case 34: 
                case 37: 
                case 45: {
                    if (obj instanceof byte[]) break;
                    throw new SQLException("Only byte[] accepted for IMAGE/BINARY fields.");
                }
                case -17: 
                case 35: 
                case 36: 
                case 39: 
                case 47: 
                case 99: 
                case 103: {
                    break;
                }
                case 59: 
                case 62: 
                case 109: {
                    if (obj instanceof Number) break;
                    obj = Double.valueOf(obj.toString());
                    break;
                }
                case 60: 
                case 106: 
                case 108: 
                case 110: 
                case 122: {
                    if (obj instanceof Number) break;
                    obj = new BigDecimal(obj.toString());
                    break;
                }
                case 58: 
                case 61: 
                case 111: {
                    if (obj instanceof Date) break;
                    throw new SQLException("Only java.util.Date values accepted for DATETIME fields.");
                }
                case 50: 
                case 104: {
                    if (obj instanceof Boolean) break;
                    if (obj instanceof Number) {
                        obj = new Boolean(((Number)obj).intValue() != 0);
                        break;
                    }
                    obj = new Boolean(!"0".equals(obj.toString()));
                    break;
                }
                default: {
                    throw new SQLException("Don't now how to handle column type 0x" + Integer.toHexString(colType));
                }
            }
        }
        this.row.setElementAt(obj, index - 1);
    }

    private int realColumnCount() {
        return this.context.getColumnInfo().realColumnCount();
    }

    public int getColumnType(int index) throws SQLException {
        return this.context.getColumnInfo().getJdbcType(index);
    }

    public Object getElementAt(int index) throws SQLException {
        if (index < 1 || index > this.realColumnCount()) {
            throw new SQLException("Bad index " + index);
        }
        Object res = this.row.elementAt(index - 1);
        this.wasNull = res == null;
        return res;
    }

    public Object getObject(int columnIndex) throws SQLException {
        Object tmp = this.getElementAt(columnIndex);
        if (tmp == null) {
            return null;
        }
        switch (this.getColumnType(columnIndex)) {
            case -1: 
            case 1: 
            case 12: {
                if (tmp instanceof String) {
                    return tmp;
                }
                return tmp.toString();
            }
            case -6: 
            case 4: 
            case 5: {
                if (tmp instanceof Integer) {
                    return tmp;
                }
                if (!(tmp instanceof Number)) {
                    throw new SQLException("Can't convert " + tmp.getClass().getName() + " to Integer.");
                }
                return new Integer(((Number)tmp).intValue());
            }
            case -5: {
                if (tmp instanceof Long) {
                    return tmp;
                }
                if (!(tmp instanceof Number)) {
                    throw new SQLException("Internal error");
                }
                return new Long(((Number)tmp).longValue());
            }
            case 7: {
                if (tmp instanceof Float) {
                    return tmp;
                }
                if (tmp instanceof Number) {
                    return new Float(((Number)tmp).doubleValue());
                }
                throw new SQLException("Was expecting Numeric data.  Got" + tmp.getClass().getName());
            }
            case 6: 
            case 8: {
                if (tmp instanceof Double) {
                    return tmp;
                }
                if (tmp instanceof Number) {
                    return new Double(((Number)tmp).doubleValue());
                }
                throw new SQLException("Was expecting Numeric data.  Got" + tmp.getClass().getName());
            }
            case 91: {
                if (tmp instanceof java.sql.Date) {
                    return tmp;
                }
                if (tmp instanceof Date) {
                    return new java.sql.Date(((Date)tmp).getTime());
                }
                throw new SQLException("Internal error");
            }
            case 92: {
                if (tmp instanceof Time) {
                    return tmp;
                }
                if (tmp instanceof Date) {
                    return new Time(((Date)tmp).getTime());
                }
                throw new SQLException("Internal error");
            }
            case 93: {
                if (tmp instanceof Timestamp) {
                    return tmp;
                }
                if (tmp instanceof Date) {
                    return new Timestamp(((Date)tmp).getTime());
                }
                throw new SQLException("Internal error");
            }
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 2: 
            case 3: {
                if (tmp instanceof BigDecimal) {
                    return tmp;
                }
                if (tmp instanceof Number) {
                    return new BigDecimal(((Number)tmp).doubleValue());
                }
                throw new SQLException("Was expecting NUMERIC data.  Got" + tmp.getClass().getName());
            }
            case -4: {
                throw new SQLException("Not implemented");
            }
            case 0: {
                throw new SQLException("Not implemented");
            }
            case 1111: {
                throw new SQLException("Not implemented");
            }
            case -7: {
                if (tmp instanceof Boolean) {
                    return tmp;
                }
                throw new SQLException("Was expecting BIT data. Got" + tmp.getClass().getName());
            }
        }
        throw new SQLException("Unknown datatype " + this.getColumnType(columnIndex));
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        byte[] result;
        Object tmp = this.getElementAt(columnIndex);
        if (tmp == null) {
            result = null;
        } else if (tmp instanceof byte[]) {
            result = (byte[])tmp;
        } else if (tmp instanceof String) {
            result = this.context.getEncoder().getBytes((String)tmp);
        } else {
            throw new SQLException("Can't convert column " + columnIndex + " from " + tmp.getClass().getName() + " to byte[]");
        }
        return result;
    }

    public double getDouble(int columnIndex) throws SQLException {
        double result;
        Object obj = this.getElementAt(columnIndex);
        if (obj == null) {
            result = 0.0;
        } else {
            try {
                switch (this.getColumnType(columnIndex)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        result = ((Number)obj).doubleValue();
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        try {
                            Double d = new Double((String)obj);
                            result = d;
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new SQLException(e.getMessage());
                        }
                    }
                    default: {
                        throw new SQLException("Internal error. Don't know how to convert from java.sql.Types." + TdsUtil.javaSqlTypeToString(this.getColumnType(columnIndex)) + " to an Dboule");
                    }
                }
            }
            catch (ClassCastException e) {
                throw new SQLException("Couldn't convert column " + columnIndex + " to an long.  " + e.getMessage());
            }
        }
        return result;
    }

    public long getLong(int columnIndex) throws SQLException {
        long result = 0L;
        Object obj = this.getElementAt(columnIndex);
        if (obj == null) {
            result = 0L;
        } else {
            try {
                switch (this.getColumnType(columnIndex)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        result = ((Number)obj).longValue();
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        try {
                            Long i = new Long(obj.toString().trim());
                            result = i;
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new SQLException("NumberFormatException: [" + e.getMessage() + "]");
                        }
                    }
                    case -7: {
                        result = (Boolean)obj != false ? 1L : 0L;
                        break;
                    }
                    default: {
                        throw new SQLException("Internal error. Don't know how to convert from java.sql.Types " + TdsUtil.javaSqlTypeToString(this.getColumnType(columnIndex)) + " to an long");
                    }
                }
            }
            catch (ClassCastException e) {
                throw new SQLException("Couldn't convert column " + columnIndex + " to an long.  " + e.getMessage());
            }
        }
        return result;
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Timestamp result;
        Object tmp = this.getElementAt(columnIndex);
        if (tmp == null) {
            result = null;
        } else if (tmp instanceof Timestamp) {
            result = (Timestamp)tmp;
        } else {
            throw new SQLException("Can't convert column " + columnIndex + " from " + tmp.getClass().getName() + " to Timestamp");
        }
        return result;
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object tmp = this.getElementAt(columnIndex);
        if (tmp == null) {
            return null;
        }
        BigDecimal result = null;
        if (tmp instanceof Double) {
            result = new BigDecimal((Double)tmp);
        } else if (tmp instanceof Float) {
            result = new BigDecimal(((Float)tmp).doubleValue());
        } else if (tmp instanceof BigDecimal) {
            result = (BigDecimal)tmp;
        } else if (tmp instanceof Number) {
            result = BigDecimal.valueOf(((Number)tmp).longValue());
        } else if (tmp instanceof String) {
            try {
                result = new BigDecimal((String)tmp);
            }
            catch (NumberFormatException e) {
                throw new SQLException(e.getMessage());
            }
        }
        return result;
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal result = this.getBigDecimal(columnIndex);
        if (result == null) {
            return null;
        }
        return result.setScale(scale);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        boolean result;
        Object obj = this.getElementAt(columnIndex);
        if (obj == null) {
            result = false;
        } else {
            switch (this.getColumnType(columnIndex)) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (!(obj instanceof Number)) {
                        throw new SQLException("Internal error");
                    }
                    result = ((Number)obj).intValue() != 0;
                    break;
                }
                case -7: {
                    if (!(obj instanceof Boolean)) {
                        throw new SQLException("Internal error");
                    }
                    result = (Boolean)obj;
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    if (!(obj instanceof String)) {
                        throw new SQLException("Internal error");
                    }
                    String v = obj.toString().trim();
                    if (v.equalsIgnoreCase("0") || v.equalsIgnoreCase("false")) {
                        result = false;
                        break;
                    }
                    if (v.equalsIgnoreCase("1") || v.equalsIgnoreCase("true")) {
                        result = true;
                        break;
                    }
                }
                default: {
                    throw new SQLException("Can't convert column " + columnIndex + " from " + obj.getClass().getName() + " to boolean");
                }
            }
        }
        return result;
    }

    public boolean wasNull() {
        return this.wasNull;
    }
}

