/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import net.sourceforge.jtds.jdbc.EncodingHelper;
import net.sourceforge.jtds.jdbc.ParameterListItem;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsUtil;

public class ParameterUtils {
    public static final String cvsVersion = "$Id: ParameterUtils.java,v 1.10 2004/02/25 01:24:47 alin_sinpalean Exp $";

    private static void verifyThatParametersAreSet(ParameterListItem[] parameterList) throws SQLException {
        int i = 0;
        while (i < parameterList.length) {
            if (parameterList[i].isOutput) {
                parameterList[i].isSet = true;
            }
            if (!parameterList[i].isSet) {
                throw new SQLException("parameter #" + (i + 1) + " has not been set");
            }
            ++i;
        }
    }

    public static void createParameterMapping(String rawQueryString, ParameterListItem[] parameterList, Tds tds, boolean assignNames) throws SQLException {
        ParameterUtils.verifyThatParametersAreSet(parameterList);
        int nextParameterNumber = 0;
        int tdsVer = tds.getTdsVer();
        EncodingHelper encoder = tds.getEncoder();
        int i = 0;
        while (i < parameterList.length) {
            if (assignNames) {
                String nextFormal;
                while (-1 != rawQueryString.indexOf(nextFormal = "P" + ++nextParameterNumber)) {
                }
                parameterList[i].formalName = '@' + nextFormal;
            }
            switch (parameterList[i].type) {
                case 1: 
                case 12: {
                    String value = (String)parameterList[i].value;
                    if (tdsVer == 70) {
                        if ((value == null || value.length() < 4001) && tds.useUnicode()) {
                            parameterList[i].formalType = "nvarchar(4000)";
                            parameterList[i].maxLength = 4000;
                            break;
                        }
                        if (value == null || value.length() < 8001 && !encoder.isDBCS() && encoder.canBeConverted(value)) {
                            parameterList[i].formalType = "varchar(8000)";
                            parameterList[i].maxLength = 8000;
                            break;
                        }
                        parameterList[i].formalType = "ntext";
                        parameterList[i].maxLength = Integer.MAX_VALUE;
                        break;
                    }
                    int len = 0;
                    if (value != null) {
                        len = value.length();
                        if (encoder.isDBCS() && len > 127 && len < 256) {
                            len = encoder.getBytes(value).length;
                        }
                    }
                    if (len < 256) {
                        parameterList[i].formalType = "varchar(255)";
                        parameterList[i].maxLength = 255;
                        break;
                    }
                    parameterList[i].formalType = "text";
                    parameterList[i].maxLength = Integer.MAX_VALUE;
                    break;
                }
                case -1: {
                    parameterList[i].formalType = tdsVer == 70 ? "ntext" : "text";
                    parameterList[i].maxLength = Integer.MAX_VALUE;
                    break;
                }
                case 4: {
                    parameterList[i].formalType = "integer";
                    break;
                }
                case 6: 
                case 7: {
                    parameterList[i].formalType = "real";
                    break;
                }
                case 8: {
                    parameterList[i].formalType = "float";
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    parameterList[i].formalType = "datetime";
                    break;
                }
                case -4: {
                    parameterList[i].formalType = "image";
                    break;
                }
                case -3: 
                case -2: {
                    parameterList[i].formalType = "varbinary(8000)";
                    break;
                }
                case -7: {
                    parameterList[i].formalType = "bit";
                    break;
                }
                case -5: {
                    parameterList[i].formalType = "decimal(" + tds.getConnection().getMaxPrecision() + ",0)";
                    break;
                }
                case 5: {
                    parameterList[i].formalType = "smallint";
                    break;
                }
                case -6: {
                    parameterList[i].formalType = "tinyint";
                    break;
                }
                case 2: 
                case 3: {
                    int scale = parameterList[i].scale;
                    if (scale == -1) {
                        scale = 10;
                    }
                    parameterList[i].formalType = "decimal(" + tds.getConnection().getMaxPrecision() + "," + scale + ")";
                    break;
                }
                case 0: 
                case 1111: {
                    throw new SQLException("Not implemented (type is java.sql.Types." + TdsUtil.javaSqlTypeToString(parameterList[i].type) + ")");
                }
                default: {
                    throw new SQLException("Internal error.  Unrecognized type " + parameterList[i].type);
                }
            }
            ++i;
        }
    }
}

