/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.rmi.dgc.VMID;
import java.sql.SQLException;
import net.sourceforge.jtds.jdbc.ParameterListItem;
import net.sourceforge.jtds.jdbc.Tds;

public class Procedure {
    public static final String cvsVersion = "$Id: Procedure.java,v 1.10 2004/02/26 19:00:51 alin_sinpalean Exp $";
    private static long id = 1L;
    private ParameterListItem[] _parameterList;
    private String _sqlProcedureName;
    private String _procedureString;
    private String _signature;

    public Procedure(String rawQueryString, String signature, ParameterListItem[] parameterListIn, Tds tds) throws SQLException {
        this._signature = signature;
        this._sqlProcedureName = this.getUniqueProcedureName(tds);
        this._parameterList = new ParameterListItem[parameterListIn.length];
        int i = 0;
        while (i < this._parameterList.length) {
            this._parameterList[i] = (ParameterListItem)parameterListIn[i].clone();
            this._parameterList[i].value = null;
            ++i;
        }
        StringBuffer procedureString = new StringBuffer(rawQueryString.length() + 128);
        procedureString.append("create proc ");
        procedureString.append(this._sqlProcedureName);
        this.createFormalParameterList(this._parameterList, procedureString);
        procedureString.append(" as ");
        boolean inString = false;
        char[] chars = rawQueryString.toCharArray();
        int nextParameterIndex = 0;
        int i2 = 0;
        while (i2 < chars.length) {
            char ch = chars[i2];
            if (!inString) {
                if (ch == '?') {
                    procedureString.append(this._parameterList[nextParameterIndex].formalName);
                    ++nextParameterIndex;
                } else {
                    if (ch == '\'') {
                        inString = true;
                    }
                    procedureString.append(ch);
                }
            } else {
                if (ch == '\'') {
                    inString = false;
                }
                procedureString.append(ch);
            }
            ++i2;
        }
        this._procedureString = procedureString.toString();
    }

    public String getPreparedSqlString() {
        return this._procedureString;
    }

    public String getProcedureName() {
        return this._sqlProcedureName;
    }

    public String getSignature() {
        return this._signature;
    }

    public ParameterListItem[] getParameterList() {
        return this._parameterList;
    }

    private void createFormalParameterList(ParameterListItem[] parameterList, StringBuffer result) {
        if (parameterList.length > 0) {
            result.append('(');
            int i = 0;
            while (i < parameterList.length) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(parameterList[i].formalName);
                result.append(' ');
                result.append(parameterList[i].formalType);
                if (parameterList[i].isOutput) {
                    result.append(" output");
                }
                ++i;
            }
            result.append(')');
        }
    }

    private String getUniqueProcedureName(Tds tds) {
        if (tds.getServerType() == 2) {
            String id = Procedure.getNewId();
            return "jTDS" + id.substring(id.length() - 26);
        }
        return "#jdbc#" + Procedure.getUniqueId();
    }

    public static synchronized long getUniqueId() {
        return id++;
    }

    public static String getNewId() {
        int pos;
        String id = new VMID().toString();
        String count = id.substring((pos = id.lastIndexOf(58)) + 1);
        count = count.charAt(0) == '-' ? "n" + count.substring(1) : "p" + count;
        id = id.substring(0, pos) + count;
        while ((pos = id.indexOf(58)) != -1) {
            id = id.substring(0, pos) + id.substring(pos + 1, id.length());
        }
        return id;
    }
}

