/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import net.sourceforge.jtds.jdbc.PacketErrorResult;
import net.sourceforge.jtds.jdbc.PacketMsgResult;

class SQLWarningChain {
    public static final String cvsVersion = "$Id: SQLWarningChain.java,v 1.3 2003/12/22 00:33:06 alin_sinpalean Exp $";
    private SQLWarning warnings = null;
    private SQLException exceptions;

    SQLWarningChain() {
    }

    synchronized SQLWarning getWarnings() {
        return this.warnings;
    }

    synchronized void checkForExceptions() throws SQLException {
        if (this.exceptions != null) {
            SQLException tmp = this.exceptions;
            this.exceptions = null;
            throw tmp;
        }
    }

    synchronized void clearWarnings() {
        this.warnings = null;
        this.exceptions = null;
    }

    synchronized void addWarning(SQLWarning warn) {
        if (this.warnings == null) {
            this.warnings = warn;
        } else {
            this.warnings.setNextWarning(warn);
        }
    }

    synchronized void addException(SQLException ex) {
        if (this.exceptions == null) {
            this.exceptions = ex;
        } else {
            this.exceptions.setNextException(ex);
        }
    }

    SQLException addOrReturn(PacketMsgResult pack) {
        if (pack instanceof PacketErrorResult) {
            SQLException ex = pack.getMsg().toSQLException();
            this.addException(ex);
            return ex;
        }
        this.addWarning(pack.getMsg().toSQLWarning());
        return null;
    }
}

