/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.sql.Timestamp;
import net.sourceforge.jtds.jdbc.EncodingHelper;
import net.sourceforge.jtds.jdbc.TdsDefinitions;
import net.sourceforge.jtds.jdbc.TdsException;
import net.sourceforge.jtds.jdbc.TdsUnknownPacketType;
import net.sourceforge.jtds.util.HexDump;
import net.sourceforge.jtds.util.Logger;

public class TdsComm
implements TdsDefinitions {
    private DataOutputStream out;
    private DataInputStream in;
    byte[] outBuffer;
    int nextOutBufferIndex = 0;
    volatile int packetType = 0;
    byte[] inBuffer;
    int inBufferIndex = 0;
    int inBufferLen = 0;
    int packetsSent = 0;
    int packetsReceived = 0;
    private int tdsVer = 42;
    byte[] tmpBuf = new byte[8];
    byte[] resBuffer = new byte[256];
    public static final String cvsVersion = "$Id: TdsComm.java,v 1.8 2004/02/11 00:10:48 bheineman Exp $";
    static final int headerLength = 8;
    public static final byte QUERY = 1;
    public static final byte LOGON = 2;
    public static final byte PROC = 3;
    public static final byte REPLY = 4;
    public static final byte CANCEL = 6;
    public static final byte LOGON70 = 16;
    public static final byte NTLMAUTH = 17;
    private static final int maxPacketLength = 512;
    private static int nextId = 0;
    private int id;

    public TdsComm(Socket sock, int tdsVer_) throws IOException {
        this.out = new DataOutputStream(sock.getOutputStream());
        this.in = new DataInputStream(sock.getInputStream());
        this.outBuffer = new byte[512];
        this.inBuffer = new byte[512];
        this.tdsVer = tdsVer_;
        this.id = ++nextId;
    }

    public void close() {
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void startPacket(int type) throws TdsException {
        if (type == 6 || this.inBufferIndex == this.inBufferLen) ** GOTO lbl11
        this.inBufferIndex = this.inBufferLen;
        if (Logger.isActive()) {
            Logger.println("Unprocessed data in input buffer. Dumping. [" + this.inBufferIndex + "/" + this.inBufferLen + "]");
        }
        throw new TdsException("Unprocessed data in input buffer.");
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
lbl11:
            // 3 sources

            ** while (this.packetType != 0)
        }
lbl12:
        // 1 sources

        this.packetType = type;
        this.nextOutBufferIndex = 8;
    }

    public void appendByte(byte b) throws IOException {
        if (this.nextOutBufferIndex == this.outBuffer.length) {
            this.sendPhysicalPacket(false);
            this.nextOutBufferIndex = 8;
        }
        this.outBuffer[this.nextOutBufferIndex] = b;
        ++this.nextOutBufferIndex;
    }

    public void appendBytes(byte[] b) throws IOException {
        this.appendBytes(b, b.length, (byte)0);
    }

    public void appendBytes(byte[] b, int len, byte pad) throws IOException {
        int i = 0;
        int min = b.length < len ? b.length : len;
        while (i < min) {
            this.appendByte(b[i]);
            ++i;
        }
        while (i < len) {
            this.appendByte(pad);
            ++i;
        }
    }

    public void appendShort(short s) throws IOException {
        this.appendByte((byte)(s >> 8 & 0xFF));
        this.appendByte((byte)(s >> 0 & 0xFF));
    }

    public void appendTdsShort(short s) throws IOException {
        this.appendByte((byte)(s >> 0 & 0xFF));
        this.appendByte((byte)(s >> 8 & 0xFF));
    }

    public void appendFlt8(Double value) throws IOException {
        long l = Double.doubleToLongBits(value);
        this.appendByte((byte)(l >> 0 & 0xFFL));
        this.appendByte((byte)(l >> 8 & 0xFFL));
        this.appendByte((byte)(l >> 16 & 0xFFL));
        this.appendByte((byte)(l >> 24 & 0xFFL));
        this.appendByte((byte)(l >> 32 & 0xFFL));
        this.appendByte((byte)(l >> 40 & 0xFFL));
        this.appendByte((byte)(l >> 48 & 0xFFL));
        this.appendByte((byte)(l >> 56 & 0xFFL));
    }

    public void appendInt(int i) throws IOException {
        this.appendByte((byte)(i >> 24 & 0xFF));
        this.appendByte((byte)(i >> 16 & 0xFF));
        this.appendByte((byte)(i >> 8 & 0xFF));
        this.appendByte((byte)(i >> 0 & 0xFF));
    }

    public void appendTdsInt(int i) throws IOException {
        this.appendByte((byte)(i >> 0 & 0xFF));
        this.appendByte((byte)(i >> 8 & 0xFF));
        this.appendByte((byte)(i >> 16 & 0xFF));
        this.appendByte((byte)(i >> 24 & 0xFF));
    }

    public void appendInt64(long i) throws IOException {
        this.appendByte((byte)(i >> 56 & 0xFFL));
        this.appendByte((byte)(i >> 48 & 0xFFL));
        this.appendByte((byte)(i >> 40 & 0xFFL));
        this.appendByte((byte)(i >> 32 & 0xFFL));
        this.appendByte((byte)(i >> 24 & 0xFFL));
        this.appendByte((byte)(i >> 16 & 0xFFL));
        this.appendByte((byte)(i >> 8 & 0xFFL));
        this.appendByte((byte)(i >> 0 & 0xFFL));
    }

    public void appendChars(String s) throws IOException {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            byte b1 = (byte)(c & 0xFF);
            byte b2 = (byte)(c >> 8 & 0xFF);
            this.appendByte(b1);
            this.appendByte(b2);
            ++i;
        }
    }

    public synchronized void sendPacket() throws IOException {
        this.sendPhysicalPacket(true);
        this.nextOutBufferIndex = 0;
        this.packetType = 0;
        this.notify();
    }

    private void storeByte(int index, byte value) {
        this.outBuffer[index] = value;
    }

    private void storeShort(int index, short s) {
        this.outBuffer[index] = (byte)(s >> 8 & 0xFF);
        this.outBuffer[index + 1] = (byte)(s >> 0 & 0xFF);
    }

    private void sendPhysicalPacket(boolean isLastSegment) throws IOException {
        if (this.nextOutBufferIndex > 8 || this.packetType == 6) {
            this.storeByte(0, (byte)(this.packetType & 0xFF));
            this.storeByte(1, isLastSegment ? (byte)1 : 0);
            this.storeShort(2, (short)this.nextOutBufferIndex);
            this.storeShort(4, (short)0);
            this.storeByte(6, (byte)(this.tdsVer == 70 ? 1 : 0));
            this.storeByte(7, (byte)0);
            this.out.write(this.outBuffer, 0, this.nextOutBufferIndex);
            ++this.packetsSent;
            if (Logger.isActive()) {
                String dump = HexDump.hexDump(this.outBuffer, this.nextOutBufferIndex);
                String t = new Timestamp(System.currentTimeMillis()).toString();
                Logger.println("Instance " + this.id + " @ " + t + " sent packet #" + this.packetsSent + "\n" + dump);
            }
        }
    }

    public byte peek() throws TdsException, IOException {
        if (this.inBufferIndex >= this.inBufferLen) {
            this.getPhysicalPacket();
        }
        return this.inBuffer[this.inBufferIndex];
    }

    public byte getByte() throws TdsException, IOException {
        if (this.inBufferIndex >= this.inBufferLen) {
            this.getPhysicalPacket();
        }
        return this.inBuffer[this.inBufferIndex++];
    }

    public byte[] getBytes(int len, boolean exclusiveBuffer) throws TdsException, IOException {
        byte[] result;
        if (exclusiveBuffer || len > 16384) {
            result = new byte[len];
        } else {
            if (this.resBuffer.length < len) {
                this.resBuffer = new byte[len];
            }
            result = this.resBuffer;
        }
        int i = 0;
        while (i < len) {
            int avail;
            if (this.inBufferIndex >= this.inBufferLen) {
                this.getPhysicalPacket();
            }
            avail = (avail = this.inBufferLen - this.inBufferIndex) > len - i ? len - i : avail;
            System.arraycopy(this.inBuffer, this.inBufferIndex, result, i, avail);
            i += avail;
            this.inBufferIndex += avail;
        }
        return result;
    }

    public String getString(int len, EncodingHelper enc) throws TdsException, IOException {
        if (this.tdsVer == 70) {
            char[] chars = new char[len];
            int i = 0;
            while (i < len) {
                int lo = this.getByte() & 0xFF;
                int hi = this.getByte() & 0xFF;
                chars[i] = (char)(lo | hi << 8);
                ++i;
            }
            return new String(chars);
        }
        return enc.getString(this.getBytes(len, false), 0, len);
    }

    public void skip(int i) throws TdsException, IOException {
        while (i > 0) {
            this.getByte();
            --i;
        }
    }

    public int getNetShort() throws TdsException, IOException {
        byte[] tmp = new byte[]{this.getByte(), this.getByte()};
        return TdsComm.ntohs(tmp, 0);
    }

    public int getTdsShort() throws TdsException, IOException {
        int lo = this.getByte() & 0xFF;
        int hi = (this.getByte() & 0xFF) << 8;
        return lo | hi;
    }

    public int getTdsInt() throws TdsException, IOException {
        int b1 = this.getByte() & 0xFF;
        int b2 = (this.getByte() & 0xFF) << 8;
        int b3 = (this.getByte() & 0xFF) << 16;
        int b4 = (this.getByte() & 0xFF) << 24;
        return b4 | b3 | b2 | b1;
    }

    public long getTdsInt64() throws TdsException, IOException {
        long b1 = (long)this.getByte() & 0xFFL;
        long b2 = ((long)this.getByte() & 0xFFL) << 8;
        long b3 = ((long)this.getByte() & 0xFFL) << 16;
        long b4 = ((long)this.getByte() & 0xFFL) << 24;
        long b5 = ((long)this.getByte() & 0xFFL) << 32;
        long b6 = ((long)this.getByte() & 0xFFL) << 40;
        long b7 = ((long)this.getByte() & 0xFFL) << 48;
        long b8 = ((long)this.getByte() & 0xFFL) << 56;
        return b1 | b2 | b3 | b4 | b5 | b6 | b7 | b8;
    }

    private void getPhysicalPacket() throws TdsException, IOException {
        byte packetType;
        int nread = 0;
        while (nread < 8) {
            int amtRead = this.in.read(this.tmpBuf, nread, 8 - nread);
            if (amtRead == -1) {
                throw new IOException("Db server closed connection.");
            }
            nread += amtRead;
        }
        if (Logger.isActive()) {
            String dump = HexDump.hexDump(this.tmpBuf, 8);
            String t = new Timestamp(System.currentTimeMillis()).toString();
            Logger.println("Instance " + this.id + " @ " + t + " received header #" + (this.packetsReceived + 1) + "\n" + dump);
        }
        if ((packetType = this.tmpBuf[0]) != 2 && packetType != 1 && packetType != 4) {
            throw new TdsUnknownPacketType(packetType, this.tmpBuf);
        }
        int len = TdsComm.ntohs(this.tmpBuf, 2) - 8;
        if (len > this.inBuffer.length) {
            this.inBuffer = new byte[len];
        }
        if (len < 0) {
            throw new TdsException("Confused by a length of " + len);
        }
        int nread2 = 0;
        while (nread2 < len) {
            int amtRead = this.in.read(this.inBuffer, nread2, len - nread2);
            if (amtRead == -1) {
                throw new IOException("Db server closed connection.");
            }
            nread2 += amtRead;
        }
        ++this.packetsReceived;
        this.inBufferLen = len;
        this.inBufferIndex = 0;
        if (Logger.isActive()) {
            String dump = HexDump.hexDump(this.inBuffer, len);
            String t = new Timestamp(System.currentTimeMillis()).toString();
            Logger.println("Instance " + this.id + " @ " + t + " received data #" + this.packetsReceived + "\n" + dump);
        }
    }

    void resizeOutbuf(int newsize) {
        if (newsize > this.outBuffer.length) {
            byte[] newBuf = new byte[newsize];
            System.arraycopy(this.outBuffer, 0, newBuf, 0, this.outBuffer.length);
            this.outBuffer = newBuf;
        }
    }

    private static int ntohs(byte[] buf, int offset) {
        int lo = buf[offset + 1] & 0xFF;
        int hi = (buf[offset] & 0xFF) << 8;
        return hi | lo;
    }
}

