/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import net.sourceforge.jtds.jdbc.CallableStatement_base;
import net.sourceforge.jtds.jdbc.DatabaseMetaData;
import net.sourceforge.jtds.jdbc.EscapeProcessor;
import net.sourceforge.jtds.jdbc.PreparedStatement_base;
import net.sourceforge.jtds.jdbc.SQLWarningChain;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsException;
import net.sourceforge.jtds.jdbc.TdsInstance;
import net.sourceforge.jtds.jdbc.TdsStatement;

public class TdsConnection
implements Connection {
    private String host = null;
    private int serverType = -1;
    private int port = -1;
    private int tdsVer = -1;
    private int serverVer = -1;
    private String database = null;
    private Properties initialProps = null;
    private byte maxPrecision = (byte)-1;
    private final Vector tdsPool = new Vector();
    private DatabaseMetaData databaseMetaData = null;
    private boolean autoCommit = true;
    private int transactionIsolationLevel = 2;
    private boolean isClosed = false;
    private boolean lastUpdateCount;
    private SQLWarningChain warningChain;
    private boolean haveMainTds = false;
    final Object mainTdsMonitor = new Object();
    public static final String cvsVersion = "$Id: TdsConnection.java,v 1.17 2004/02/25 01:24:47 alin_sinpalean Exp $";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TdsConnection(Properties props) throws SQLException, TdsException {
        this.host = props.getProperty("HOST");
        this.serverType = Integer.parseInt(props.getProperty("SERVERTYPE"));
        this.port = Integer.parseInt(props.getProperty("PORT"));
        this.database = props.getProperty("DBNAME");
        String user = props.getProperty("USER");
        String password = props.getProperty("PASSWORD");
        this.initialProps = props;
        this.warningChain = new SQLWarningChain();
        if (user == null) {
            user = props.getProperty("USER".toLowerCase());
            if (user == null) {
                throw new SQLException("Need a username.");
            }
            props.put("USER", user);
        }
        if (password == null) {
            password = props.getProperty("PASSWORD".toLowerCase());
            if (password == null) {
                throw new SQLException("Need a password.");
            }
            props.put("PASSWORD", password);
        }
        Tds tmpTds = this.allocateTds(false);
        this.tdsVer = tmpTds.getTdsVer();
        this.serverVer = tmpTds.getDatabaseMajorVersion();
        this.database = tmpTds.getDatabase();
        this.lastUpdateCount = tmpTds.lastUpdateCount();
        this.freeTds(tmpTds);
        TdsStatement stmt = null;
        if (String.valueOf(2).equals(props.getProperty("SERVERTYPE"))) {
            this.maxPrecision = (byte)38;
            return;
        }
        try {
            stmt = new TdsStatement(this);
            ResultSet rs = stmt.executeQuery("SELECT @@MAX_PRECISION");
            rs.next();
            this.maxPrecision = rs.getByte(1);
            Object var8_7 = null;
            if (stmt == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (stmt == null) throw throwable;
            stmt.close();
            throw throwable;
        }
        stmt.close();
    }

    protected int getTdsVer() throws SQLException {
        this.checkClosed();
        return this.tdsVer;
    }

    protected int getServerVer() throws SQLException {
        this.checkClosed();
        return this.tdsVer;
    }

    protected byte getMaxPrecision() {
        return this.maxPrecision;
    }

    public synchronized void setAutoCommit(boolean value) throws SQLException {
        this.checkClosed();
        this.autoCommit = value;
        this.changeSettings();
    }

    private void changeSettings() throws SQLException {
        int i = 0;
        while (i < this.tdsPool.size()) {
            ((TdsInstance)this.tdsPool.elementAt((int)i)).tds.changeSettings(this.autoCommit, this.transactionIsolationLevel);
            ++i;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCatalog(String catalog) throws SQLException {
        if (this.database.equals(catalog)) {
            return;
        }
        int i = 0;
        while (i < this.tdsPool.size()) {
            Tds tds;
            Tds tds2 = tds = ((TdsInstance)this.tdsPool.get((int)i)).tds;
            synchronized (tds2) {
                tds.skipToEnd();
                tds.changeDB(catalog, this.warningChain);
            }
            ++i;
        }
        this.warningChain.checkForExceptions();
        this.database = catalog;
    }

    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        this.transactionIsolationLevel = level;
        this.changeSettings();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.NotImplemented();
    }

    public String getUrl() throws SQLException {
        this.checkClosed();
        return "jdbc:jtds:" + (this.serverType == 2 ? "sybase" : "sqlserver") + "://" + this.host + ":" + this.port + "/" + this.database;
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public synchronized java.sql.DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.databaseMetaData == null) {
            this.databaseMetaData = DatabaseMetaData.getInstance(this, ((TdsInstance)this.tdsPool.get((int)0)).tds);
        }
        return this.databaseMetaData;
    }

    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return false;
    }

    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.database;
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return this.transactionIsolationLevel;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warningChain.getWarnings();
    }

    public Map getTypeMap() throws SQLException {
        return new HashMap();
    }

    public boolean returnLastUpdateCount() {
        return this.lastUpdateCount;
    }

    public synchronized Statement createStatement() throws SQLException {
        this.checkClosed();
        return new TdsStatement(this);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    public String nativeSQL(String sql) throws SQLException {
        return EscapeProcessor.nativeSQL(sql);
    }

    public synchronized void commit() throws SQLException {
        this.commitOrRollback(true);
    }

    public synchronized void rollback() throws SQLException {
        this.commitOrRollback(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        SQLException exception = null;
        int i = 0;
        while (i < this.tdsPool.size()) {
            try {
                Tds tds;
                Tds tds2 = tds = ((TdsInstance)this.tdsPool.elementAt((int)i)).tds;
                synchronized (tds2) {
                    tds.skipToEnd();
                    if (!this.autoCommit) {
                        tds.rollback();
                    }
                    tds.close();
                }
            }
            catch (SQLException ex) {
                ex.setNextException(exception);
                exception = ex;
            }
            ++i;
        }
        this.tdsPool.clear();
        this.clearWarnings();
        this.isClosed = true;
        if (exception != null) {
            throw exception;
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warningChain.clearWarnings();
    }

    public synchronized Statement createStatement(int type, int concurrency) throws SQLException {
        this.checkClosed();
        return new TdsStatement(this, type, concurrency);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return new PreparedStatement_base(this, sql, resultSetType, resultSetConcurrency);
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return new CallableStatement_base(this, sql, resultSetType, resultSetConcurrency);
    }

    private void NotImplemented() throws SQLException {
        throw new SQLException("Not Implemented");
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Tds allocateTds(boolean mainTds) throws SQLException {
        Tds result;
        try {
            Object tmp;
            int i;
            if (mainTds && this.haveMainTds) {
                i = 0;
            } else {
                i = this.findAnAvailableTds();
                if (i == -1) {
                    Tds tmpTds = new Tds(this, this.initialProps);
                    tmp = new TdsInstance(tmpTds);
                    this.tdsPool.addElement(tmp);
                    i = this.findAnAvailableTds();
                }
                if (i == -1) {
                    throw new TdsException("Internal Error. Couldn't get Tds instance.");
                }
                if (mainTds) {
                    if (i != 0) {
                        Object o = this.tdsPool.remove(i);
                        this.tdsPool.insertElementAt(o, 0);
                    }
                    this.haveMainTds = true;
                    i = 0;
                }
            }
            TdsInstance inst = (TdsInstance)this.tdsPool.elementAt(i);
            if (mainTds) {
                tmp = inst.tds;
                synchronized (tmp) {
                }
            }
            if (inst.inUse) {
                throw new TdsException("Internal Error. Tds " + i + " is already allocated.");
            }
            inst.inUse = true;
            result = inst.tds;
        }
        catch (TdsException e) {
            throw new SQLException(e.getMessage());
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        return result;
    }

    private int findAnAvailableTds() {
        int min = this.haveMainTds ? 1 : 0;
        int i = this.tdsPool.size() - 1;
        while (i >= min && ((TdsInstance)this.tdsPool.elementAt((int)i)).inUse) {
            --i;
        }
        return i == 0 && this.haveMainTds ? -1 : i;
    }

    synchronized void freeTds(Tds tds) throws TdsException {
        TdsInstance inst = null;
        int i = this.tdsPool.size() - 1;
        while (i >= 0) {
            inst = (TdsInstance)this.tdsPool.elementAt(i);
            if (tds == inst.tds) break;
            --i;
        }
        if (i >= 0 && inst.inUse) {
            inst.inUse = false;
        } else if (!this.isClosed) {
            throw new TdsException("Tried to free a tds that wasn't in use.");
        }
    }

    private void commitOrRollback(boolean commit) throws SQLException {
        this.warningChain.clearWarnings();
        int i = 0;
        while (i < this.tdsPool.size()) {
            try {
                if (commit) {
                    ((TdsInstance)this.tdsPool.elementAt((int)i)).tds.commit();
                } else {
                    ((TdsInstance)this.tdsPool.elementAt((int)i)).tds.rollback();
                }
            }
            catch (SQLException e) {
                this.warningChain.addException(e);
            }
            ++i;
        }
        this.warningChain.checkForExceptions();
    }

    public Statement createStatement(int param, int param1, int param2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String str, int param, int param2, int param3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String sql, int param) throws SQLException {
        this.checkClosed();
        boolean returnKeys = false;
        if (param == 1 && sql.trim().substring(0, 6).equalsIgnoreCase("INSERT")) {
            StringBuffer tmpSQL = new StringBuffer(sql);
            if (this.serverType == 1 && this.serverVer >= 8) {
                tmpSQL.append("\r\nSELECT SCOPE_IDENTITY() AS ID");
            } else {
                tmpSQL.append("\r\nSELECT @@IDENTITY AS ID");
            }
            sql = tmpSQL.toString();
            returnKeys = true;
        }
        PreparedStatement_base stmt = new PreparedStatement_base(this, sql, 1003, 1007);
        stmt.statementReturnsKeys(returnKeys);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int[] values) throws SQLException {
        if (values == null) {
            throw new SQLException("values cannot be null.");
        }
        if (values.length != 1) {
            throw new SQLException("One valid column index must be supplied.");
        }
        return this.prepareStatement(sql, 1);
    }

    public PreparedStatement prepareStatement(String sql, String[] str1) throws SQLException {
        if (str1 == null) {
            throw new SQLException("str1 cannot be nulll.");
        }
        if (str1.length != 1) {
            throw new SQLException("One valid column name must be supplied.");
        }
        return this.prepareStatement(sql, 1);
    }

    public PreparedStatement prepareStatement(String str, int param, int param2, int param3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setHoldability(int param) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint(String str) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

