/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.sourceforge.jtds.jdbc.Columns;

public class TdsResultSetMetaData
implements ResultSetMetaData {
    public static final String cvsVersion = "$Id: TdsResultSetMetaData.java,v 1.4 2004/02/05 19:00:31 alin_sinpalean Exp $";
    public static final int columnNoNulls = 0;
    public static final int columnNullable = 1;
    public static final int columnNullableUnknown = 2;
    private Columns columnsInfo;

    public TdsResultSetMetaData(Columns columns_) {
        this.columnsInfo = columns_;
    }

    public String getCatalogName(int column) throws SQLException {
        String res = this.columnsInfo.getCatalog(column);
        return res == null ? "" : res;
    }

    public int getColumnCount() throws SQLException {
        return this.columnsInfo.fakeColumnCount();
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        return this.columnsInfo.getDisplaySize(column);
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.columnsInfo.getLabel(column);
    }

    public String getColumnName(int column) throws SQLException {
        return this.columnsInfo.getName(column);
    }

    public int getColumnType(int column) throws SQLException {
        return this.columnsInfo.getJdbcType(column);
    }

    public String getColumnTypeName(int column) throws SQLException {
        if (this.columnsInfo.isAutoIncrement(column).booleanValue()) {
            return this.getCleanTypeName(column) + " identity";
        }
        return this.getCleanTypeName(column);
    }

    private String getCleanTypeName(int column) throws SQLException {
        switch (this.columnsInfo.getNativeType(column)) {
            case 31: {
                return "void";
            }
            case 34: {
                return "image";
            }
            case 35: {
                return "text";
            }
            case 36: {
                return "uniqueidentifier";
            }
            case 37: {
                return "varbinary";
            }
            case 39: {
                return "varchar";
            }
            case 45: {
                return "binary";
            }
            case 47: {
                return "char";
            }
            case 48: {
                return "tinyint";
            }
            case 50: 
            case 104: {
                return "bit";
            }
            case 52: {
                return "smallint";
            }
            case 56: {
                return "int";
            }
            case 58: {
                return "smalldatetime";
            }
            case 59: {
                return "real";
            }
            case 60: {
                return "money";
            }
            case 61: {
                return "datetime";
            }
            case 62: {
                return "float";
            }
            case 106: {
                return "decimal";
            }
            case 108: {
                return "numeric";
            }
            case 112: {
                return "smallmoney";
            }
            case -17: {
                return "nchar";
            }
            case 99: {
                return "ntext";
            }
            case 103: {
                return "nvarchar";
            }
            case 122: {
                return "smallmoney";
            }
            case 38: {
                switch (this.columnsInfo.getBufferSize(column)) {
                    case 1: {
                        return "tinyint";
                    }
                    case 2: {
                        return "smallint";
                    }
                    case 4: {
                        return "int";
                    }
                }
                break;
            }
            case 109: {
                switch (this.columnsInfo.getBufferSize(column)) {
                    case 4: {
                        return "real";
                    }
                    case 8: {
                        return "float";
                    }
                }
                break;
            }
            case 110: {
                switch (this.columnsInfo.getBufferSize(column)) {
                    case 4: {
                        return "smallmoney";
                    }
                    case 8: {
                        return "money";
                    }
                }
                break;
            }
            case 111: {
                switch (this.columnsInfo.getBufferSize(column)) {
                    case 4: {
                        return "smalldatetime";
                    }
                    case 8: {
                        return "datetime";
                    }
                }
            }
        }
        throw new SQLException("Unknown native type for column " + column + ": " + this.columnsInfo.getNativeType(column));
    }

    public int getPrecision(int column) throws SQLException {
        return this.columnsInfo.getPrecision(column);
    }

    public int getScale(int column) throws SQLException {
        int res = this.columnsInfo.getScale(column);
        return res < 0 ? 0 : res;
    }

    public String getSchemaName(int column) throws SQLException {
        String res = this.columnsInfo.getSchema(column);
        return res == null ? "" : res;
    }

    public String getTableName(int column) throws SQLException {
        String res = this.columnsInfo.getTableName(column);
        return res == null ? "" : res;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return this.columnsInfo.isAutoIncrement(column);
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        return this.columnsInfo.isCaseSensitive(column);
    }

    public boolean isCurrency(int column) throws SQLException {
        switch (this.columnsInfo.getNativeType(column)) {
            case 60: 
            case 110: 
            case 112: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    public int isNullable(int column) throws SQLException {
        return this.columnsInfo.isNullable(column);
    }

    public boolean isReadOnly(int column) throws SQLException {
        return this.columnsInfo.isReadOnly(column);
    }

    public boolean isSearchable(int column) throws SQLException {
        return this.columnsInfo.getNativeType(column) != 34;
    }

    public boolean isSigned(int column) throws SQLException {
        switch (this.columnsInfo.getNativeType(column)) {
            case 52: 
            case 56: 
            case 59: 
            case 60: 
            case 62: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 112: 
            case 122: {
                return true;
            }
            case -17: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 58: 
            case 61: 
            case 99: 
            case 103: 
            case 104: 
            case 111: {
                return false;
            }
            case 38: {
                return this.columnsInfo.getBufferSize(column) > 1;
            }
        }
        throw new SQLException("Unknown column type.");
    }

    public boolean isWritable(int column) throws SQLException {
        return this.columnsInfo.isReadOnly(column) == false;
    }

    public String getColumnClassName(int column) throws SQLException {
        switch (this.columnsInfo.getJdbcType(column)) {
            case -7: {
                return "java.lang.Boolean";
            }
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case 7: {
                return "java.lang.Float";
            }
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 91: 
            case 92: 
            case 93: {
                return "java.sql.Timestamp";
            }
            case -4: 
            case -3: 
            case -2: {
                return "byte[]";
            }
        }
        return "";
    }
}

