/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbcx;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import net.sourceforge.jtds.jdbc.TdsConnection;
import net.sourceforge.jtds.jdbcx.PooledConnection;

public class ConnectionProxy
implements Connection {
    private PooledConnection _pooledConnection;
    private TdsConnection _connection;
    private boolean _closed = false;

    public ConnectionProxy(PooledConnection pooledConnection, Connection connection) {
        this._pooledConnection = pooledConnection;
        this._connection = (TdsConnection)connection;
    }

    public void clearWarnings() throws SQLException {
        this.validateConnection();
        try {
            this._connection.clearWarnings();
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void close() throws SQLException {
        if (this._closed) {
            return;
        }
        this._pooledConnection.fireConnectionEvent(true, null);
        this._closed = true;
    }

    public void commit() throws SQLException {
        this.validateConnection();
        try {
            this._connection.commit();
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public Statement createStatement() throws SQLException {
        this.validateConnection();
        try {
            return this._connection.createStatement();
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validateConnection();
        try {
            return this._connection.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateConnection();
        try {
            return this._connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        this.validateConnection();
        try {
            return this._connection.getAutoCommit();
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return false;
        }
    }

    public String getCatalog() throws SQLException {
        this.validateConnection();
        try {
            return this._connection.getCatalog();
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public int getHoldability() throws SQLException {
        this.validateConnection();
        try {
            return this._connection.getHoldability();
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return Integer.MIN_VALUE;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        this.validateConnection();
        try {
            return this._connection.getTransactionIsolation();
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return Integer.MIN_VALUE;
        }
    }

    public Map getTypeMap() throws SQLException {
        this.validateConnection();
        try {
            return this._connection.getTypeMap();
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.validateConnection();
        try {
            return this._connection.getWarnings();
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.validateConnection();
        try {
            return this._connection.getMetaData();
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public boolean isClosed() throws SQLException {
        if (this._closed) {
            return true;
        }
        try {
            return this._connection.isClosed();
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return this._closed;
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.validateConnection();
        try {
            return this._connection.isReadOnly();
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return false;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        this.validateConnection();
        try {
            return this._connection.nativeSQL(sql);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.validateConnection();
        try {
            return this._connection.prepareCall(sql);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validateConnection();
        try {
            return this._connection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateConnection();
        try {
            return this._connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.validateConnection();
        try {
            return this._connection.prepareStatement(sql);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.validateConnection();
        try {
            return this._connection.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.validateConnection();
        try {
            return this._connection.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.validateConnection();
        try {
            return this._connection.prepareStatement(sql, columnNames);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validateConnection();
        try {
            return this._connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateConnection();
        try {
            return this._connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.validateConnection();
        try {
            this._connection.releaseSavepoint(savepoint);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void rollback() throws SQLException {
        this.validateConnection();
        try {
            this._connection.rollback();
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.validateConnection();
        try {
            this._connection.rollback(savepoint);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.validateConnection();
        try {
            this._connection.setAutoCommit(autoCommit);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        this.validateConnection();
        try {
            this._connection.setCatalog(catalog);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        this.validateConnection();
        try {
            this._connection.setHoldability(holdability);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.validateConnection();
        try {
            this._connection.setReadOnly(readOnly);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        this.validateConnection();
        try {
            return this._connection.setSavepoint();
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.validateConnection();
        try {
            return this._connection.setSavepoint(name);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.validateConnection();
        try {
            this._connection.setTransactionIsolation(level);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        this.validateConnection();
        try {
            this._connection.setTypeMap(map);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    private void validateConnection() throws SQLException {
        if (this._closed) {
            throw new SQLException("Connection has been returned to pool and this reference is no longer valid.");
        }
    }

    private void processSQLException(SQLException sqlException) throws SQLException {
        this._pooledConnection.fireConnectionEvent(false, sqlException);
        throw sqlException;
    }
}

