/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbcx;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import net.sourceforge.jtds.jdbc.Driver;
import net.sourceforge.jtds.jdbcx.PooledConnection;

public class TdsDataSource
implements ConnectionPoolDataSource,
DataSource,
Referenceable,
Serializable {
    private int loginTimeout;
    private String databaseName = "";
    private int portNumber = 1433;
    private String serverName;
    private String user;
    private String password = "";
    private String description;
    private String tdsVersion = "7.0";
    private int serverType = 1;
    private String charset;
    private String domain = "";
    private String instance = "";
    private boolean lastUpdateCount = false;
    private boolean sendStringParametersAsUnicode = true;
    static /* synthetic */ Class class$net$sourceforge$jtds$jdbcx$TdsObjectFactory;

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        Properties props = new Properties();
        props.setProperty("HOST", this.serverName);
        props.setProperty("SERVERTYPE", String.valueOf(this.serverType));
        props.setProperty("PORT", String.valueOf(this.portNumber));
        props.setProperty("DBNAME", this.databaseName);
        props.setProperty("TDS", this.tdsVersion);
        props.setProperty("CHARSET", this.charset);
        props.setProperty("DOMAIN", this.domain);
        props.setProperty("INSTANCE", this.instance);
        props.setProperty("LASTUPDATECOUNT", String.valueOf(this.isLastUpdateCount()));
        props.setProperty("SENDSTRINGPARAMETERSASUNICODE", String.valueOf(this.sendStringParametersAsUnicode));
        props.setProperty("USER", user);
        props.setProperty("PASSWORD", password);
        return Driver.getConnection(props);
    }

    public javax.sql.PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(this.user, this.password);
    }

    public synchronized javax.sql.PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new PooledConnection(this.getConnection(user, password));
    }

    public PrintWriter getLogWriter() throws SQLException {
        throw new UnsupportedOperationException("Method getLogWriter() not yet implemented.");
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new UnsupportedOperationException("Method setLogWriter() not yet implemented.");
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.loginTimeout = loginTimeout;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), (class$net$sourceforge$jtds$jdbcx$TdsObjectFactory == null ? (class$net$sourceforge$jtds$jdbcx$TdsObjectFactory = TdsDataSource.class$("net.sourceforge.jtds.jdbcx.TdsObjectFactory")) : class$net$sourceforge$jtds$jdbcx$TdsObjectFactory).getName(), null);
        ref.add(new StringRefAddr("serverName", this.serverName));
        ref.add(new StringRefAddr("portNumber", String.valueOf(this.portNumber)));
        ref.add(new StringRefAddr("databaseName", this.databaseName));
        ref.add(new StringRefAddr("user", this.user));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("charset", this.charset));
        ref.add(new StringRefAddr("tdsVersion", this.tdsVersion));
        ref.add(new StringRefAddr("serverType", String.valueOf(this.serverType)));
        ref.add(new StringRefAddr("domain", this.domain));
        ref.add(new StringRefAddr("instance", this.instance));
        ref.add(new StringRefAddr("lastUpdateCount", String.valueOf(this.isLastUpdateCount())));
        ref.add(new StringRefAddr("sendStringParametersAsUnicode", String.valueOf(this.sendStringParametersAsUnicode)));
        return ref;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setTdsVersion(String tdsVersion) {
        this.tdsVersion = tdsVersion;
    }

    public String getTdsVersion() {
        return this.tdsVersion;
    }

    public void setServerType(int serverType) {
        this.serverType = serverType;
    }

    public int getServerType() {
        return this.serverType;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public boolean getSendStringParametersAsUnicode() {
        return this.sendStringParametersAsUnicode;
    }

    public void setSendStringParametersAsUnicode(boolean sendStringParametersAsUnicode) {
        this.sendStringParametersAsUnicode = sendStringParametersAsUnicode;
    }

    public boolean isLastUpdateCount() {
        return this.lastUpdateCount;
    }

    public void setLastUpdateCount(boolean lastUpdateCount) {
        this.lastUpdateCount = lastUpdateCount;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

