/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.test;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.textui.TestRunner;
import net.sourceforge.jtds.test.DatabaseTestCase;

public class PerformanceTest
extends DatabaseTestCase {
    long count;
    long start;
    long duration;
    static /* synthetic */ Class class$net$sourceforge$jtds$test$PerformanceTest;

    public PerformanceTest(String name) {
        super(name);
    }

    public void testPreparedStatementODBC() throws Exception {
        this.dropTable("jTDSPerformanceTest");
        Statement stmt = this.con.createStatement();
        stmt.execute("CREATE TABLE jTDSPerformanceTest (id int identity(1,1) not null,v_bit bit,v_smallint smallint,v_tinyint tinyint,v_decimal decimal(28,11),v_money money,v_smallmoney smallmoney,v_float float,v_real real,v_datetime datetime,v_smalldatetime smalldatetime,v_char char(255),v_varchar varchar(255),v_binary binary(255),v_varbinary varbinary(255),primary key (id))");
        stmt.close();
        try {
            try {
                this.connectODBC();
                this.populate("ODBC");
            }
            catch (AssertionFailedError e) {
                if ("Connection properties not found (conf/odbc-connection.properties).".equals(e.getMessage())) {
                    System.err.println("Skipping ODBC tests.");
                    Object var4_3 = null;
                    this.connect();
                    return;
                }
                throw e;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.connect();
            throw throwable;
        }
        this.connect();
    }

    public void testPreparedStatement() throws Exception {
        this.populate("jTDS");
    }

    private void populate(String name) throws SQLException {
        this.start("Populate " + name);
        PreparedStatement pstmt = this.con.prepareStatement("insert into jTDSPerformanceTest (v_bit, v_smallint, v_tinyint, v_decimal, v_money, v_smallmoney, v_float, v_real, v_datetime, v_smalldatetime, v_char, v_varchar, v_binary, v_varbinary) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        Boolean[] vBit = new Boolean[]{Boolean.TRUE, Boolean.FALSE, null};
        BigDecimal dec = new BigDecimal("12374335.34232211212");
        BigDecimal money = new BigDecimal("1234567890.1234");
        BigDecimal smoney = new BigDecimal("123456.1234");
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        byte[] smallBinary = "This is a test.".getBytes();
        int i = 0;
        while (i < 1000) {
            int j = 1;
            while (j < 15) {
                if (j == 5 || j == 6) {
                    pstmt.setNull(j, 3);
                } else if (j == 13 || j == 14) {
                    pstmt.setNull(j, -2);
                } else {
                    pstmt.setNull(j, 12);
                }
                ++j;
            }
            Assert.assertEquals((int)1, (int)pstmt.executeUpdate());
            this.progress();
            ++i;
        }
        pstmt.close();
        this.end();
    }

    public void testCursorScrollODBC() throws Exception {
        try {
            try {
                this.connectODBC();
                this.runCursorScroll("ODBC", this.con);
            }
            catch (AssertionFailedError e) {
                if ("Connection properties not found (conf/odbc-connection.properties).".equals(e.getMessage())) {
                    System.err.println("Skipping ODBC tests.");
                    Object var3_2 = null;
                    this.connect();
                    return;
                }
                throw e;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.connect();
            throw throwable;
        }
        this.connect();
    }

    public void testCursorScroll() throws Exception {
        this.runCursorScroll("jTDS", this.con);
    }

    void runCursorScroll(String name, Connection con) throws Exception {
        int i;
        Statement stmt = con.createStatement(1004, 1007);
        ResultSet rs = stmt.executeQuery("Select * from jTDSPerformanceTest");
        this.start("Cursor scroll " + name);
        int cnt = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            i = 1;
            while (i <= cnt) {
                rs.getObject(i);
                ++i;
            }
            this.progress();
        }
        while (rs.previous()) {
            i = 1;
            while (i <= cnt) {
                rs.getObject(i);
                ++i;
            }
            this.progress();
        }
        this.end();
        rs.close();
        stmt.close();
    }

    public void testDiscardODBC() throws Exception {
        try {
            try {
                this.connectODBC();
                this.runDiscard("ODBC");
            }
            catch (AssertionFailedError e) {
                if ("Connection properties not found (conf/odbc-connection.properties).".equals(e.getMessage())) {
                    System.err.println("Skipping ODBC tests.");
                    Object var3_2 = null;
                    this.connect();
                    return;
                }
                throw e;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.connect();
            throw throwable;
        }
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiscard() throws Exception {
        try {
            this.runDiscard("jTDS");
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.dropTable("jTDSPerformanceTest");
            throw throwable;
        }
        this.dropTable("jTDSPerformanceTest");
    }

    public void runDiscard(String name) throws Exception {
        Statement stmt = this.con.createStatement(1004, 1007);
        ResultSet rs = stmt.executeQuery("Select * from jTDSPerformanceTest");
        this.start("Discard " + name);
        while (rs.next()) {
            rs.getObject(1);
            this.progress();
        }
        this.end();
        rs.close();
        stmt.close();
    }

    void start(String name) {
        System.out.print("Starting " + name);
        System.out.flush();
        this.count = 0L;
        this.start = System.currentTimeMillis();
    }

    void progress() {
        ++this.count;
        if (this.count % 100L == 0L) {
            System.out.print(".");
            System.out.flush();
        }
    }

    void end() {
        this.duration = System.currentTimeMillis() - this.start;
        System.out.println("OK");
        System.out.println("Time " + this.duration + "ms.");
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$net$sourceforge$jtds$test$PerformanceTest == null ? (class$net$sourceforge$jtds$test$PerformanceTest = PerformanceTest.class$("net.sourceforge.jtds.test.PerformanceTest")) : class$net$sourceforge$jtds$test$PerformanceTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

