/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.test;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestBase
extends TestCase {
    Connection con;
    Properties props;

    public TestBase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.connect();
    }

    public void tearDown() throws Exception {
        this.disconnect();
    }

    public Connection getConnection() throws Exception {
        String fileName = "conf/connection.properties";
        this.props = this.loadProperties(fileName);
        Class.forName(this.props.getProperty("driver"));
        String url = this.props.getProperty("url");
        Connection con = DriverManager.getConnection(url, this.props);
        this.showWarnings(con.getWarnings());
        this.initLanguage(con);
        return con;
    }

    public void showWarnings(SQLWarning w) {
        while (w != null) {
            System.out.println(w.getMessage());
            w = w.getNextWarning();
        }
    }

    private void disconnect() throws Exception {
        if (this.con != null) {
            this.con.close();
            this.con = null;
        }
    }

    protected void connect() throws Exception {
        this.disconnect();
        this.con = this.getConnection();
    }

    protected void connectODBC() throws Exception {
        this.disconnect();
        this.con = this.getConnectionODBC();
    }

    public void dump(ResultSet rs) throws SQLException {
        ResultSetMetaData rsm = rs.getMetaData();
        int cols = rsm.getColumnCount();
        int i = 1;
        while (i <= cols) {
            if (i > 1) {
                System.out.print(", ");
            }
            System.out.print(rsm.getColumnName(i));
            ++i;
        }
        System.out.println();
        while (rs.next()) {
            this.dumpRow(rs);
        }
    }

    public void dumpRow(ResultSet rs) throws SQLException {
        ResultSetMetaData rsm = rs.getMetaData();
        int cols = rsm.getColumnCount();
        int i = 1;
        while (i <= cols) {
            if (i > 1) {
                System.out.print(", ");
            }
            System.out.print(rs.getObject(i));
            ++i;
        }
        System.out.println();
    }

    public Connection getConnectionODBC() throws Exception {
        Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        String fileName = "conf/odbc-connection.properties";
        Properties props = this.loadProperties(fileName);
        String url = props.getProperty("url");
        Connection con = DriverManager.getConnection(url, props);
        this.showWarnings(con.getWarnings());
        this.initLanguage(con);
        return con;
    }

    private void initLanguage(Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        stmt.executeUpdate("set LANGUAGE 'us_english'");
        stmt.close();
    }

    private Properties loadProperties(String fileName) throws Exception {
        File propFile = new File(fileName);
        if (!propFile.exists()) {
            Assert.fail((String)("Connection properties not found (" + propFile + ")."));
        }
        Properties props = new Properties();
        props.load(new FileInputStream(propFile));
        return props;
    }

    protected void makeTestTables(Statement stmt) throws SQLException {
        String sql = "CREATE TABLE #test ( f_int INT, f_varchar VARCHAR(255) )";
        stmt.execute(sql);
    }

    public void makeObjects(Statement stmt, int count) throws SQLException {
        stmt.execute("TRUNCATE TABLE #test");
        int i = 0;
        while (i < count) {
            String sql = "INSERT INTO #test(f_int, f_varchar) VALUES (" + i + ", 'Row " + i + "')";
            stmt.execute(sql);
            ++i;
        }
    }
}

