/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.test;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import net.sourceforge.jtds.jdbc.EscapeProcessor;
import net.sourceforge.jtds.test.DatabaseTestCase;
import net.sourceforge.jtds.util.Logger;

public class TimestampTest
extends DatabaseTestCase {
    static /* synthetic */ Class class$net$sourceforge$jtds$test$TimestampTest;

    public TimestampTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        boolean loggerActive = args.length > 0;
        Logger.setActive(loggerActive);
        if (args.length > 0) {
            TestSuite s = new TestSuite();
            int i = 0;
            while (i < args.length) {
                s.addTest((Test)new TimestampTest(args[i]));
                ++i;
            }
            TestRunner.run((Test)s);
        } else {
            TestRunner.run((Class)(class$net$sourceforge$jtds$test$TimestampTest == null ? (class$net$sourceforge$jtds$test$TimestampTest = TimestampTest.class$("net.sourceforge.jtds.test.TimestampTest")) : class$net$sourceforge$jtds$test$TimestampTest));
        }
    }

    public void testBigint0000() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0000");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0000   (i  decimal(28,10) not null,    s  char(10) not null) ");
        int rowsToAdd = 20;
        int count = 0;
        int i = 1;
        while (i <= 20) {
            String sql = "insert into #t0000 values (" + i + ", 'row" + i + "')";
            count += stmt.executeUpdate(sql);
            ++i;
        }
        Assert.assertTrue((count == 20 ? 1 : 0) != 0);
        PreparedStatement pStmt = cx.prepareStatement("select i from #t0000 where i = ?");
        pStmt.setLong(1, 7L);
        ResultSet rs = pStmt.executeQuery();
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertTrue((rs.getLong(1) == 7L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
        pStmt.setLong(1, 8L);
        rs = pStmt.executeQuery();
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertTrue((rs.getLong(1) == 8L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
    }

    public void testTimestamps0001() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0001");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0001               (t1 datetime not null,          t2 datetime null,              t3 smalldatetime not null,     t4 smalldatetime null)");
        PreparedStatement pStmt = cx.prepareStatement("insert into #t0001 values (?, '1998-03-09 15:35:06.4',                                  ?, '1998-03-09 15:35:00')");
        Timestamp t0 = Timestamp.valueOf("1998-03-09 15:35:06.4");
        Timestamp t1 = Timestamp.valueOf("1998-03-09 15:35:00");
        pStmt.setTimestamp(1, t0);
        pStmt.setTimestamp(2, t1);
        int count = pStmt.executeUpdate();
        Assert.assertTrue((count == 1 ? 1 : 0) != 0);
        pStmt.close();
        pStmt = cx.prepareStatement("select t1, t2, t3, t4 from #t0001");
        ResultSet rs = pStmt.executeQuery();
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertEquals((Object)t0, (Object)rs.getTimestamp(1));
        Assert.assertEquals((Object)t0, (Object)rs.getTimestamp(2));
        Assert.assertEquals((Object)t1, (Object)rs.getTimestamp(3));
        Assert.assertEquals((Object)t1, (Object)rs.getTimestamp(4));
    }

    public void testTimestamps0004() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0004");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0004   (mytime  datetime not null,    mytime2 datetime null,        mytime3 datetime null     )");
        PreparedStatement pStmt = cx.prepareStatement("insert into #t0004 values ('1964-02-14 10:00:00.0', ?, ?)");
        Timestamp t0 = Timestamp.valueOf("1964-02-14 10:00:00.0");
        pStmt.setTimestamp(1, t0);
        pStmt.setTimestamp(2, t0);
        int count = pStmt.executeUpdate();
        pStmt.setNull(2, 93);
        count = pStmt.executeUpdate();
        pStmt.close();
        pStmt = cx.prepareStatement("select mytime, mytime2, mytime3 from #t0004");
        ResultSet rs = pStmt.executeQuery();
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Timestamp t1 = rs.getTimestamp(1);
        Timestamp t2 = rs.getTimestamp(2);
        Timestamp t3 = rs.getTimestamp(3);
        Assert.assertEquals((Object)t0, (Object)t1);
        Assert.assertEquals((Object)t0, (Object)t2);
        Assert.assertEquals((Object)t0, (Object)t3);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        t1 = rs.getTimestamp(1);
        t2 = rs.getTimestamp(2);
        t3 = rs.getTimestamp(3);
        Assert.assertEquals((Object)t0, (Object)t1);
        Assert.assertEquals((Object)t0, (Object)t2);
        Assert.assertEquals(null, (Object)t3);
    }

    public void testEscape(String sql, String expected) throws Exception {
        String tmp = EscapeProcessor.nativeSQL(sql);
        Assert.assertEquals((Object)tmp, (Object)expected);
    }

    public void testEscapes0006() throws Exception {
        this.testEscape("select * from tmp where d={d 1999-09-19}", "select * from tmp where d='19990919'");
        this.testEscape("select * from tmp where d={d '1999-09-19'}", "select * from tmp where d='19990919'");
        this.testEscape("select * from tmp where t={t 12:34:00}", "select * from tmp where t='12:34:00'");
        this.testEscape("select * from tmp where ts={ts 1998-12-15 12:34:00.1234}", "select * from tmp where ts='19981215 12:34:00.123'");
        this.testEscape("select * from tmp where ts={ts 1998-12-15 12:34:00}", "select * from tmp where ts='19981215 12:34:00.000'");
        this.testEscape("select * from tmp where ts={ts 1998-12-15 12:34:00.1}", "select * from tmp where ts='19981215 12:34:00.100'");
        this.testEscape("select * from tmp where ts={ts 1998-12-15 12:34:00}", "select * from tmp where ts='19981215 12:34:00.000'");
        this.testEscape("select * from tmp where d={d 1999-09-19}", "select * from tmp where d='19990919'");
        this.testEscape("select * from tmp where a like '\\%%'", "select * from tmp where a like '\\%%'");
        this.testEscape("select * from tmp where a like 'b%%' {escape 'b'}", "select * from tmp where a like 'b%%' escape 'b'");
        this.testEscape("select * from tmp where a like 'bbb' {escape 'b'}", "select * from tmp where a like 'bbb' escape 'b'");
        this.testEscape("select * from tmp where a='{fn user}'", "select * from tmp where a='{fn user}'");
        this.testEscape("select * from tmp where a={fn user()}", "select * from tmp where a=user_name()");
    }

    public void testPreparedStatement0007() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0007");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0007   (i  integer  not null,    s  char(10) not null) ");
        int rowsToAdd = 20;
        int count = 0;
        int i = 1;
        while (i <= 20) {
            String sql = "insert into #t0007 values (" + i + ", 'row" + i + "')";
            count += stmt.executeUpdate(sql);
            ++i;
        }
        Assert.assertTrue((count == 20 ? 1 : 0) != 0);
        PreparedStatement pStmt = cx.prepareStatement("select s from #t0007 where i = ?");
        pStmt.setInt(1, 7);
        ResultSet rs = pStmt.executeQuery();
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertEquals((Object)rs.getString(1).trim(), (Object)"row7");
        pStmt.setInt(1, 8);
        rs = pStmt.executeQuery();
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertEquals((Object)rs.getString(1).trim(), (Object)"row8");
        Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
    }

    public void testPreparedStatement0008() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0008");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0008                (i  integer  not null,         s  char(10) not null)      ");
        PreparedStatement pStmt = cx.prepareStatement("insert into #t0008 values (?, ?)");
        int rowsToAdd = 8;
        String theString = "abcdefghijklmnopqrstuvwxyz";
        int count = 0;
        int i = 1;
        while (i <= 8) {
            pStmt.setInt(1, i);
            pStmt.setString(2, "abcdefghijklmnopqrstuvwxyz".substring(0, i));
            count += pStmt.executeUpdate();
            ++i;
        }
        Assert.assertTrue((count == 8 ? 1 : 0) != 0);
        pStmt.close();
        ResultSet rs = stmt.executeQuery("select s, i from #t0008");
        Assert.assertNotNull((Object)rs);
        count = 0;
        while (rs.next()) {
            ++count;
            Assert.assertTrue((rs.getString(1).trim().length() == rs.getInt(2) ? 1 : 0) != 0);
        }
        Assert.assertTrue((count == 8 ? 1 : 0) != 0);
    }

    public void testPreparedStatement0009() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0009");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0009   (i  integer  not null,         s  char(10) not null)      ");
        cx.setAutoCommit(false);
        PreparedStatement pStmt = cx.prepareStatement("insert into #t0009 values (?, ?)");
        int rowsToAdd = 8;
        String theString = "abcdefghijklmnopqrstuvwxyz";
        int count = 0;
        int i = 1;
        while (i <= rowsToAdd) {
            pStmt.setInt(1, i);
            pStmt.setString(2, "abcdefghijklmnopqrstuvwxyz".substring(0, i));
            count += pStmt.executeUpdate();
            ++i;
        }
        pStmt.close();
        Assert.assertTrue((count == rowsToAdd ? 1 : 0) != 0);
        cx.rollback();
        stmt = cx.createStatement();
        ResultSet rs = stmt.executeQuery("select s, i from #t0009");
        Assert.assertNotNull((Object)rs);
        count = 0;
        while (rs.next()) {
            ++count;
            Assert.assertTrue((rs.getString(1).trim().length() == rs.getInt(2) ? 1 : 0) != 0);
        }
        Assert.assertTrue((count == 0 ? 1 : 0) != 0);
        cx.commit();
        stmt.close();
        pStmt = cx.prepareStatement("insert into #t0009 values (?, ?)");
        rowsToAdd = 6;
        count = 0;
        int i2 = 1;
        while (i2 <= rowsToAdd) {
            pStmt.setInt(1, i2);
            pStmt.setString(2, "abcdefghijklmnopqrstuvwxyz".substring(0, i2));
            count += pStmt.executeUpdate();
            ++i2;
        }
        Assert.assertTrue((count == rowsToAdd ? 1 : 0) != 0);
        cx.commit();
        pStmt.close();
        stmt = cx.createStatement();
        rs = stmt.executeQuery("select s, i from #t0009");
        count = 0;
        while (rs.next()) {
            ++count;
            Assert.assertTrue((rs.getString(1).trim().length() == rs.getInt(2) ? 1 : 0) != 0);
        }
        Assert.assertTrue((count == rowsToAdd ? 1 : 0) != 0);
        cx.commit();
        stmt.close();
        cx.setAutoCommit(true);
    }

    public void testTransactions0010() throws Exception {
        int i;
        Connection cx = this.getConnection();
        this.dropTable("#t0010");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0010   (i  integer  not null,         s  char(10) not null)      ");
        cx.setAutoCommit(false);
        PreparedStatement pStmt = cx.prepareStatement("insert into #t0010 values (?, ?)");
        int rowsToAdd = 8;
        String theString = "abcdefghijklmnopqrstuvwxyz";
        int count = 0;
        int i2 = 1;
        while (i2 <= rowsToAdd) {
            pStmt.setInt(1, i2);
            pStmt.setString(2, "abcdefghijklmnopqrstuvwxyz".substring(0, i2));
            count += pStmt.executeUpdate();
            ++i2;
        }
        Assert.assertTrue((count == rowsToAdd ? 1 : 0) != 0);
        cx.rollback();
        stmt = cx.createStatement();
        ResultSet rs = stmt.executeQuery("select s, i from #t0010");
        Assert.assertNotNull((Object)rs);
        count = 0;
        while (rs.next()) {
            ++count;
            Assert.assertTrue((rs.getString(1).trim().length() == rs.getInt(2) ? 1 : 0) != 0);
        }
        Assert.assertTrue((count == 0 ? 1 : 0) != 0);
        cx.commit();
        rowsToAdd = 6;
        int j = 1;
        while (j <= 2) {
            count = 0;
            i = 1;
            while (i <= rowsToAdd) {
                pStmt.setInt(1, i + (j - 1) * rowsToAdd);
                pStmt.setString(2, "abcdefghijklmnopqrstuvwxyz".substring(0, i));
                count += pStmt.executeUpdate();
                ++i;
            }
            Assert.assertTrue((count == rowsToAdd ? 1 : 0) != 0);
            cx.commit();
            ++j;
        }
        rs = stmt.executeQuery("select s, i from #t0010");
        count = 0;
        while (rs.next()) {
            ++count;
            i = rs.getInt(2);
            if (i > rowsToAdd) {
                i -= rowsToAdd;
            }
            Assert.assertTrue((rs.getString(1).trim().length() == i ? 1 : 0) != 0);
        }
        Assert.assertTrue((count == 2 * rowsToAdd ? 1 : 0) != 0);
        cx.commit();
        cx.setAutoCommit(true);
    }

    public void testEmptyResults0011() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0011");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0011   (mytime  datetime not null,    mytime2 datetime null     )");
        ResultSet rs = stmt.executeQuery("select mytime, mytime2 from #t0011");
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
        stmt.close();
        stmt = cx.createStatement();
        rs = stmt.executeQuery("select mytime, mytime2 from #t0011");
        Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
        stmt.close();
    }

    public void testEmptyResults0012() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0012");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0012   (mytime  datetime not null,    mytime2 datetime null     )");
        PreparedStatement pStmt = cx.prepareStatement("select mytime, mytime2 from #t0012");
        ResultSet rs = pStmt.executeQuery();
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
        rs.close();
        rs = pStmt.executeQuery();
        Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
        pStmt.close();
    }

    public void testEmptyResults0013() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0013");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0013   (mytime  datetime not null,    mytime2 datetime null     )");
        ResultSet rs1 = stmt.executeQuery("select mytime, mytime2 from #t0013");
        Assert.assertNotNull((Object)rs1);
        Assert.assertTrue((String)"Expected no result set", (!rs1.next() ? 1 : 0) != 0);
        PreparedStatement pStmt = cx.prepareStatement("select mytime, mytime2 from #t0013");
        ResultSet rs2 = pStmt.executeQuery();
        Assert.assertNotNull((Object)rs2);
        Assert.assertTrue((String)"Expected no result set", (!rs2.next() ? 1 : 0) != 0);
    }

    public void testForBrowse0014() throws Exception {
        int n;
        Connection cx = this.getConnection();
        this.dropTable("#t0014");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0014 (i integer not null)");
        PreparedStatement pStmt = cx.prepareStatement("insert into #t0014 values (?)");
        int rowsToAdd = 100;
        int count = 0;
        int i = 1;
        while (i <= 100) {
            pStmt.setInt(1, i);
            count += pStmt.executeUpdate();
            ++i;
        }
        Assert.assertTrue((count == 100 ? 1 : 0) != 0);
        pStmt.close();
        pStmt = cx.prepareStatement("select i from #t0014 for browse");
        ResultSet rs = pStmt.executeQuery();
        Assert.assertNotNull((Object)rs);
        count = 0;
        while (rs.next()) {
            n = rs.getInt("i");
            ++count;
        }
        Assert.assertTrue((count == 100 ? 1 : 0) != 0);
        pStmt.close();
        rs = stmt.executeQuery("select * from #t0014");
        Assert.assertNotNull((Object)rs);
        count = 0;
        while (rs.next()) {
            n = rs.getInt("i");
            ++count;
        }
        Assert.assertTrue((count == 100 ? 1 : 0) != 0);
        rs = stmt.executeQuery("select * from #t0014");
        Assert.assertNotNull((Object)rs);
        count = 0;
        while (rs.next() && count < 5) {
            n = rs.getInt("i");
            ++count;
        }
        Assert.assertTrue((count == 5 ? 1 : 0) != 0);
        rs = stmt.executeQuery("select * from #t0014");
        Assert.assertNotNull((Object)rs);
        count = 0;
        while (rs.next()) {
            n = rs.getInt("i");
            ++count;
        }
        Assert.assertTrue((count == 100 ? 1 : 0) != 0);
        stmt.close();
    }

    public void testMultipleResults0015() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0015");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0015   (i  integer  not null,         s  char(10) not null)      ");
        PreparedStatement pStmt = cx.prepareStatement("insert into #t0015 values (?, ?)");
        int rowsToAdd = 8;
        String theString = "abcdefghijklmnopqrstuvwxyz";
        int count = 0;
        int i = 1;
        while (i <= rowsToAdd) {
            pStmt.setInt(1, i);
            pStmt.setString(2, "abcdefghijklmnopqrstuvwxyz".substring(0, i));
            count += pStmt.executeUpdate();
            ++i;
        }
        Assert.assertTrue((count == rowsToAdd ? 1 : 0) != 0);
        pStmt.close();
        stmt = cx.createStatement();
        ResultSet rs = stmt.executeQuery("select s from #t0015 select i from #t0015");
        Assert.assertNotNull((Object)rs);
        count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertTrue((count == rowsToAdd ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stmt.getMoreResults());
        rs = stmt.getResultSet();
        Assert.assertNotNull((Object)rs);
        count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertTrue((count == rowsToAdd ? 1 : 0) != 0);
        rs = stmt.executeQuery("select i, s from #t0015");
        count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertTrue((count == rowsToAdd ? 1 : 0) != 0);
        cx.close();
    }

    public void testMissingParameter0016() throws Exception {
        ResultSet rs;
        Connection cx = this.getConnection();
        this.dropTable("#t0016");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0016   (i  integer  not null,         s  char(10) not null)      ");
        stmt = cx.createStatement();
        int rowsToAdd = 20;
        int count = 0;
        int i = 1;
        while (i <= 20) {
            String sql = "insert into #t0016 values (" + i + ", 'row" + i + "')";
            count += stmt.executeUpdate(sql);
            ++i;
        }
        Assert.assertTrue((count == 20 ? 1 : 0) != 0);
        PreparedStatement pStmt = cx.prepareStatement("select s from #t0016 where i=? and s=?");
        try {
            rs = pStmt.executeQuery();
            Assert.assertTrue((String)"Failed to throw exception", (boolean)false);
        }
        catch (SQLException e) {
            Assert.assertTrue((e.getMessage().equals("parameter #1 has not been set") || e.getMessage().equals("parameter #2 has not been set") ? 1 : 0) != 0);
        }
        pStmt.clearParameters();
        try {
            pStmt.setInt(1, 7);
            pStmt.setString(2, "row7");
            pStmt.clearParameters();
            rs = pStmt.executeQuery();
            Assert.assertTrue((String)"Failed to throw exception", (boolean)false);
        }
        catch (SQLException e) {
            Assert.assertTrue((e.getMessage().equals("parameter #1 has not been set") || e.getMessage().equals("parameter #2 has not been set") ? 1 : 0) != 0);
        }
        pStmt.clearParameters();
        try {
            pStmt.setInt(1, 7);
            rs = pStmt.executeQuery();
            Assert.assertTrue((String)"Failed to throw exception", (boolean)false);
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().equals("parameter #2 has not been set"));
        }
        pStmt.clearParameters();
        try {
            pStmt.setString(2, "row7");
            rs = pStmt.executeQuery();
            Assert.assertTrue((String)"Failed to throw exception", (boolean)false);
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().equals("parameter #1 has not been set"));
        }
    }

    Object[][] getDatatypes() {
        return new Object[][]{{"float(6)", "65.4321", new BigDecimal("65.4321")}, {"binary(5)", "0x1213141516", new byte[]{18, 19, 20, 21, 22}}, {"varbinary(4)", "0x1718191A", new byte[]{23, 24, 25, 26}}, {"varchar(8)", "'12345678'", new String("12345678")}, {"datetime", "'19990815 21:29:59.01'", Timestamp.valueOf("1999-08-15 21:29:59.01")}, {"smalldatetime", "'19990215 20:45'", Timestamp.valueOf("1999-02-15 20:45:00")}, {"float(6)", "65.4321", new Float(65.4321)}, {"float(14)", "1.123456789", new Double(1.123456789)}, {"real", "7654321.0", new Double(7654321.0)}, {"int", "4097", new Integer(4097)}, {"float(6)", "65.4321", new BigDecimal("65.4321")}, {"float(14)", "1.123456789", new BigDecimal("1.123456789")}, {"decimal(10,3)", "1234567.089", new BigDecimal("1234567.089")}, {"numeric(5,4)", "1.2345", new BigDecimal("1.2345")}, {"smallint", "4094", new Short(4094)}, {"tinyint", "127", new Byte(127)}, {"tinyint", "128", new Short(128)}, {"money", "19.95", new BigDecimal("19.95")}, {"smallmoney", "9.97", new BigDecimal("9.97")}, {"bit", "1", Boolean.TRUE}, {"image", "0x0a0a0b", new byte[]{10, 10, 11}}};
    }

    public void testOutputParams() throws Exception {
        Statement stmt = this.con.createStatement();
        this.dropProcedure("#jtds_outputTest");
        Object[][] datatypes = this.getDatatypes();
        int i = 0;
        while (i < datatypes.length) {
            boolean bImage = datatypes[i][0].equals("image");
            String valueToAssign = bImage ? "" : " = " + datatypes[i][1];
            String sql = "create procedure #jtds_outputTest @a1 " + datatypes[i][0] + " = null out " + "as select @a1" + valueToAssign;
            stmt.executeUpdate(sql);
            int pass = 0;
            while (pass < 2 && !bImage || pass < 1) {
                CallableStatement cstmt = this.con.prepareCall("{call #jtds_outputTest(?)}");
                int jtype = DatabaseTestCase.getType(datatypes[i][2]);
                if (pass == 1) {
                    cstmt.setObject(1, null, jtype, 10);
                }
                if (jtype == 2 || jtype == 3) {
                    cstmt.registerOutParameter(1, jtype, 10);
                    if (pass == 0) {
                        cstmt.setObject(1, datatypes[i][2], jtype, 10);
                    }
                } else if (jtype == 12) {
                    cstmt.registerOutParameter(1, jtype, 255);
                    if (pass == 0) {
                        cstmt.setObject(1, datatypes[i][2]);
                    }
                } else {
                    cstmt.registerOutParameter(1, jtype);
                    if (pass == 0) {
                        cstmt.setObject(1, datatypes[i][2]);
                    }
                }
                Assert.assertEquals((boolean)bImage, (boolean)cstmt.execute());
                while (cstmt.getUpdateCount() != -1 || cstmt.getMoreResults()) {
                }
                if (jtype == -3) {
                    Assert.assertTrue((DatabaseTestCase.compareBytes(cstmt.getBytes(1), (byte[])datatypes[i][2]) == 0 ? 1 : 0) != 0);
                } else if (datatypes[i][2] instanceof Number) {
                    Number n = (Number)cstmt.getObject(1);
                    if (n != null) {
                        Assert.assertEquals((String)("Failed on " + datatypes[i][0]), (double)n.doubleValue(), (double)((Number)datatypes[i][2]).doubleValue(), (double)0.001);
                    } else {
                        Assert.assertEquals((String)("Failed on " + datatypes[i][0]), (Object)n, (Object)datatypes[i][2]);
                    }
                } else {
                    Assert.assertEquals((String)("Failed on " + datatypes[i][0]), (Object)cstmt.getObject(1), (Object)datatypes[i][2]);
                }
                ++pass;
            }
            stmt.executeUpdate(" drop procedure #jtds_outputTest");
            ++i;
        }
    }

    public void testDatatypes0017() throws Exception {
        Connection cx = this.getConnection();
        Statement stmt = cx.createStatement();
        this.dropTable("#t0017");
    }

    public void testStatements0020() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0020a");
        this.dropTable("#t0020b");
        this.dropTable("#t0020c");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0020a (   i1   int not null,       s1   char(10) not null )                        ");
        stmt.executeUpdate("create table #t0020b (   i2a   int not null,       i2b   int not null,       s2   char(10) not null )                        ");
        stmt.executeUpdate("create table #t0020c (   i3   int not null,       s3   char(10) not null )                        ");
        int nextB = 1;
        int nextC = 1;
        int i = 1;
        while (i < 50) {
            stmt.executeUpdate("insert into #t0020a   values(" + i + ", " + "         'row" + i + "') " + "");
            int j = nextB;
            while (nextB % 5 != 0) {
                stmt.executeUpdate("insert into #t0020b  values(" + i + ", " + "        " + j + ", " + "        'row" + i + "." + j + "' " + "        )" + "");
                int k = nextC;
                while (nextC % 3 != 0) {
                    stmt.executeUpdate("insert into #t0020c  values(" + j + ", " + "        'row" + i + "." + j + "." + k + "' " + "        )" + "");
                    ++k;
                    ++nextC;
                }
                ++j;
                ++nextB;
            }
            ++i;
        }
        Statement stmtA = cx.createStatement();
        PreparedStatement stmtB = cx.prepareStatement("select i2b, s2 from #t0020b where i2a=?");
        PreparedStatement stmtC = cx.prepareStatement("select s3 from #t0020c where i3=?");
        ResultSet rs1 = stmtA.executeQuery("select i1 from #t0020a");
        Assert.assertNotNull((Object)rs1);
        while (rs1.next()) {
            int i1 = rs1.getInt("i1");
            stmtB.setInt(1, rs1.getInt("i1"));
            ResultSet rs2 = stmtB.executeQuery();
            Assert.assertNotNull((Object)rs2);
            while (rs2.next()) {
                stmtC.setInt(1, rs2.getInt(1));
                ResultSet rs3 = stmtC.executeQuery();
                Assert.assertNotNull((Object)rs3);
                if (!rs3.next()) continue;
            }
        }
    }

    public void testBlob0021() throws Exception {
        byte[] smallarray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        byte[] array1 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};
        String bigtext1 = "abcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnop";
        Connection cx = this.getConnection();
        Statement stmt = cx.createStatement();
        this.dropTable("#t0021");
        stmt.executeUpdate("create table #t0021 (  mybinary         binary(16) not null,  myimage          image not null,  mynullimage      image null,  mytext           text not null,  mynulltext       text null) ");
        PreparedStatement insert = cx.prepareStatement("insert into #t0021(      mybinary,              myimage,               mynullimage,           mytext,                mynulltext            )                      values(?, ?, ?, ?, ?)  ");
        insert.setBytes(1, smallarray);
        insert.setBytes(2, array1);
        insert.setBytes(3, array1);
        insert.setString(4, "abcd");
        insert.setString(5, "defg");
        int count = insert.executeUpdate();
        Assert.assertTrue((count == 1 ? 1 : 0) != 0);
        insert.close();
        ResultSet rs = stmt.executeQuery("select * from #t0021");
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        byte[] a1 = rs.getBytes("myimage");
        byte[] a2 = rs.getBytes("mynullimage");
        Assert.assertTrue((DatabaseTestCase.compareBytes(a1, array1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((DatabaseTestCase.compareBytes(a2, array1) == 0 ? 1 : 0) != 0);
        cx.close();
    }

    public void testNestedStatements0022() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0022a");
        this.dropTable("#t0022b");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0022a   (i   integer not null,    str char(254) not null) ");
        stmt.executeUpdate("create table #t0022b               (i   integer not null,         t   datetime not null)     ");
        PreparedStatement pStmtA = cx.prepareStatement("insert into #t0022a values (?, ?)");
        PreparedStatement pStmtB = cx.prepareStatement("insert into #t0022b values (?, getdate())");
        int rowsToAdd = 1000;
        int count = 0;
        int i = 1;
        while (i <= 1000) {
            pStmtA.setInt(1, i);
            String tmp = "";
            while (tmp.length() < 240) {
                tmp = tmp + "row " + i + ". ";
            }
            pStmtA.setString(2, tmp);
            count += pStmtA.executeUpdate();
            pStmtB.setInt(1, i);
            pStmtB.executeUpdate();
            ++i;
        }
        Assert.assertTrue((count == 1000 ? 1 : 0) != 0);
        Statement stmtA = cx.createStatement();
        Statement stmtB = cx.createStatement();
        count = 0;
        ResultSet rsA = stmtA.executeQuery("select * from #t0022a");
        Assert.assertNotNull((Object)rsA);
        while (rsA.next()) {
            ++count;
            ResultSet rsB = stmtB.executeQuery("select * from #t0022b where i=" + rsA.getInt("i"));
            Assert.assertNotNull((Object)rsB);
            Assert.assertTrue((String)"Expected a result set", (boolean)rsB.next());
            Assert.assertTrue((String)"Expected no result set", (!rsB.next() ? 1 : 0) != 0);
        }
        Assert.assertTrue((count == 1000 ? 1 : 0) != 0);
        stmtA.close();
        stmtB.close();
    }

    public void testPrimaryKeyFloat0023() throws Exception {
        Double[] d = new Double[]{new Double(-1.0), new Double(1234.543), new Double(0.0), new Double(1.0), new Double(-2.0), new Double(0.14), new Double(0.79), new Double(1000000.12345), new Double(-1000000.12345), new Double(1000000.0), new Double(-1000000.0), new Double(1.7E308), new Double(1.7E-307)};
        Connection cx = this.getConnection();
        this.dropTable("#t0023");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0023   (pk   float not null,    type char(30) not null,    b    bit,    str  char(30) not null,    t int identity(1,1),    primary key (pk, type))    ");
        PreparedStatement pStmt = cx.prepareStatement("insert into #t0023 (pk, type, b, str) values(?, 'prepared', 0, ?)");
        int i = 0;
        while (i < d.length) {
            pStmt.setDouble(1, d[i]);
            pStmt.setString(2, d[i].toString());
            int preparedCount = pStmt.executeUpdate();
            Assert.assertTrue((preparedCount == 1 ? 1 : 0) != 0);
            int adhocCount = stmt.executeUpdate("insert into #t0023         (pk, type, b, str)       values(   " + d[i] + ",         " + "       'adhoc',          " + "       1,                " + "   '" + d[i] + "')       ");
            Assert.assertTrue((adhocCount == 1 ? 1 : 0) != 0);
            ++i;
        }
        int count = 0;
        ResultSet rs = stmt.executeQuery("select * from #t0023 where type='prepared' order by t");
        Assert.assertNotNull((Object)rs);
        while (rs.next()) {
            Assert.assertEquals((Object)d[count].toString(), (Object)("" + rs.getDouble("pk")));
            ++count;
        }
        Assert.assertTrue((count == d.length ? 1 : 0) != 0);
        count = 0;
        rs = stmt.executeQuery("select * from #t0023 where type='adhoc' order by t");
        while (rs.next()) {
            Assert.assertEquals((Object)d[count].toString(), (Object)("" + rs.getDouble("pk")));
            ++count;
        }
        Assert.assertTrue((count == d.length ? 1 : 0) != 0);
    }

    public void testPrimaryKeyReal0024() throws Exception {
        String s2;
        String s1;
        Float[] d = new Float[]{new Float(-1.0), new Float(1234.543), new Float(0.0), new Float(1.0f), new Float(-2.0), new Float(0.14), new Float(0.79), new Float(1000000.12345), new Float(-1000000.12345), new Float(1000000.0f), new Float(-1000000.0f), new Float(3.4E38), new Float(3.4E-38)};
        Connection cx = this.getConnection();
        this.dropTable("#t0024");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0024                    (pk   real not null,                type char(30) not null,             b    bit,                           str  char(30) not null,             t int identity(1,1),     primary key (pk, type))    ");
        PreparedStatement pStmt = cx.prepareStatement("insert into #t0024 (pk, type, b, str) values(?, 'prepared', 0, ?)");
        int i = 0;
        while (i < d.length) {
            pStmt.setFloat(1, d[i].floatValue());
            pStmt.setString(2, d[i].toString());
            int preparedCount = pStmt.executeUpdate();
            Assert.assertTrue((preparedCount == 1 ? 1 : 0) != 0);
            int adhocCount = stmt.executeUpdate("insert into #t0024         (pk, type, b, str)       values(   " + d[i] + ",         " + "       'adhoc',          " + "       1,                " + "   '" + d[i] + "')       ");
            Assert.assertTrue((adhocCount == 1 ? 1 : 0) != 0);
            ++i;
        }
        int count = 0;
        ResultSet rs = stmt.executeQuery("select * from #t0024 where type='prepared' order by t");
        Assert.assertNotNull((Object)rs);
        while (rs.next()) {
            s1 = d[count].toString().trim();
            s2 = ("" + rs.getFloat("pk")).trim();
            Assert.assertTrue((boolean)s1.equalsIgnoreCase(s2));
            ++count;
        }
        Assert.assertTrue((count == d.length ? 1 : 0) != 0);
        count = 0;
        rs = stmt.executeQuery("select * from #t0024 where type='adhoc' order by t");
        while (rs.next()) {
            s1 = d[count].toString().trim();
            s2 = ("" + rs.getFloat("pk")).trim();
            Assert.assertTrue((boolean)s1.equalsIgnoreCase(s2));
            ++count;
        }
        Assert.assertTrue((count == d.length ? 1 : 0) != 0);
    }

    public void testGetBoolean0025() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0025");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0025   (i      integer,    b      bit,        s      char(5),    f      float)   ");
        Assert.assertTrue((stmt.executeUpdate("insert into #t0025 values(0, 0, 'false', 0.0)") == 1 ? 1 : 0) != 0);
        Assert.assertTrue((stmt.executeUpdate("insert into #t0025 values(0, 0, '0', 0.0)") == 1 ? 1 : 0) != 0);
        Assert.assertTrue((stmt.executeUpdate("insert into #t0025 values(1, 1, 'true', 7.0)") == 1 ? 1 : 0) != 0);
        Assert.assertTrue((stmt.executeUpdate("insert into #t0025 values(2, 1, '1', -5.0)") == 1 ? 1 : 0) != 0);
        ResultSet rs = stmt.executeQuery("select * from #t0025 order by i");
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertTrue((!rs.getBoolean("i") ? 1 : 0) != 0);
        Assert.assertTrue((!rs.getBoolean("b") ? 1 : 0) != 0);
        Assert.assertTrue((!rs.getBoolean("s") ? 1 : 0) != 0);
        Assert.assertTrue((!rs.getBoolean("f") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertTrue((!rs.getBoolean("i") ? 1 : 0) != 0);
        Assert.assertTrue((!rs.getBoolean("b") ? 1 : 0) != 0);
        Assert.assertTrue((!rs.getBoolean("s") ? 1 : 0) != 0);
        Assert.assertTrue((!rs.getBoolean("f") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertTrue((boolean)rs.getBoolean("i"));
        Assert.assertTrue((boolean)rs.getBoolean("b"));
        Assert.assertTrue((boolean)rs.getBoolean("s"));
        Assert.assertTrue((boolean)rs.getBoolean("f"));
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertTrue((boolean)rs.getBoolean("i"));
        Assert.assertTrue((boolean)rs.getBoolean("b"));
        Assert.assertTrue((boolean)rs.getBoolean("s"));
        Assert.assertTrue((boolean)rs.getBoolean("f"));
        Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
    }

    public void testNestedStatements0026() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0026a");
        this.dropTable("#t0026b");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0026a   (i   integer not null,    str char(254) not null) ");
        stmt.executeUpdate("create table #t0026b               (i   integer not null,         t   datetime not null)     ");
        stmt.close();
        PreparedStatement pStmtA = cx.prepareStatement("insert into #t0026a values (?, ?)");
        PreparedStatement pStmtB = cx.prepareStatement("insert into #t0026b values (?, getdate())");
        int rowsToAdd = 1000;
        int count = 0;
        int i = 1;
        while (i <= 1000) {
            pStmtA.setInt(1, i);
            String tmp = "";
            while (tmp.length() < 240) {
                tmp = tmp + "row " + i + ". ";
            }
            pStmtA.setString(2, tmp);
            count += pStmtA.executeUpdate();
            pStmtB.setInt(1, i);
            pStmtB.executeUpdate();
            ++i;
        }
        Assert.assertTrue((count == 1000 ? 1 : 0) != 0);
        pStmtA.close();
        pStmtB.close();
        Statement stmtA = cx.createStatement(1004, 1007);
        Statement stmtB = cx.createStatement(1004, 1007);
        count = 0;
        ResultSet rsA = stmtA.executeQuery("select * from #t0026a");
        Assert.assertNotNull((Object)rsA);
        while (rsA.next()) {
            ++count;
            ResultSet rsB = stmtB.executeQuery("select * from #t0026b where i=" + rsA.getInt("i"));
            Assert.assertNotNull((Object)rsB);
            Assert.assertTrue((String)"Expected a result set", (boolean)rsB.next());
            Assert.assertTrue((String)"Expected no result set", (!rsB.next() ? 1 : 0) != 0);
        }
        Assert.assertTrue((count == 1000 ? 1 : 0) != 0);
        stmtA.close();
        stmtB.close();
    }

    public void testErrors0036() throws Exception {
        Connection cx = this.getConnection();
        Statement stmt = cx.createStatement();
        int numberToTest = 5;
        int i = 0;
        while (i < 5) {
            String table = "#t0036_do_not_create_" + i;
            try {
                stmt.executeUpdate("drop table " + table);
                Assert.assertTrue((String)"Did not expect to reach here", (boolean)false);
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot drop the table '" + table + "', because it does"));
            }
            ++i;
        }
    }

    public void testTimestamps0037() throws Exception {
        Connection cx = this.getConnection();
        Statement stmt = cx.createStatement();
        ResultSet rs = stmt.executeQuery("select                                      convert(smalldatetime, '1999-01-02') a,   convert(smalldatetime, null)         b,   convert(datetime, '1999-01-02')      c,   convert(datetime, null)              d  ");
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertTrue((rs.getDate("a") != null ? 1 : 0) != 0);
        Assert.assertTrue((rs.getDate("b") == null ? 1 : 0) != 0);
        Assert.assertTrue((rs.getDate("c") != null ? 1 : 0) != 0);
        Assert.assertTrue((rs.getDate("d") == null ? 1 : 0) != 0);
        Assert.assertTrue((rs.getTime("a") != null ? 1 : 0) != 0);
        Assert.assertTrue((rs.getTime("b") == null ? 1 : 0) != 0);
        Assert.assertTrue((rs.getTime("c") != null ? 1 : 0) != 0);
        Assert.assertTrue((rs.getTime("d") == null ? 1 : 0) != 0);
        Assert.assertTrue((rs.getTimestamp("a") != null ? 1 : 0) != 0);
        Assert.assertTrue((rs.getTimestamp("b") == null ? 1 : 0) != 0);
        Assert.assertTrue((rs.getTimestamp("c") != null ? 1 : 0) != 0);
        Assert.assertTrue((rs.getTimestamp("d") == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
    }

    public void testConnection0038() throws Exception {
        Connection conn = this.getConnection();
        this.dropTable("#t0038");
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("create table #t0038 ( keyField char(255)     not null,  descField varchar(255)  not null) ");
        int count = stmt.executeUpdate("insert into #t0038 values ('value', 'test')");
        Assert.assertTrue((count == 1 ? 1 : 0) != 0);
        conn.setTransactionIsolation(1);
        conn.setAutoCommit(false);
        PreparedStatement ps = conn.prepareStatement("update #t0038 set descField=descField where keyField=?");
        ps.setString(1, "value");
        ps.executeUpdate();
        ps.close();
        conn.commit();
        Statement statement = conn.createStatement();
        ResultSet resultSet = statement.executeQuery("select descField from #t0038 where keyField='value'");
        Assert.assertTrue((boolean)resultSet.next());
        statement.close();
        conn.close();
    }

    public void testConnection0039() throws Exception {
        int i = 0;
        while (i < 10) {
            Connection conn = this.getConnection();
            Statement statement = conn.createStatement();
            ResultSet resultSet = statement.executeQuery("select 5");
            Assert.assertNotNull((Object)resultSet);
            resultSet.close();
            statement.close();
            conn.close();
            ++i;
        }
    }

    public void testPreparedStatement0040() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0040");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0040 ( c255 char(255)     not null,  v255 varchar(255)  not null) ");
        PreparedStatement pStmt = cx.prepareStatement("insert into #t0040 values (?, ?)");
        String along = this.getLongString('a');
        String blong = this.getLongString('b');
        pStmt.setString(1, along);
        pStmt.setString(2, along);
        int count = pStmt.executeUpdate();
        Assert.assertTrue((count == 1 ? 1 : 0) != 0);
        pStmt.close();
        count = stmt.executeUpdate("insert into #t0040 values ( '" + blong + "', " + "'" + blong + "')");
        Assert.assertTrue((count == 1 ? 1 : 0) != 0);
        pStmt = cx.prepareStatement("select c255, v255 from #t0040 order by c255");
        ResultSet rs = pStmt.executeQuery();
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("c255"), (Object)along);
        Assert.assertEquals((Object)rs.getString("v255"), (Object)along);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("c255"), (Object)blong);
        Assert.assertEquals((Object)rs.getString("v255"), (Object)blong);
        Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
        pStmt.close();
        rs = stmt.executeQuery("select c255, v255 from #t0040 order by c255");
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("c255"), (Object)along);
        Assert.assertEquals((Object)rs.getString("v255"), (Object)along);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("c255"), (Object)blong);
        Assert.assertEquals((Object)rs.getString("v255"), (Object)blong);
        Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
        stmt.close();
        cx.close();
    }

    public void testPreparedStatement0041() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0041");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0041   (i  integer  not null,    s  text     not null) ");
        PreparedStatement pStmt = cx.prepareStatement("insert into #t0041 values (?, ?)");
        int rowsToAdd = 400;
        String theString = this.getLongString(400);
        int count = 0;
        int i = 1;
        while (i <= 400) {
            pStmt.setInt(1, i);
            pStmt.setString(2, theString.substring(0, i));
            count += pStmt.executeUpdate();
            ++i;
        }
        Assert.assertTrue((count == 400 ? 1 : 0) != 0);
        pStmt.close();
        ResultSet rs = stmt.executeQuery("select s, i from #t0041");
        Assert.assertNotNull((Object)rs);
        count = 0;
        while (rs.next()) {
            rs.getString("s");
            ++count;
        }
        Assert.assertTrue((count == 400 ? 1 : 0) != 0);
        cx.close();
    }

    public void testPreparedStatement0042() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0042");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0042 (s char(5) null, i integer null, j integer not null)");
        PreparedStatement pStmt = cx.prepareStatement("insert into #t0042 (s, i, j) values (?, ?, ?)");
        pStmt.setString(1, "hello");
        pStmt.setNull(2, 4);
        pStmt.setInt(3, 1);
        int count = pStmt.executeUpdate();
        Assert.assertTrue((count == 1 ? 1 : 0) != 0);
        pStmt.setInt(2, 42);
        pStmt.setInt(3, 2);
        count = pStmt.executeUpdate();
        Assert.assertTrue((count == 1 ? 1 : 0) != 0);
        pStmt.close();
        pStmt = cx.prepareStatement("select i from #t0042 order by j");
        ResultSet rs = pStmt.executeQuery();
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        rs.getInt(1);
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertTrue((rs.getInt(1) == 42 ? 1 : 0) != 0);
        Assert.assertTrue((!rs.wasNull() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
        cx.close();
    }

    public void testResultSet0043() throws Exception {
        Connection cx = this.getConnection();
        Statement stmt = cx.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("select 1");
            Assert.assertNotNull((Object)rs);
            rs.getInt(1);
            Assert.assertTrue((String)"Did not expect to reach here", (boolean)false);
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("No current row in the ResultSet"));
        }
    }

    public void testResultSet0044() throws Exception {
        Connection cx = this.getConnection();
        Statement stmt = cx.createStatement();
        ResultSet rs = stmt.executeQuery("select 1");
        Assert.assertNotNull((Object)rs);
        rs.close();
        try {
            Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid state"));
        }
    }

    public void testResultSet0045() throws Exception {
        try {
            Connection cx = this.getConnection();
            Statement stmt = cx.createStatement();
            ResultSet rs = stmt.executeQuery("select 1");
            Assert.assertNotNull((Object)rs);
            Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
            rs.getInt(1);
            Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
            rs.getInt(1);
            Assert.assertTrue((String)"Did not expect to reach here", (boolean)false);
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("No more results in ResultSet"));
        }
    }

    public void testMetaData0046() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0046");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0046 (   i integer identity,    a integer not null,    b integer null ) ");
        int count = stmt.executeUpdate("insert into #t0046 (a, b) values (-2, -3)");
        Assert.assertTrue((count == 1 ? 1 : 0) != 0);
        ResultSet rs = stmt.executeQuery("select i, a, b, 17 c from #t0046");
        Assert.assertNotNull((Object)rs);
        ResultSetMetaData md = rs.getMetaData();
        Assert.assertNotNull((Object)md);
        Assert.assertTrue((boolean)md.isAutoIncrement(1));
        Assert.assertTrue((!md.isAutoIncrement(2) ? 1 : 0) != 0);
        Assert.assertTrue((!md.isAutoIncrement(3) ? 1 : 0) != 0);
        Assert.assertTrue((!md.isAutoIncrement(4) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)md.isReadOnly(1));
        Assert.assertTrue((!md.isReadOnly(2) ? 1 : 0) != 0);
        Assert.assertTrue((!md.isReadOnly(3) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)md.isReadOnly(4));
        Assert.assertEquals((int)md.isNullable(1), (int)0);
        Assert.assertEquals((int)md.isNullable(2), (int)0);
        Assert.assertEquals((int)md.isNullable(3), (int)1);
        rs.close();
    }

    public void testTimestamps0047() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0047");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0047 (                                 t1   datetime not null,         t2   datetime null,             t3   smalldatetime not null,    t4   smalldatetime null       )");
        String query = "insert into #t0047 (t1, t2, t3, t4)  values('2000-01-02 19:35:01.333',         '2000-01-02 19:35:01.333',         '2000-01-02 19:35:01.333',         '2000-01-02 19:35:01.333'  )";
        int count = stmt.executeUpdate(query);
        Assert.assertTrue((count == 1 ? 1 : 0) != 0);
        ResultSet rs = stmt.executeQuery("select t1, t2, t3, t4 from #t0047");
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Timestamp t1 = rs.getTimestamp("t1");
        Timestamp t2 = rs.getTimestamp("t2");
        Timestamp t3 = rs.getTimestamp("t3");
        Timestamp t4 = rs.getTimestamp("t4");
        Timestamp r1 = Timestamp.valueOf("2000-01-02 19:35:01.333");
        Timestamp r2 = Timestamp.valueOf("2000-01-02 19:35:00");
        Assert.assertEquals((Object)r1, (Object)t1);
        Assert.assertEquals((Object)r1, (Object)t2);
        Assert.assertEquals((Object)r2, (Object)t3);
        Assert.assertEquals((Object)r2, (Object)t4);
    }

    public void testTimestamps0048() throws Exception {
        Connection cx = this.getConnection();
        this.dropTable("#t0048");
        Statement stmt = cx.createStatement();
        stmt.executeUpdate("create table #t0048              (                                 t1   datetime not null,         t2   datetime null,             t3   smalldatetime not null,    t4   smalldatetime null       )");
        Timestamp r1 = Timestamp.valueOf("2000-01-02 19:35:01");
        Timestamp r2 = Timestamp.valueOf("2000-01-02 19:35:00");
        PreparedStatement pstmt = cx.prepareStatement("insert into #t0048 (t1, t2, t3, t4) values(?, ?, ?, ?)");
        pstmt.setTimestamp(1, r1);
        pstmt.setTimestamp(2, r1);
        pstmt.setTimestamp(3, r1);
        pstmt.setTimestamp(4, r1);
        int count = pstmt.executeUpdate();
        Assert.assertTrue((count == 1 ? 1 : 0) != 0);
        pstmt.close();
        ResultSet rs = stmt.executeQuery("select t1, t2, t3, t4 from #t0048");
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Timestamp t1 = rs.getTimestamp("t1");
        Timestamp t2 = rs.getTimestamp("t2");
        Timestamp t3 = rs.getTimestamp("t3");
        Timestamp t4 = rs.getTimestamp("t4");
        Assert.assertEquals((Object)r1, (Object)t1);
        Assert.assertEquals((Object)r1, (Object)t2);
        Assert.assertEquals((Object)r2, (Object)t3);
        Assert.assertEquals((Object)r2, (Object)t4);
    }

    public void testDecimalConversion0058() throws Exception {
        Connection cx = this.getConnection();
        Statement stmt = cx.createStatement();
        ResultSet rs = stmt.executeQuery("select convert(DECIMAL(4,0), 0)");
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertTrue((rs.getInt(1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
        rs = stmt.executeQuery("select convert(DECIMAL(4,0), 1)");
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertTrue((rs.getInt(1) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
        rs = stmt.executeQuery("select convert(DECIMAL(4,0), -1)");
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Expected a result set", (boolean)rs.next());
        Assert.assertTrue((rs.getInt(1) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected no result set", (!rs.next() ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

