/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.SBChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JInternalFrame;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class TinyInternalFrameBorder
extends AbstractBorder
implements UIResource {
    private JInternalFrame frame;
    private boolean isPalette;
    private int titleHeight;
    private boolean isActive;

    public TinyInternalFrameBorder(JInternalFrame frame) {
        this.frame = frame;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (Theme.frameIsTransparent[Theme.style]) {
            this.frame.setOpaque(false);
        }
        this.isActive = this.frame.isSelected();
        this.isPalette = this.frame.getClientProperty("isPalette") == Boolean.TRUE;
        this.titleHeight = this.isPalette ? Theme.framePaletteTitleHeight[Theme.derivedStyle[Theme.style]] : Theme.frameInternalTitleHeight[Theme.derivedStyle[Theme.style]];
        if (this.isActive) {
            g.setColor(Theme.frameBorderColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.frameBorderDisabledColor[Theme.style].getColor());
        }
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyBorder(g, x, y, w, h);
                break;
            }
            case 1: {
                this.drawWinBorder(g, x, y, w, h);
                break;
            }
            case 2: {
                this.drawXpBorder(g, x, y, w, h);
            }
        }
        Color col = null;
        col = this.isActive ? Theme.frameCaptionColor[Theme.style].getColor() : Theme.frameCaptionDisabledColor[Theme.style].getColor();
        g.setColor(col);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyCaption(g, x, y, w, h, col);
                break;
            }
            case 1: {
                this.drawWinCaption(g, x, y, w, h, col);
                break;
            }
            case 2: {
                this.drawXpCaption(g, x, y, w, h, col);
            }
        }
    }

    private void drawTinyBorder(Graphics g, int x, int y, int w, int h) {
    }

    private void drawWinBorder(Graphics g, int x, int y, int w, int h) {
        g.drawLine(x, y, x + w - 2, y);
        g.drawLine(x, y + 1, x, y + h - 2);
        g.drawRect(x + 2, y + 2, w - 5, h - 5);
        g.drawRect(x + 3, y + 3, w - 7, h - 7);
        g.setColor(Color.WHITE);
        g.drawLine(x + 1, y + 1, x + w - 3, y + 1);
        g.drawLine(x + 1, y + 2, x + 1, y + h - 3);
        g.setColor(Theme.frameDarkColor[Theme.style].getColor());
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        g.setColor(Theme.frameLightColor[Theme.style].getColor());
        g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        g.drawLine(w - 2, y + 1, x + w - 2, y + h - 2);
    }

    private void drawXpBorder(Graphics g, int x, int y, int w, int h) {
        g.drawLine(x, y + 6, x, y + h - 1);
        g.drawLine(x + 2, y + this.titleHeight, x + 2, y + h - 3);
        g.drawLine(x + w - 1, y + 6, x + w - 1, y + h - 1);
        g.drawLine(x + w - 3, y + this.titleHeight, x + w - 3, y + h - 3);
        g.drawLine(x + 2, y + h - 3, x + w - 3, y + h - 3);
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        if (this.isActive) {
            g.setColor(Theme.frameCaptionColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.frameCaptionDisabledColor[Theme.style].getColor());
        }
        g.drawLine(x + 1, y + this.titleHeight, x + 1, y + h - 2);
        g.drawLine(x + w - 2, y + this.titleHeight, x + w - 2, y + h - 2);
        g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        Color c = null;
        c = this.isActive ? Theme.frameBorderColor[Theme.style].getColor() : Theme.frameBorderDisabledColor[Theme.style].getColor();
        g.setColor(ColorRoutines.getAlphaColor(c, 82));
        g.drawLine(x, y + 3, x, y + 3);
        g.drawLine(x + w - 1, y + 3, x + w - 1, y + 3);
        g.setColor(ColorRoutines.getAlphaColor(c, 156));
        g.drawLine(x, y + 4, x, y + 4);
        g.drawLine(x + w - 1, y + 4, x + w - 1, y + 4);
        g.setColor(ColorRoutines.getAlphaColor(c, 215));
        g.drawLine(x, y + 5, x, y + 5);
        g.drawLine(x + w - 1, y + 5, x + w - 1, y + 5);
    }

    private void drawTinyCaption(Graphics g, int x, int y, int w, int h, Color c) {
    }

    private void drawWinCaption(Graphics g, int x, int y, int w, int h, Color c) {
        int y2 = y + this.titleHeight - 2;
        int tw = w - 8;
        int maxSat = 56;
        int maxBri = 78;
        if (!this.isActive) {
            maxSat = 0;
            maxBri = 50;
        }
        int sat = 0;
        int bri = 0;
        int memSat = 0;
        int memBri = 0;
        Color col = c;
        int i = 0;
        while (i < tw) {
            g.setColor(col);
            g.drawLine(x + 4 + i, y + 4, x + 4 + i, y2);
            sat = maxSat * i / tw;
            bri = maxBri * i / tw;
            if (sat != memSat || bri != memBri) {
                memSat = sat;
                memBri = bri;
                col = SBChooser.getAdjustedColor(c, sat, bri);
            }
            ++i;
        }
        g.setColor(Theme.frameBorderColor[Theme.style].getColor());
        g.drawLine(x + 4, y + this.titleHeight - 1, x + w - 5, y + this.titleHeight - 1);
    }

    private void drawXpCaption(Graphics g, int x, int y, int w, int h, Color c) {
        if (this.isPalette) {
            this.drawXpPaletteCaption(g, x, y, w, h, c);
            return;
        }
        int y2 = y;
        int spread1 = Theme.frameSpreadDarkDisabled[Theme.style];
        int spread2 = Theme.frameSpreadLightDisabled[Theme.style];
        Color borderColor = null;
        if (this.isActive) {
            borderColor = Theme.frameBorderColor[Theme.style].getColor();
            spread1 = Theme.frameSpreadDark[Theme.style];
            spread2 = Theme.frameSpreadLight[Theme.style];
        } else {
            borderColor = Theme.frameBorderDisabledColor[Theme.style].getColor();
        }
        g.setColor(borderColor);
        g.drawLine(x + 6, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 82));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 156));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 215));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        Color c2 = ColorRoutines.darken(c, 4 * spread1);
        g.setColor(c2);
        g.drawLine(x + 3, ++y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 23));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 4, ++y2, x + w - 5, y2);
        g.setColor(c);
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        c2 = ColorRoutines.darken(c, 6 * spread1);
        g.setColor(c2);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(c);
        g.drawLine(x + 7, ++y2, x + w - 8, y2);
        g.setColor(c);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.lighten(c, 7 * spread2));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.lighten(c, 3 * spread2));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        g.setColor(c);
        g.drawLine(x + 6, y2, x + 6, y2);
        g.drawLine(x + w - 7, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 5, ++y2, x + w - 6, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(c);
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 2, ++y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.fillRect(x + 1, ++y2, w - 2, 1);
        g.setColor(ColorRoutines.darken(c, 3 * spread1));
        g.fillRect(x + 1, ++y2, w - 2, 3);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.fillRect(x + 1, y2 += 3, w - 2, 2);
        g.setColor(ColorRoutines.darken(c, 1 * spread1));
        g.fillRect(x + 1, y2 += 2, w - 2, 1);
        g.setColor(c);
        g.fillRect(x + 1, ++y2, w - 2, 2);
        g.setColor(ColorRoutines.lighten(c, 2 * spread2));
        g.drawLine(x + 1, y2 += 2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 6 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 8 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 9 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        ++y2;
        if (this.isActive) {
            g.setColor(Theme.frameLightColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.frameLightDisabledColor[Theme.style].getColor());
        }
        g.drawLine(x + 1, y2, x + w - 2, y2);
    }

    private void drawXpPaletteCaption(Graphics g, int x, int y, int w, int h, Color c) {
        int y2 = y;
        int spread1 = Theme.frameSpreadDarkDisabled[Theme.style];
        int spread2 = Theme.frameSpreadLightDisabled[Theme.style];
        Color borderColor = null;
        if (this.isActive) {
            borderColor = Theme.frameBorderColor[Theme.style].getColor();
            spread1 = Theme.frameSpreadDark[Theme.style];
            spread2 = Theme.frameSpreadLight[Theme.style];
        } else {
            borderColor = Theme.frameBorderDisabledColor[Theme.style].getColor();
        }
        g.setColor(borderColor);
        g.drawLine(x + 6, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 82));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 156));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 215));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        Color c2 = ColorRoutines.darken(c, 4 * spread1);
        g.setColor(c2);
        g.drawLine(x + 3, ++y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 23));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 4, ++y2, x + w - 5, y2);
        g.setColor(c);
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        c2 = ColorRoutines.darken(c, 6 * spread1);
        g.setColor(c2);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(c);
        g.drawLine(x + 7, ++y2, x + w - 8, y2);
        g.setColor(c);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.lighten(c, 7 * spread2));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.lighten(c, 3 * spread2));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        g.setColor(c);
        g.drawLine(x + 6, y2, x + 6, y2);
        g.drawLine(x + w - 7, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 5, ++y2, x + w - 6, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(c);
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 2, ++y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.fillRect(x + 1, ++y2, w - 2, 1);
        g.setColor(ColorRoutines.darken(c, 3 * spread1));
        g.fillRect(x + 1, ++y2, w - 2, 1);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.fillRect(x + 1, ++y2, w - 2, 1);
        g.setColor(ColorRoutines.darken(c, 1 * spread1));
        g.fillRect(x + 1, ++y2, w - 2, 1);
        g.setColor(c);
        g.fillRect(x + 1, ++y2, w - 2, 1);
        g.setColor(ColorRoutines.lighten(c, 2 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 6 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 8 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 9 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        ++y2;
        if (this.isActive) {
            g.setColor(Theme.frameLightColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.frameLightDisabledColor[Theme.style].getColor());
        }
        g.drawLine(x + 1, y2, x + w - 2, y2);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(0, Theme.frameBorderWidth[Theme.derivedStyle[Theme.style]], Theme.frameBorderWidth[Theme.derivedStyle[Theme.style]], Theme.frameBorderWidth[Theme.derivedStyle[Theme.style]]);
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }
}

