/*
 * Resource.java
 *
 * Created on February 12, 2004, 2:15 PM
 */

package dori.jasper.util;

/**
 * Class used to keep track of any resource type information for classes in this
 * package.  This allows a central place for settings and things of this nature.
 * Persistent files are to be kept in the user home directory under .jasperutils
 * @author  Wade Chandler
 * @version 1.0
 */
public class Resource
{
   
   /** this is the main directory applications in this directory will use. */
   public static final String RESOURCE_DIRECTORY;
   
   /** this is the main directory base name or the name without parent directories. user.home+/.jasperutils/*/
   public static final String RESOURCE_DIRECTORY_BASE_NAME = ".jasperutils";
   
   /** this is the DatabaseConnectionManager storage file. user.home+/.jasperutils/DCM.xml*/
   public static final String DCM_CONFIG_FILE;
   
   /** this is the users file for DatabaseDriverNameAndURLExamples  user.home+/.jasperutils/DatabaseDriverNameAndURLExamples.properties*/
   public static final String DATABASE_DRIVER_NAME_AND_URL_EXAMPLES_USER_FILE;
   
   /** this is used to hold the file name of the application settings. user.home+/.jasperutils/ReportUtilities.xml*/
   public static final String REPORT_UTILS_APP_SETTINGS;
   
   /** this is used for the output file of the ReportUtilities class */
   public static final String REPORT_UTILS_APP_LOG_FILE;
   
   static
   {
      //here we'll setup the static variables for the class that need extra work.
      
      String userHome = System.getProperty("user.home");
      String fileSep = System.getProperty("file.separator");
      if(!userHome.endsWith( fileSep ) )
      {
         userHome += fileSep;
      }
      RESOURCE_DIRECTORY = new String( userHome + RESOURCE_DIRECTORY_BASE_NAME );
      DCM_CONFIG_FILE = new String( RESOURCE_DIRECTORY + fileSep + "DCM.dat" );
      DATABASE_DRIVER_NAME_AND_URL_EXAMPLES_USER_FILE = new String( RESOURCE_DIRECTORY + fileSep + "DatabaseDriverNameAndURLExamples.properties");
      REPORT_UTILS_APP_SETTINGS = new String( RESOURCE_DIRECTORY + fileSep + "ReportUtilities.dat");
      REPORT_UTILS_APP_LOG_FILE = new String( RESOURCE_DIRECTORY + fileSep + "ReportUtilitiesConsoleOutput.dat");
   }//end static init
   
   /** Creates a new instance of Resource */
   public Resource()
   {
      super();
   }
   
   /**
    *Method used to store a serialized object in an xml file.
    *@param o the object to write to file.
    *@param fileName the file to serialize to
    *@throws java.io.IOException if something happens during IO
    */
   public static void saveObjectToFile(Object o, String fileName)
   throws java.io.IOException
   {
      java.io.FileOutputStream fout = null;
      try
      {
         fout = new java.io.FileOutputStream(fileName, false);
         java.io.BufferedOutputStream bout = new java.io.BufferedOutputStream(fout);
         java.io.ObjectOutputStream oo = new java.io.ObjectOutputStream(bout);
         oo.writeObject(o);
         oo.flush();
         oo.close();
      }
      catch(RuntimeException e)
      {
         throw e;
      }
      finally
      {
         if(fout != null)
         {
            try
            {
               fout.close();
            }
            catch(Throwable e)
            {
               
            }
         }
      }
   }//end saveObjectToFile
   
   /**
    *Method used to read a serialized object from an xml file.
    *@param fileName the file to deserialize
    *@return the object deserialized
    *@throws java.io.IOException if something happens during IO
    */
   public static Object loadObjectFromFile(String fileName)
   throws java.io.IOException, java.lang.ClassNotFoundException
   {
      Object ret = null;
      java.io.FileInputStream fin = null;
      try
      {
         fin = new java.io.FileInputStream(fileName);
         java.io.BufferedInputStream bin = new java.io.BufferedInputStream(fin);
         java.io.ObjectInputStream oin = new java.io.ObjectInputStream(bin);
         ret = oin.readObject();
         oin.close();
      }
      catch(RuntimeException e)
      {
         throw e;
      }
      finally
      {
         if( fin != null )
         {
            try
            {
               fin.close();
            }
            catch(Throwable e)
            {

            }
         }
      }
      return ret;
   }
   
}//end class Resource
