/*
 * ActiveDatabaseConnectionDialog.java
 *
 * Created on February 16, 2004, 2:45 AM
 */

package dori.jasper.util.gui;

import dori.jasper.util.*;

/**
 * Class used to allow the selection of the active database connection.
 * @author  Wade chandler
 * @version 1.0
 */
public class ActiveDatabaseConnectionDialog extends javax.swing.JDialog
implements java.io.Serializable
{
   
   /** used for the user clicking OK */
   public static final int OK_OPTION = 1;
   
   /** used for the user clicking CANCEL */
   public static final int CANCEL_OPTION = 2;
   
   /** used to house the users button choice */
   protected int userChoice = CANCEL_OPTION;
   
   /** used to set and get the active connection */
   protected DatabaseConnectionInfoManager dbInfo = null;
   
   /** Creates new form ActiveDatabaseConnectionDialog */
   public ActiveDatabaseConnectionDialog(java.awt.Frame parent, boolean modal)
   {
      super(parent, modal);
      initComponents();
   }
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   private void initComponents()//GEN-BEGIN:initComponents
   {
      buttonsPanel = new javax.swing.JPanel();
      okButton = new javax.swing.JButton();
      cancelButton = new javax.swing.JButton();
      connectionsPanel = new javax.swing.JPanel();
      connectionsScrollPane = new javax.swing.JScrollPane();
      connectionsTable = new javax.swing.JTable();
      
      FormListener formListener = new FormListener();
      
      setTitle("Select Active Connection");
      addWindowListener(formListener);
      
      buttonsPanel.setPreferredSize(new java.awt.Dimension(10, 40));
      okButton.setText("OK");
      okButton.setPreferredSize(new java.awt.Dimension(67, 25));
      okButton.addActionListener(formListener);
      
      buttonsPanel.add(okButton);
      
      cancelButton.setText("Cancel");
      cancelButton.addActionListener(formListener);
      
      buttonsPanel.add(cancelButton);
      
      getContentPane().add(buttonsPanel, java.awt.BorderLayout.SOUTH);
      
      connectionsPanel.setLayout(new java.awt.CardLayout());
      
      connectionsScrollPane.setDoubleBuffered(true);
      connectionsTable.setModel(new javax.swing.table.DefaultTableModel(
      new Object [][]
      {
         
      },
      new String []
      {
         "Connection Name", "JDBC Driver"
      }
      )
      {
         Class[] types = new Class []
         {
            java.lang.String.class, java.lang.String.class
         };
         boolean[] canEdit = new boolean []
         {
            false, false
         };
         
         public Class getColumnClass(int columnIndex)
         {
            return types [columnIndex];
         }
         
         public boolean isCellEditable(int rowIndex, int columnIndex)
         {
            return canEdit [columnIndex];
         }
      });
      connectionsTable.setDoubleBuffered(true);
      connectionsScrollPane.setViewportView(connectionsTable);
      
      connectionsPanel.add(connectionsScrollPane, "card2");
      
      getContentPane().add(connectionsPanel, java.awt.BorderLayout.CENTER);
      
      pack();
   }
   
   // Code for dispatching events from components to event handlers.
   
   private class FormListener implements java.awt.event.ActionListener, java.awt.event.WindowListener
   {
      public void actionPerformed(java.awt.event.ActionEvent evt)
      {
         if (evt.getSource() == okButton)
         {
            ActiveDatabaseConnectionDialog.this.okButtonActionPerformed(evt);
         }
         else if (evt.getSource() == cancelButton)
         {
            ActiveDatabaseConnectionDialog.this.cancelButtonActionPerformed(evt);
         }
      }
      
      public void windowActivated(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowClosed(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowClosing(java.awt.event.WindowEvent evt)
      {
         if (evt.getSource() == ActiveDatabaseConnectionDialog.this)
         {
            ActiveDatabaseConnectionDialog.this.closeDialog(evt);
         }
      }
      
      public void windowDeactivated(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowDeiconified(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowIconified(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowOpened(java.awt.event.WindowEvent evt)
      {
      }
   }//GEN-END:initComponents
   
   private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_cancelButtonActionPerformed
   {//GEN-HEADEREND:event_cancelButtonActionPerformed
      this.closeDialog();
   }//GEN-LAST:event_cancelButtonActionPerformed
   
   private void okButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_okButtonActionPerformed
   {//GEN-HEADEREND:event_okButtonActionPerformed
      //ok this is the only time we really care about doing anything besides setting
      //the other value to CANCEL_OPTION instead of OK_OPTION
      int selectedIndex = this.connectionsTable.getSelectedRow();
      if( selectedIndex == -1 )
      {
         //I don't think we need to do anything. we'll return from here.
         return;
      }
      else
      {
         try
         {
            javax.swing.table.DefaultTableModel m = (javax.swing.table.DefaultTableModel)this.connectionsTable.getModel();
            String name = (String)m.getValueAt(selectedIndex, 0);
            this.dbInfo.setActiveDatabaseConnectionInfo( name );
            this.userChoice = OK_OPTION;
            this.setVisible(false);
            this.dispose();
         }
         catch(Throwable e)
         {
            //todo popup or something
         }
      }
      
   }//GEN-LAST:event_okButtonActionPerformed
   
   /** Closes the dialog */
   private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
   {
      this.closeDialog();
   }//GEN-LAST:event_closeDialog
   
   /**
    * @param args the command line arguments
    */
   public static void main(String args[])
   {
      new ActiveDatabaseConnectionDialog(new javax.swing.JFrame(), true).show();
   }
   
   /**
    *Method used to set active connection on a DatabaseConnectionInfoManager object.
    *@param parent the parent component to show the dialog in.
    *@param manager the DatabaseConnectionInfoManager objec to set the value for.
    *@return OK_OPTION or CANCEL_OPTION...if CANCEL_OPTION then the active connection has not changed.
    */
   public static int showActiveDatabaseConnectionDialog(java.awt.Component parent, DatabaseConnectionInfoManager manager)
   {
      int ret = CANCEL_OPTION;
      try
      {
         ActiveDatabaseConnectionDialog d = new ActiveDatabaseConnectionDialog(DialogUtilities.frameFromComponent(parent), true);
         d.dbInfo = manager;
         javax.swing.table.DefaultTableModel m = (javax.swing.table.DefaultTableModel)d.connectionsTable.getModel();
         java.util.Vector data = d.dbInfo.getDatabaseConnectionInfoKeysAndDrivers();
         int colCount = d.connectionsTable.getColumnCount();
         java.util.Vector cols = new java.util.Vector(colCount);
         for(int i = 0; i < colCount; i++ )
         {
            cols.addElement( m.getColumnName(i) );
         }
         m.setDataVector(data, cols);
         DatabaseConnectionInfo active = d.dbInfo.getActiveDatabaseConnectionInfo();
         if( active != null )
         {
            int selectedIndex = d.dbInfo.getIndexForKey(active.getInfoName());
            d.connectionsTable.setRowSelectionInterval(selectedIndex, selectedIndex);
         }
         d.show();
         ret = d.userChoice;
         d = null;
      }
      catch(Throwable e)
      {
         javax.swing.JOptionPane.showMessageDialog(parent, e.toString(), "Error in application", javax.swing.JOptionPane.ERROR_MESSAGE);
      }
      return ret;
   }//end showActiveDatabaseConnectionDialog
   
   protected void closeDialog()
   {
      this.userChoice = CANCEL_OPTION;
      setVisible(false);
      dispose();
   }
   
   // Variables declaration - do not modify//GEN-BEGIN:variables
   protected javax.swing.JPanel buttonsPanel;
   protected javax.swing.JButton cancelButton;
   protected javax.swing.JPanel connectionsPanel;
   protected javax.swing.JScrollPane connectionsScrollPane;
   protected javax.swing.JTable connectionsTable;
   protected javax.swing.JButton okButton;
   // End of variables declaration//GEN-END:variables
   
}
