/*
 * ExpressionEditor.java
 *
 * Created on 17 novembre 2003, 22.03
 */

package it.businesslogic.ireport.gui;
import it.businesslogic.ireport.gui.syntax.*;
import javax.swing.tree.*;
import javax.swing.*;
import java.util.*;
/**
 *
 * @author  Administrator
 */
public class ExpressionEditor extends javax.swing.JDialog
{
   
   
   /** Creates new form ExpressionEditor */
   public ExpressionEditor()
   {
      initComponents();
      this.setSize(600, 450);
      
      this.setModal(true);
      //this.setModal(true);
      org.syntax.jedit.SyntaxDocument sd = new org.syntax.jedit.SyntaxDocument();
      sd.setTokenMarker(new org.syntax.jedit.tokenmarker.JavaTokenMarker() );
      
      this.jEditTextArea1.setDocument( sd );
      
      DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode("root");
      dmtn.add( new DefaultMutableTreeNode("Fields"));
      dmtn.add( new DefaultMutableTreeNode("Variables"));
      dmtn.add( new DefaultMutableTreeNode("Parameters"));
      dmtn.add( new DefaultMutableTreeNode("Formulas"));
      this.jTree1.setCellRenderer(new DocumentExpressionEditorTreeCellRenderer());
      this.jTree1.setModel(new javax.swing.tree.DefaultTreeModel(dmtn));
      
      it.businesslogic.ireport.util.Misc.centerFrame(this);
      
      jList1.setModel(new DefaultListModel());
      
      
   }
   
   
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
    private void initComponents()//GEN-BEGIN:initComponents
    {
       jPanel1 = new javax.swing.JPanel();
       jSplitPane1 = new javax.swing.JSplitPane();
       jEditTextArea1 = new org.syntax.jedit.JEditTextArea();
       jSplitPane2 = new javax.swing.JSplitPane();
       jPanel3 = new javax.swing.JPanel();
       jScrollPane2 = new javax.swing.JScrollPane();
       jTree1 = new javax.swing.JTree();
       jScrollPane3 = new javax.swing.JScrollPane();
       jList1 = new javax.swing.JList();
       jPanel2 = new javax.swing.JPanel();
       jPanel4 = new javax.swing.JPanel();
       jButton1 = new javax.swing.JButton();
       jButton2 = new javax.swing.JButton();
       
       FormListener formListener = new FormListener();
       
       setTitle("Expression editor...");
       setModal(true);
       addComponentListener(formListener);
       addWindowListener(formListener);
       
       jPanel1.setLayout(new java.awt.BorderLayout());
       
       jSplitPane1.setDividerSize(4);
       jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
       jSplitPane1.setResizeWeight(0.5);
       jEditTextArea1.setMinimumSize(new java.awt.Dimension(20, 20));
       jEditTextArea1.setPreferredSize(new java.awt.Dimension(150, 150));
       jEditTextArea1.addComponentListener(formListener);
       
       jSplitPane1.setLeftComponent(jEditTextArea1);
       
       jSplitPane2.setDividerSize(4);
       jSplitPane2.setResizeWeight(0.5);
       jSplitPane2.setPreferredSize(new java.awt.Dimension(361, 160));
       jSplitPane2.setAutoscrolls(true);
       jPanel3.setLayout(new java.awt.BorderLayout());
       
       jScrollPane2.setPreferredSize(new java.awt.Dimension(100, 100));
       jTree1.setRootVisible(false);
       jTree1.addTreeSelectionListener(formListener);
       
       jScrollPane2.setViewportView(jTree1);
       
       jPanel3.add(jScrollPane2, java.awt.BorderLayout.CENTER);
       
       jSplitPane2.setLeftComponent(jPanel3);
       
       jScrollPane3.setPreferredSize(new java.awt.Dimension(259, 60));
       jList1.setFont(new java.awt.Font("Dialog", 0, 11));
       jList1.setPreferredSize(new java.awt.Dimension(80, 80));
       jList1.addMouseListener(formListener);
       
       jScrollPane3.setViewportView(jList1);
       
       jSplitPane2.setRightComponent(jScrollPane3);
       
       jSplitPane1.setBottomComponent(jSplitPane2);
       
       jPanel1.add(jSplitPane1, java.awt.BorderLayout.CENTER);
       
       getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);
       
       jPanel2.setLayout(new java.awt.BorderLayout());
       
       jPanel2.setMinimumSize(new java.awt.Dimension(10, 30));
       jPanel2.setPreferredSize(new java.awt.Dimension(10, 30));
       jPanel4.setLayout(null);
       
       jPanel4.setMinimumSize(new java.awt.Dimension(300, 10));
       jPanel4.setPreferredSize(new java.awt.Dimension(300, 10));
       jButton1.setFont(new java.awt.Font("Dialog", 0, 11));
       jButton1.setMnemonic('c');
       jButton1.setText("Cancel");
       jButton1.addActionListener(formListener);
       
       jPanel4.add(jButton1);
       jButton1.setBounds(210, 4, 88, 25);
       
       jButton2.setFont(new java.awt.Font("Dialog", 0, 11));
       jButton2.setMnemonic('a');
       jButton2.setText("Apply");
       jButton2.addActionListener(formListener);
       
       jPanel4.add(jButton2);
       jButton2.setBounds(118, 4, 90, 25);
       
       jPanel2.add(jPanel4, java.awt.BorderLayout.EAST);
       
       getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);
       
       pack();
    }
    
    // Code for dispatching events from components to event handlers.
    
    private class FormListener implements java.awt.event.ActionListener, java.awt.event.ComponentListener, java.awt.event.MouseListener, java.awt.event.WindowListener, javax.swing.event.TreeSelectionListener
    {
       public void actionPerformed(java.awt.event.ActionEvent evt)
       {
          if (evt.getSource() == jButton1)
          {
             ExpressionEditor.this.jButton1ActionPerformed(evt);
          }
          else if (evt.getSource() == jButton2)
          {
             ExpressionEditor.this.jButton2ActionPerformed(evt);
          }
       }
       
       public void componentHidden(java.awt.event.ComponentEvent evt)
       {
       }
       
       public void componentMoved(java.awt.event.ComponentEvent evt)
       {
       }
       
       public void componentResized(java.awt.event.ComponentEvent evt)
       {
          if (evt.getSource() == ExpressionEditor.this)
          {
             ExpressionEditor.this.formComponentResized(evt);
          }
          else if (evt.getSource() == jEditTextArea1)
          {
             ExpressionEditor.this.jEditTextArea1ComponentResized(evt);
          }
       }
       
       public void componentShown(java.awt.event.ComponentEvent evt)
       {
       }
       
       public void mouseClicked(java.awt.event.MouseEvent evt)
       {
          if (evt.getSource() == jList1)
          {
             ExpressionEditor.this.jList1MouseClicked(evt);
          }
       }
       
       public void mouseEntered(java.awt.event.MouseEvent evt)
       {
       }
       
       public void mouseExited(java.awt.event.MouseEvent evt)
       {
       }
       
       public void mousePressed(java.awt.event.MouseEvent evt)
       {
       }
       
       public void mouseReleased(java.awt.event.MouseEvent evt)
       {
       }
       
       public void windowActivated(java.awt.event.WindowEvent evt)
       {
       }
       
       public void windowClosed(java.awt.event.WindowEvent evt)
       {
       }
       
       public void windowClosing(java.awt.event.WindowEvent evt)
       {
          if (evt.getSource() == ExpressionEditor.this)
          {
             ExpressionEditor.this.exitForm(evt);
          }
       }
       
       public void windowDeactivated(java.awt.event.WindowEvent evt)
       {
       }
       
       public void windowDeiconified(java.awt.event.WindowEvent evt)
       {
       }
       
       public void windowIconified(java.awt.event.WindowEvent evt)
       {
       }
       
       public void windowOpened(java.awt.event.WindowEvent evt)
       {
       }
       
       public void valueChanged(javax.swing.event.TreeSelectionEvent evt)
       {
          if (evt.getSource() == jTree1)
          {
             ExpressionEditor.this.jTree1ValueChanged(evt);
          }
       }
    }//GEN-END:initComponents
    
    private void jList1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jList1MouseClicked
       if (evt.getClickCount() == 2 && evt.getButton() == java.awt.event.MouseEvent.BUTTON1)
       {
          if (this.jList1.getSelectedIndex() >= 0)
          {
             String s = ""+this.jList1.getSelectedValue();
             try
             {
                jEditTextArea1.getDocument().insertString( jEditTextArea1.getCaretPosition(), s, null);
             } catch (Exception ex)
             {}
          }
       }
    }//GEN-LAST:event_jList1MouseClicked
    
    private void jTree1ValueChanged(javax.swing.event.TreeSelectionEvent evt) {//GEN-FIRST:event_jTree1ValueChanged
       
       ( (DefaultListModel)jList1.getModel()).removeAllElements();
       
       if (jrf == null) return;
       DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)jTree1.getSelectionPath().getLastPathComponent();
       if ((""+dmtn.getUserObject()).equalsIgnoreCase("Fields"))
       {
          Enumeration enum = jrf.getReport().getFields().elements();
          while (enum.hasMoreElements())
          {
             ( (DefaultListModel)jList1.getModel()).addElement( "$F{"+enum.nextElement() +"}" );
          }
       }
       else if ((""+dmtn.getUserObject()).equalsIgnoreCase("Parameters"))
       {
          Enumeration enum = jrf.getReport().getParameters().elements();
          while (enum.hasMoreElements())
          {
             ( (DefaultListModel)jList1.getModel()).addElement( "$P{"+ enum.nextElement()+"}" );
          }
       }
       else if ((""+dmtn.getUserObject()).equalsIgnoreCase("Variables"))
       {
          Enumeration enum = jrf.getReport().getVariables().elements();
          while (enum.hasMoreElements())
          {
             ( (DefaultListModel)jList1.getModel()).addElement( "$V{"+enum.nextElement() +"}" );
          }
       }
    }//GEN-LAST:event_jTree1ValueChanged
    
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
       //this.setExpression( this.jEditTextArea1.getText() );
       this.setDialogResult( javax.swing.JOptionPane.NO_OPTION );
       this.dispose();
    }//GEN-LAST:event_jButton1ActionPerformed
    
    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
       this.setExpression( this.jEditTextArea1.getText() );
       this.setDialogResult( javax.swing.JOptionPane.OK_OPTION );
       this.dispose();
    }//GEN-LAST:event_jButton2ActionPerformed
    
    private void jEditTextArea1ComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_jEditTextArea1ComponentResized
       // Add your handling code here:
    }//GEN-LAST:event_jEditTextArea1ComponentResized
    
    private void formComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentResized
       //this.jEditTextArea1.recalculateVisibleLines();
       this.jEditTextArea1.updateScrollBars();
    }//GEN-LAST:event_formComponentResized
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
       
    }//GEN-LAST:event_exitForm
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
       new ExpressionEditor().show();
    }
    
    /** Getter for property jrf.
     * @return Value of property jrf.
     *
     */
    public it.businesslogic.ireport.gui.JReportFrame getJrf()
    {
       return jrf;
    }
    
    /** Setter for property jrf.
     * @param jrf New value of property jrf.
     *
     */
    public void setJrf(it.businesslogic.ireport.gui.JReportFrame jrf)
    {
       this.jrf = jrf;
       // Selezioniamo il campo fields....
       jTree1.setSelectionRow(0);
       
       jEditTextArea1.getTokenMarker().setKeywordLookup(
       jrf.getReport().getKeywordLookup());
    }
    
    /** Getter for property Expression.
     * @return Value of property Expression.
     *
     */
    public java.lang.String getExpression()
    {
       return Expression;
    }
    
    /** Setter for property Expression.
     * @param Expression New value of property Expression.
     *
     */
    public void setExpression(java.lang.String Expression)
    {
       this.Expression = Expression;
    }
    
    /** Getter for property dialogResult.
     * @return Value of property dialogResult.
     *
     */
    public int getDialogResult()
    {
       return dialogResult;
    }
    
    /** Setter for property dialogResult.
     * @param dialogResult New value of property dialogResult.
     *
     */
    public void setDialogResult(int dialogResult)
    {
       this.dialogResult = dialogResult;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JButton jButton1;
    protected javax.swing.JButton jButton2;
    protected org.syntax.jedit.JEditTextArea jEditTextArea1;
    protected javax.swing.JList jList1;
    protected javax.swing.JPanel jPanel1;
    protected javax.swing.JPanel jPanel2;
    protected javax.swing.JPanel jPanel3;
    protected javax.swing.JPanel jPanel4;
    protected javax.swing.JScrollPane jScrollPane2;
    protected javax.swing.JScrollPane jScrollPane3;
    protected javax.swing.JSplitPane jSplitPane1;
    protected javax.swing.JSplitPane jSplitPane2;
    protected javax.swing.JTree jTree1;
    // End of variables declaration//GEN-END:variables
    
    private JReportFrame jrf;
    
    private String Expression;
    
    private int dialogResult;
    
}
