/*
 * LineReportElement.java
 *
 * Created on 28 febbraio 2003, 20.02
 /*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.gui.*;
import it.businesslogic.ireport.util.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.geom.*;

public class LineReportElement extends GraphicReportElement 
{

	public String direction;
	
	public LineReportElement(int x, int y, int width, int height)
	{
		this(x,y,width,height,"TopDown");
	}
	
	public LineReportElement(int x, int y, int width, int height, String direction)
	{
		super(x,y,width,height);
		graphicElementPen  = "Thin";
		this.bgcolor = Color.WHITE;
		this.fgcolor = Color.BLACK;
		this.direction = direction;
	}
	
	public void drawObject(Graphics2D g,double zoom_factor, int x_shift_origin, int y_shift_origin)
	{
		this.zoom_factor = zoom_factor;
		//g.fill( position.x,position.y,width,height,new Brush(bgcolor, BrushStyle.SOLID));
		Point a = new Point( getZoomedDim( position.x-10) +10-x_shift_origin, getZoomedDim( position.y-10) +10-y_shift_origin );
		Point b = new Point( getZoomedDim(position.x+width-10)+10-x_shift_origin,getZoomedDim( position.y+height-10)+10-y_shift_origin);
				
		if (!direction.equalsIgnoreCase("TopDown"))
		{
			b.y = getZoomedDim( position.y-10) +10-y_shift_origin;
			a.y = getZoomedDim( position.y+height-10)+10-y_shift_origin;
		}
		
                Stroke stroke = getPenStroke( getGraphicElementPen() ,zoom_factor );
                Stroke oldStroke = g.getStroke();
                g.setStroke(stroke);
                
		g.setColor( this.fgcolor );    
		g.drawLine(a.x,a.y,b.x,b.y);
                
                g.setStroke(oldStroke);
	}
	
	public ReportElement cloneMe()
	{
		LineReportElement newReportElement = new LineReportElement(position.x, position.y, width, height);
		copyBaseReportElement(newReportElement, this);
		
		return newReportElement;
	}
        
        /** Getter for property direction.
         * @return Value of property direction.
         *
         */
        public java.lang.String getDirection() {
            return direction;
        }
        
        /** Setter for property direction.
         * @param direction New value of property direction.
         *
         */
        public void setDirection(java.lang.String direction) {
            this.direction = direction;
        }
        
        public void copyBaseReportElement(ReportElement destination, ReportElement source)
        {
                super.copyBaseReportElement(destination, source);
                
                if (destination instanceof LineReportElement &&
                    source instanceof LineReportElement )
                {
                    ((LineReportElement)destination).setDirection( new String(  ((LineReportElement)source).getDirection()));
                }
        }
}