/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.JRElement;
import dori.jasper.engine.JRElementGroup;
import dori.jasper.engine.fill.JRFillElement;
import dori.jasper.engine.fill.JRFillObjectFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JRFillElementGroup
implements JRElementGroup {
    protected List children = new ArrayList();
    protected JRElementGroup elementGroup = null;
    protected JRFillElement[] elements = null;
    private JRElement topElementInGroup = null;
    private JRElement bottomElementInGroup = null;
    private int stretchHeightDiff = 0;

    protected JRFillElementGroup(JRElementGroup elementGroup, JRFillObjectFactory factory) {
        if (elementGroup != null) {
            factory.put(elementGroup, this);
            List list = elementGroup.getChildren();
            if (list != null && list.size() > 0) {
                Object child = null;
                int i = 0;
                while (i < list.size()) {
                    child = list.get(i);
                    if (child instanceof JRElement) {
                        child = factory.getElement((JRElement)child);
                        this.children.add(child);
                    } else if (child instanceof JRElementGroup) {
                        child = factory.getElementGroup((JRElementGroup)child);
                        this.children.add(child);
                    }
                    ++i;
                }
            }
            this.getElements();
            elementGroup = factory.getElementGroup(elementGroup.getElementGroup());
        }
    }

    public List getChildren() {
        return this.children;
    }

    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    public JRElement[] getElements() {
        if (this.elements == null && this.children != null) {
            ArrayList<JRElement> allElements = new ArrayList<JRElement>();
            Object child = null;
            JRElement[] childElementArray = null;
            int i = 0;
            while (i < this.children.size()) {
                child = this.children.get(i);
                if (child instanceof JRFillElement) {
                    allElements.add((JRElement)child);
                } else if (child instanceof JRFillElementGroup && (childElementArray = ((JRFillElementGroup)child).getElements()) != null) {
                    allElements.addAll(Arrays.asList(childElementArray));
                }
                ++i;
            }
            this.elements = new JRFillElement[allElements.size()];
            allElements.toArray(this.elements);
        }
        return this.elements;
    }

    public JRElement getElementByKey(String key) {
        return null;
    }

    protected void reset() {
        this.topElementInGroup = null;
    }

    protected int getStretchHeightDiff() {
        if (this.topElementInGroup == null) {
            this.stretchHeightDiff = 0;
            this.setTopBottomElements();
            JRElement[] elements = this.getElements();
            if (elements != null && elements.length > 0) {
                JRFillElement topElem = null;
                JRFillElement bottomElem = null;
                int i = 0;
                while (i < elements.length) {
                    JRFillElement element = (JRFillElement)elements[i];
                    if (element.isToPrint()) {
                        if (topElem == null || topElem != null && element.getRelativeY() + element.getStretchHeight() < topElem.getRelativeY() + topElem.getStretchHeight()) {
                            topElem = element;
                        }
                        if (bottomElem == null || bottomElem != null && element.getRelativeY() + element.getStretchHeight() > bottomElem.getRelativeY() + bottomElem.getStretchHeight()) {
                            bottomElem = element;
                        }
                    }
                    ++i;
                }
                this.stretchHeightDiff = bottomElem.getRelativeY() + bottomElem.getStretchHeight() - topElem.getRelativeY() - (this.bottomElementInGroup.getY() + this.bottomElementInGroup.getHeight() - this.topElementInGroup.getY());
                if (this.stretchHeightDiff < 0) {
                    this.stretchHeightDiff = 0;
                }
            }
        }
        return this.stretchHeightDiff;
    }

    private void setTopBottomElements() {
        JRElement[] elements = this.getElements();
        if (elements != null && elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                if (this.topElementInGroup == null || this.topElementInGroup != null && elements[i].getY() + elements[i].getHeight() < this.topElementInGroup.getY() + this.topElementInGroup.getHeight()) {
                    this.topElementInGroup = elements[i];
                }
                if (this.bottomElementInGroup == null || this.bottomElementInGroup != null && elements[i].getY() + elements[i].getHeight() > this.bottomElementInGroup.getY() + this.bottomElementInGroup.getHeight()) {
                    this.bottomElementInGroup = elements[i];
                }
                ++i;
            }
        }
    }
}

