/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodFormatException;
import org.jfree.data.time.Year;
import org.jfree.date.SerialDate;

public class Week
extends RegularTimePeriod
implements Serializable {
    public static final int FIRST_WEEK_IN_YEAR = 1;
    public static final int LAST_WEEK_IN_YEAR = 53;
    private Year year;
    private int week;

    public Week() {
        this(new Date());
    }

    public Week(int week, int year) {
        this(week, new Year(year));
    }

    public Week(int week, Year year) {
        if (week < 1 && week > 53) {
            throw new IllegalArgumentException("Week(...): week outside valid range.");
        }
        this.week = week;
        this.year = year;
    }

    public Week(Date time) {
        this(time, RegularTimePeriod.DEFAULT_TIME_ZONE);
    }

    public Week(Date time, TimeZone zone) {
        Calendar calendar = Calendar.getInstance(zone);
        calendar.setTime(time);
        int tempWeek = calendar.get(3);
        if (tempWeek == 1 && calendar.get(2) == 11) {
            this.week = 1;
            this.year = new Year(calendar.get(1) + 1);
        } else {
            this.week = Math.min(tempWeek, 53);
            this.year = new Year(calendar.get(1));
        }
    }

    public Year getYear() {
        return this.year;
    }

    public int getYearValue() {
        return this.year.getYear();
    }

    public int getWeek() {
        return this.week;
    }

    public RegularTimePeriod previous() {
        Week result;
        if (this.week != 1) {
            result = new Week(this.week - 1, this.year);
        } else {
            Year prevYear = (Year)this.year.previous();
            if (prevYear != null) {
                int yy = prevYear.getYear();
                Calendar prevYearCalendar = Calendar.getInstance();
                prevYearCalendar.set(yy, 11, 31);
                result = new Week(prevYearCalendar.getActualMaximum(3), prevYear);
            } else {
                result = null;
            }
        }
        return result;
    }

    public RegularTimePeriod next() {
        Week result;
        if (this.week < 52) {
            result = new Week(this.week + 1, this.year);
        } else {
            Year nextYear;
            Calendar calendar = Calendar.getInstance();
            calendar.set(this.year.getYear(), 11, 31);
            int actualMaxWeek = calendar.getActualMaximum(3);
            result = this.week != actualMaxWeek ? new Week(this.week + 1, this.year) : ((nextYear = (Year)this.year.next()) != null ? new Week(1, nextYear) : null);
        }
        return result;
    }

    public long getSerialIndex() {
        return (long)this.year.getYear() * 53L + (long)this.week;
    }

    public long getFirstMillisecond(Calendar calendar) {
        Calendar day1FirstWeek = (Calendar)calendar.clone();
        day1FirstWeek.set(this.year.getYear(), 0, 1);
        int dayOfWeek = day1FirstWeek.get(7);
        day1FirstWeek.add(6, 1 - dayOfWeek);
        int day = day1FirstWeek.get(5);
        int month = day1FirstWeek.get(2) + 1;
        int thisYear = day1FirstWeek.get(1);
        SerialDate jan1 = SerialDate.createInstance((int)day, (int)month, (int)thisYear);
        SerialDate startOfWeek = SerialDate.addDays((int)((this.week - 1) * 7), (SerialDate)jan1);
        Day first = new Day(startOfWeek);
        return first.getFirstMillisecond(calendar);
    }

    public long getLastMillisecond(Calendar calendar) {
        Calendar cal = (Calendar)calendar.clone();
        cal.set(this.year.getYear(), 0, 1);
        int actualMaxWeek = cal.getActualMaximum(3);
        if (this.week == actualMaxWeek) {
            return this.year.getLastMillisecond(calendar);
        }
        Calendar firstDayOfFirstWeek = Calendar.getInstance();
        firstDayOfFirstWeek.set(this.year.getYear(), 0, 1);
        int dayOfWeek = firstDayOfFirstWeek.get(7);
        firstDayOfFirstWeek.add(6, 1 - dayOfWeek);
        int day = firstDayOfFirstWeek.get(5);
        int month = firstDayOfFirstWeek.get(2) + 1;
        int thisYear = firstDayOfFirstWeek.get(1);
        SerialDate jan1 = SerialDate.createInstance((int)day, (int)month, (int)thisYear);
        SerialDate endOfWeek = SerialDate.addDays((int)(this.week * 7 - 1), (SerialDate)jan1);
        Day last = new Day(endOfWeek);
        return last.getLastMillisecond(calendar);
    }

    public String toString() {
        return "Week " + this.week + ", " + this.year;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof Week) {
                Week target = (Week)obj;
                return this.week == target.getWeek() && this.year.equals(target.getYear());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.week;
        result = 37 * result + this.year.hashCode();
        return result;
    }

    public int compareTo(Object o1) {
        int result;
        if (o1 instanceof Week) {
            Week w = (Week)o1;
            result = this.year.getYear() - w.getYear().getYear();
            if (result == 0) {
                result = this.week - w.getWeek();
            }
        } else {
            result = o1 instanceof RegularTimePeriod ? 0 : 1;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Week parseWeek(String s) {
        Week result = null;
        if (s == null) return result;
        int i = Week.findSeparator(s = s.trim());
        if (i == -1) throw new TimePeriodFormatException("Week.parseWeek(String): could not find separator.");
        String s1 = s.substring(0, i).trim();
        String s2 = s.substring(i + 1, s.length()).trim();
        Year y = Week.evaluateAsYear(s1);
        if (y != null) {
            int w = Week.stringToWeek(s2);
            if (w != -1) return new Week(w, y);
            throw new TimePeriodFormatException("Week.parseWeek(String): can't evaluate the week.");
        }
        y = Week.evaluateAsYear(s2);
        if (y == null) throw new TimePeriodFormatException("Week.parseWeek(String): can't evaluate the year.");
        int w = Week.stringToWeek(s1);
        if (w != -1) return new Week(w, y);
        throw new TimePeriodFormatException("Week.parseWeek(String): can't evaluate the week.");
    }

    private static int findSeparator(String s) {
        int result = s.indexOf(45);
        if (result == -1) {
            result = s.indexOf(44);
        }
        if (result == -1) {
            result = s.indexOf(32);
        }
        if (result == -1) {
            result = s.indexOf(46);
        }
        return result;
    }

    private static Year evaluateAsYear(String s) {
        Year result = null;
        try {
            result = Year.parseYear(s);
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            // empty catch block
        }
        return result;
    }

    private static int stringToWeek(String s) {
        int result = -1;
        s = s.replace('W', ' ');
        s = s.trim();
        try {
            result = Integer.parseInt(s);
            if (result < 1 || result > 53) {
                result = -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }
}

