/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.base;

import dori.jasper.engine.JRBand;
import dori.jasper.engine.JRField;
import dori.jasper.engine.JRGroup;
import dori.jasper.engine.JRParameter;
import dori.jasper.engine.JRQuery;
import dori.jasper.engine.JRReport;
import dori.jasper.engine.JRReportFont;
import dori.jasper.engine.JRVariable;
import dori.jasper.engine.base.JRBaseObjectFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JRBaseReport
implements JRReport,
Serializable {
    private static final long serialVersionUID = 502L;
    protected String name = null;
    protected int columnCount = 1;
    protected byte printOrder = 1;
    protected int pageWidth = 595;
    protected int pageHeight = 842;
    protected byte orientation = 1;
    protected byte whenNoDataType = 1;
    protected int columnWidth = 555;
    protected int columnSpacing = 0;
    protected int leftMargin = 20;
    protected int rightMargin = 20;
    protected int topMargin = 30;
    protected int bottomMargin = 30;
    protected boolean isTitleNewPage = false;
    protected boolean isSummaryNewPage = false;
    protected String scriptletClass = null;
    protected Map propertiesMap = null;
    protected JRReportFont defaultFont = null;
    protected JRReportFont[] fonts = null;
    protected JRParameter[] parameters = null;
    protected JRQuery query = null;
    protected JRField[] fields = null;
    protected JRVariable[] variables = null;
    protected JRGroup[] groups = null;
    protected JRBand background = null;
    protected JRBand title = null;
    protected JRBand pageHeader = null;
    protected JRBand columnHeader = null;
    protected JRBand detail = null;
    protected JRBand columnFooter = null;
    protected JRBand pageFooter = null;
    protected JRBand summary = null;

    public JRBaseReport() {
    }

    public JRBaseReport(JRReport report) {
        JRGroup[] jrGroups;
        JRVariable[] jrVariables;
        JRParameter[] jrParameters;
        this.name = report.getName();
        this.columnCount = report.getColumnCount();
        this.printOrder = report.getPrintOrder();
        this.pageWidth = report.getPageWidth();
        this.pageHeight = report.getPageHeight();
        this.orientation = report.getOrientation();
        this.whenNoDataType = report.getWhenNoDataType();
        this.columnWidth = report.getColumnWidth();
        this.columnSpacing = report.getColumnSpacing();
        this.leftMargin = report.getLeftMargin();
        this.rightMargin = report.getRightMargin();
        this.topMargin = report.getTopMargin();
        this.bottomMargin = report.getBottomMargin();
        this.isTitleNewPage = report.isTitleNewPage();
        this.isSummaryNewPage = report.isSummaryNewPage();
        this.scriptletClass = report.getScriptletClass();
        String[] propertyNames = report.getPropertyNames();
        if (propertyNames != null && propertyNames.length > 0) {
            int i = 0;
            while (i < propertyNames.length) {
                this.setProperty(propertyNames[i], report.getProperty(propertyNames[i]));
                ++i;
            }
        }
        JRBaseObjectFactory factory = new JRBaseObjectFactory(this);
        this.defaultFont = factory.getReportFont(report.getDefaultFont());
        JRReportFont[] jrFonts = report.getFonts();
        if (jrFonts != null && jrFonts.length > 0) {
            this.fonts = new JRReportFont[jrFonts.length];
            int i = 0;
            while (i < this.fonts.length) {
                this.fonts[i] = factory.getReportFont(jrFonts[i]);
                ++i;
            }
        }
        if ((jrParameters = report.getParameters()) != null && jrParameters.length > 0) {
            this.parameters = new JRParameter[jrParameters.length];
            int i = 0;
            while (i < this.parameters.length) {
                this.parameters[i] = factory.getParameter(jrParameters[i]);
                ++i;
            }
        }
        this.query = factory.getQuery(report.getQuery());
        JRField[] jrFields = report.getFields();
        if (jrFields != null && jrFields.length > 0) {
            this.fields = new JRField[jrFields.length];
            int i = 0;
            while (i < this.fields.length) {
                this.fields[i] = factory.getField(jrFields[i]);
                ++i;
            }
        }
        if ((jrVariables = report.getVariables()) != null && jrVariables.length > 0) {
            this.variables = new JRVariable[jrVariables.length];
            int i = 0;
            while (i < this.variables.length) {
                this.variables[i] = factory.getVariable(jrVariables[i]);
                ++i;
            }
        }
        if ((jrGroups = report.getGroups()) != null && jrGroups.length > 0) {
            this.groups = new JRGroup[jrGroups.length];
            int i = 0;
            while (i < this.groups.length) {
                this.groups[i] = factory.getGroup(jrGroups[i]);
                ++i;
            }
        }
        this.background = factory.getBand(report.getBackground());
        this.title = factory.getBand(report.getTitle());
        this.pageHeader = factory.getBand(report.getPageHeader());
        this.columnHeader = factory.getBand(report.getColumnHeader());
        this.detail = factory.getBand(report.getDetail());
        this.columnFooter = factory.getBand(report.getColumnFooter());
        this.pageFooter = factory.getBand(report.getPageFooter());
        this.summary = factory.getBand(report.getSummary());
    }

    public String getName() {
        return this.name;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public byte getPrintOrder() {
        return this.printOrder;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public byte getOrientation() {
        return this.orientation;
    }

    public byte getWhenNoDataType() {
        return this.whenNoDataType;
    }

    public void setWhenNoDataType(byte whenNoDataType) {
        this.whenNoDataType = whenNoDataType;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public int getColumnSpacing() {
        return this.columnSpacing;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public boolean isTitleNewPage() {
        return this.isTitleNewPage;
    }

    public boolean isSummaryNewPage() {
        return this.isSummaryNewPage;
    }

    public String getScriptletClass() {
        return this.scriptletClass;
    }

    public String[] getPropertyNames() {
        if (this.propertiesMap != null) {
            Set names = this.propertiesMap.keySet();
            return names.toArray(new String[names.size()]);
        }
        return null;
    }

    public String getProperty(String name) {
        if (this.propertiesMap != null) {
            return (String)this.propertiesMap.get(name);
        }
        return null;
    }

    public void setProperty(String name, String value) {
        if (this.propertiesMap == null) {
            this.propertiesMap = new HashMap();
        }
        this.propertiesMap.put(name, value);
    }

    public void removeProperty(String name) {
        if (this.propertiesMap != null) {
            this.propertiesMap.remove(name);
        }
    }

    public JRReportFont getDefaultFont() {
        return this.defaultFont;
    }

    public JRReportFont[] getFonts() {
        return this.fonts;
    }

    public JRParameter[] getParameters() {
        return this.parameters;
    }

    public JRQuery getQuery() {
        return this.query;
    }

    public JRField[] getFields() {
        return this.fields;
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }

    public JRGroup[] getGroups() {
        return this.groups;
    }

    public JRBand getBackground() {
        return this.background;
    }

    public JRBand getTitle() {
        return this.title;
    }

    public JRBand getPageHeader() {
        return this.pageHeader;
    }

    public JRBand getColumnHeader() {
        return this.columnHeader;
    }

    public JRBand getDetail() {
        return this.detail;
    }

    public JRBand getColumnFooter() {
        return this.columnFooter;
    }

    public JRBand getPageFooter() {
        return this.pageFooter;
    }

    public JRBand getSummary() {
        return this.summary;
    }
}

