/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.barcode.BcImage;
import java.awt.Graphics2D;

public class BarcodeReportElement
extends ImageReportElement {
    private String title = "Sample barcode";
    private boolean legend = false;
    private double angle = 0.0;
    private String bcText = "0815";
    private int type = 13;
    private boolean checkSum = false;

    public BarcodeReportElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setGraphicElementPen("Thin");
        this.setImg(BcImage.getBarcodeImage(this.type, this.bcText, this.angle, this.checkSum));
        this.width = BcImage.getBarcode().getWidth();
        this.height = BcImage.getBarcode().getHeightBar();
        this.setImageClass("java.awt.Image");
        this.setScaleImage("FillFrame");
        this.setGraphicElementPen("None");
        this.setHyperlinkType("None");
        this.setAnchorNameExpression("");
    }

    public void setAngle(double angle) {
        this.angle = angle;
        this.update();
    }

    public double getAngle() {
        return this.angle;
    }

    public void update() {
        StringBuffer bcCall = new StringBuffer("/*barcode*/it.businesslogic.ireport.barcode.BcImage.getBarcodeImage(");
        bcCall.append(this.getType());
        bcCall.append(",\"");
        bcCall.append(this.getBcText());
        bcCall.append("\",");
        bcCall.append(this.getAngle());
        bcCall.append(",");
        bcCall.append(this.isCheckSum());
        bcCall.append(")");
        this.setImageExpression(bcCall.toString());
        this.setImg(BcImage.getBarcodeImage(this.type, this.bcText, this.angle, this.checkSum));
        this.width = BcImage.getBarcode().getMinimumSize().width;
        this.height = BcImage.getBarcode().getMinimumSize().height;
        this.updateBounds();
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        super.drawObject(g, zoom_factor, x_shift_origin, y_shift_origin);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.setImg(null);
    }

    public String getBcText() {
        return this.bcText;
    }

    public void setBcText(String bcText) {
        this.bcText = bcText;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(boolean checkSum) {
        this.checkSum = checkSum;
    }
}

