/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.chart.IReportChartFactory;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.StringTokenizer;

public class ChartReportElement
extends ImageReportElement {
    private int chartType = 1;
    private String title = "Sample chart";
    private boolean legend = false;
    private int chartWidth = 640;
    private int chartHeight = 480;

    public ChartReportElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setGraphicElementPen("Thin");
        this.setBgcolor(Color.WHITE);
        this.setFgcolor(Color.BLACK);
        if (this.getImgDef() == null) {
            ChartReportElement.setImgDef(Misc.loadImageFromResources("it/businesslogic/ireport/icons/layout/img.gif"));
        }
        this.setImg(null);
        this.setIsUsingCache(false);
        this.setImageExpression("");
        this.setImageClass("java.awt.Image");
        this.setScaleImage("RetainShape");
        this.setGraphicElementPen("None");
        this.setHyperlinkType("None");
        this.setAnchorNameExpression("");
        this.chartWidth = 640;
        this.chartHeight = 480;
        this.setImg(null);
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        if (this.getImg() == null) {
            this.setImg(IReportChartFactory.iReportChart(this.title, this.chartWidth, this.chartHeight, this.chartType, this.legend, this.getBgcolor()));
        }
        super.drawObject(g, zoom_factor, x_shift_origin, y_shift_origin);
    }

    public int getChartType() {
        return this.chartType;
    }

    public void setChartType(int chartType) {
        if (this.chartType == chartType) {
            return;
        }
        this.chartType = chartType;
        this.setImg(null);
    }

    public boolean isLegend() {
        return this.legend;
    }

    public void setLegend(boolean legend) {
        this.legend = legend;
        int tmp = this.chartType;
        this.chartType = -1;
        this.setChartType(tmp);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.setImg(null);
    }

    public int getChartWidth() {
        return this.chartWidth;
    }

    public void setChartWidth(int chartWidth) {
        this.chartWidth = chartWidth;
        this.setImg(null);
    }

    public int getChartHeight() {
        return this.chartHeight;
    }

    public void setChartHeight(int chartHeight) {
        this.chartHeight = chartHeight;
        this.setImg(null);
    }

    public void parseExpression(String expression) {
        expression = expression.trim();
        if ((expression = Misc.string_replace("", "(java.awt.Image)it.businesslogic.ireport.chart.IReportChartFactory.iReportChart(", expression)).endsWith(")")) {
            expression = expression.substring(0, expression.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(expression, "\n");
    }
}

