/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import dori.jasper.engine.JRDataSource;
import dori.jasper.engine.JREmptyDataSource;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JasperCompileManager;
import dori.jasper.engine.JasperFillManager;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.design.JRJdk13Compiler;
import dori.jasper.engine.export.JRCsvExporter;
import dori.jasper.engine.export.JRGraphics2DExporter;
import dori.jasper.engine.export.JRHtmlExporter;
import dori.jasper.engine.export.JRPdfExporter;
import dori.jasper.engine.export.JRXlsExporter;
import dori.jasper.view.JasperViewer;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.connection.JDBCConnection;
import it.businesslogic.ireport.connection.JRCustomDataSourceConnection;
import it.businesslogic.ireport.export.JRTxtExporter;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;

public class IReportCompiler
implements Runnable {
    public static final int CMD_COMPILE = 1;
    public static final int CMD_EXPORT = 2;
    public static final int CMD_COMPILE_SCRIPTLET = 4;
    public static final String OUTPUT_DIRECTORY = "OUTPUT_DIRECTORY";
    public static final String OUTPUT_FORMAT = "OUTPUT_FORMAT";
    public static final String USE_EMPTY_DATASOURCE = "USE_EMPTY_DATASOURCE";
    public static final String USE_CONNECTION = "USE_CONNECTION";
    public static final String CONNECTION = "CONNECTION";
    public static final String SCRIPTLET_OUTPUT_DIRECTORY = "SCRIPTLET_OUTPUT_DIRECTORY";
    static PrintStream myPrintStream = null;
    private String status = "";
    private IReportConnection iReportConnection;
    private JReportFrame jrf;
    private MainFrame mainFrame;
    private int command = 0;
    private HashMap properties = new HashMap();
    private Thread thread;
    private String javaFile = "";
    private static String outputBuffer = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String viewer_program;
        String format;
        String fileName;
        long start;
        block65: {
            JasperPrint print;
            block64: {
                StringWriter sw;
                String oldCompileTemp;
                String tempDirStr;
                String srcScriptletFileName;
                String scriptletFileName;
                block66: {
                    block61: {
                        block62: {
                            start = System.currentTimeMillis();
                            PrintStream out = System.out;
                            PrintStream err = System.err;
                            if (myPrintStream == null) {
                                myPrintStream = new PrintStream(new FilteredStream(new ByteArrayOutputStream()));
                            }
                            if (out != myPrintStream) {
                                System.setOut(myPrintStream);
                            }
                            if (err != myPrintStream) {
                                System.setErr(myPrintStream);
                            }
                            outputBuffer = "";
                            fileName = this.jrf.getReport().getFilename();
                            String srcFileName = this.jrf.getReport().getFilename();
                            fileName = fileName.substring(0, fileName.length() - 3) + "jasper";
                            File f = new File(fileName);
                            if (this.properties.get(OUTPUT_DIRECTORY) != null) {
                                fileName = (String)this.properties.get(OUTPUT_DIRECTORY) + File.separatorChar + f.getName();
                            }
                            scriptletFileName = this.jrf.getReport().getFilename();
                            srcScriptletFileName = this.jrf.getReport().getFilename();
                            srcScriptletFileName = scriptletFileName = srcScriptletFileName.substring(0, scriptletFileName.length() - 4) + "Scriptlet.java";
                            File f2 = new File(scriptletFileName);
                            if (this.properties.get(SCRIPTLET_OUTPUT_DIRECTORY) != null) {
                                scriptletFileName = (String)this.properties.get(SCRIPTLET_OUTPUT_DIRECTORY) + File.separatorChar + f2.getName();
                            }
                            if ((this.command & 1) == 0) break block66;
                            System.setProperty("jasper.reports.compile.keep.java.file", "true");
                            this.javaFile = this.jrf.getReport().getName() + ".java";
                            oldCompileTemp = tempDirStr = System.getProperty("jasper.reports.compile.temp");
                            if (tempDirStr == null || tempDirStr.length() == 0 || this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                tempDirStr = this.mainFrame.getTranslatedCompileDirectory();
                            }
                            File file = new File(tempDirStr);
                            this.javaFile = new File(file, this.javaFile).getPath();
                            this.status = "Compiling";
                            this.mainFrame.logOnConsole("</font><font face=\"SansSerif\" size=\"3\" color=\"#000000\">Compiling to file... " + fileName + " -> " + this.javaFile + "</font><br><font face=\"Courier New\" size=\"3\">", true);
                            try {
                                try {
                                    if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                        System.setProperty("jasper.reports.compile.temp", tempDirStr);
                                    }
                                    JasperCompileManager.compileReportToFile((String)srcFileName, (String)fileName);
                                }
                                catch (JRException jrex) {
                                    this.mainFrame.logOnConsole("</font><font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Errors compiling " + fileName + "!</b></font><br><font face=\"Courier New\" size=\"3\">", true);
                                    Vector<String> source = new Vector<String>();
                                    try {
                                        BufferedReader is = new BufferedReader(new FileReader(this.javaFile));
                                        while (true) {
                                            String line;
                                            if ((line = is.readLine()) == null) {
                                                is.close();
                                                break;
                                            }
                                            source.addElement(line);
                                        }
                                    }
                                    catch (Exception ioex) {
                                        // empty catch block
                                    }
                                    StringWriter sw2 = new StringWriter(0);
                                    jrex.printStackTrace(new PrintWriter(sw2));
                                    System.out.println("\n\n\n");
                                    myPrintStream.flush();
                                    this.parseException(outputBuffer + sw2.getBuffer() + "", source);
                                    Object var19_29 = null;
                                    if (!this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) break block61;
                                    if (oldCompileTemp != null) {
                                        System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                        break block61;
                                    } else {
                                        System.setProperty("jasper.reports.compile.temp", "");
                                    }
                                    break block61;
                                }
                                catch (Exception ex) {
                                    this.mainFrame.logOnConsole("</font><font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Error compiling the report java source!</b></font><br><font face=\"Courier New\" size=\"3\">", true);
                                    sw = new StringWriter(0);
                                    ex.printStackTrace(new PrintWriter(sw));
                                    myPrintStream.flush();
                                    this.parseException(outputBuffer + sw.getBuffer() + "", null);
                                    Object var19_30 = null;
                                    if (!this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) break block61;
                                    if (oldCompileTemp != null) {
                                        System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                        break block61;
                                    } else {
                                        System.setProperty("jasper.reports.compile.temp", "");
                                    }
                                    break block61;
                                }
                                Object var19_28 = null;
                                if (!this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) break block61;
                                if (oldCompileTemp == null) break block62;
                            }
                            catch (Throwable throwable) {
                                Object var19_31 = null;
                                if (!this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) throw throwable;
                                if (oldCompileTemp != null) {
                                    System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                    throw throwable;
                                }
                                System.setProperty("jasper.reports.compile.temp", "");
                                throw throwable;
                            }
                            System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                            break block61;
                        }
                        System.setProperty("jasper.reports.compile.temp", "");
                    }
                    this.mainFrame.logOnConsole(outputBuffer);
                    outputBuffer = "";
                    this.mainFrame.logOnConsole("</font><hr><font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>Compilation running time : " + (System.currentTimeMillis() - start) + "</b></font><br><hr><font face=\"Courier New\" size=\"3\">", true);
                }
                if ((this.command & 4) != 0) {
                    start = System.currentTimeMillis();
                    oldCompileTemp = tempDirStr = System.getProperty("jasper.reports.compile.temp");
                    if (tempDirStr == null || tempDirStr.length() == 0 || this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                        tempDirStr = this.mainFrame.getTranslatedCompileDirectory();
                    }
                    File file = new File(tempDirStr);
                    this.javaFile = srcScriptletFileName;
                    this.javaFile = new File(file, this.javaFile).getPath();
                    this.javaFile = this.jrf.getReport().getScriptletFileName();
                    this.status = "Compiling scriptlet";
                    this.mainFrame.logOnConsole("</font><font face=\"SansSerif\" size=\"3\" color=\"#000000\">Compiling file... " + scriptletFileName + " -> " + this.javaFile + "</font><br><font face=\"Courier New\" size=\"3\">", true);
                    try {
                        JRJdk13Compiler compiler = new JRJdk13Compiler();
                        compiler.compileClass(new File(this.javaFile), Misc.getClassPath());
                    }
                    catch (Exception ex) {
                        this.mainFrame.logOnConsole("</font><font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Error compiling the Scriptlet java source!</b></font><br><font face=\"Courier New\" size=\"3\">", true);
                        sw = new StringWriter(0);
                        ex.printStackTrace(new PrintWriter(sw));
                        myPrintStream.flush();
                        this.parseException(outputBuffer + sw.getBuffer() + "", null);
                    }
                    finally {
                        if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                            // empty if block
                        }
                    }
                    this.mainFrame.logOnConsole(outputBuffer);
                    outputBuffer = "";
                    this.mainFrame.logOnConsole("</font><hr><font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>Compilation running time : " + (System.currentTimeMillis() - start) + "</b></font><br><hr><font face=\"Courier New\" size=\"3\">", true);
                }
                if ((this.command & 2) == 0) return;
                print = null;
                if (this.properties.get(USE_EMPTY_DATASOURCE) != null && this.properties.get(USE_EMPTY_DATASOURCE).equals("true")) {
                    try {
                        print = JasperFillManager.fillReport((String)fileName, new HashMap(), (JRDataSource)new JREmptyDataSource());
                    }
                    catch (Exception ex) {
                        this.mainFrame.logOnConsole("Error filling print...\n");
                        ex.printStackTrace();
                        this.mainFrame.logOnConsole(outputBuffer);
                        outputBuffer = "";
                    }
                } else if (this.properties.get(USE_CONNECTION) != null && this.properties.get(USE_CONNECTION).equals("true")) {
                    try {
                        IReportConnection connection = (IReportConnection)this.properties.get(CONNECTION);
                        HashMap hashMap = new HashMap();
                        if (connection instanceof JDBCConnection) {
                            print = JasperFillManager.fillReport((String)fileName, hashMap, (Connection)connection.getConnection());
                            break block64;
                        }
                        if (connection instanceof JRCustomDataSourceConnection) {
                            JRCustomDataSourceConnection cds = (JRCustomDataSourceConnection)connection;
                            Object obj = Class.forName(cds.getFactoryClass()).newInstance();
                            Method m = obj.getClass().getMethod(cds.getMethodToCall(), new Class[0]);
                            JRDataSource ds = (JRDataSource)m.invoke(obj, (Object[])new Class[0]);
                            print = JasperFillManager.fillReport((String)fileName, hashMap, (JRDataSource)ds);
                        }
                    }
                    catch (Exception ex) {
                        this.mainFrame.logOnConsole("Error filling print...\n");
                        ex.printStackTrace();
                        this.mainFrame.logOnConsole(outputBuffer);
                        outputBuffer = "";
                    }
                }
            }
            Object jrv = null;
            Object var13_19 = null;
            if (print == null) {
                this.mainFrame.logOnConsole("Print not filled. Try to use an EmptyDataSource...!\n");
                return;
            }
            format = Misc.nvl(this.properties.get(OUTPUT_FORMAT), "pdf");
            viewer_program = "";
            this.mainFrame.logOnConsole(this.properties.get(OUTPUT_FORMAT) + "Exporting\n");
            try {
                void var13_27;
                if (format.equalsIgnoreCase("pdf")) {
                    JRPdfExporter jRPdfExporter = new JRPdfExporter();
                    fileName = fileName.substring(0, fileName.length() - 6) + "pdf";
                    this.mainFrame.logOnConsole("Exporting pdf to file... \"" + fileName + "\"\n");
                    viewer_program = this.mainFrame.getProperties().getProperty("ExternalPDFViewer");
                } else if (format.equalsIgnoreCase("csv")) {
                    JRCsvExporter jRCsvExporter = new JRCsvExporter();
                    fileName = fileName.substring(0, fileName.length() - 6) + "csv";
                    this.mainFrame.logOnConsole("Exporting CSV to file... " + fileName + "\n");
                    viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalCSVViewer"), "");
                } else if (format.equalsIgnoreCase("html")) {
                    JRHtmlExporter jRHtmlExporter = new JRHtmlExporter();
                    fileName = fileName.substring(0, fileName.length() - 6) + "html";
                    this.mainFrame.logOnConsole("Exporting HTML to file... " + fileName + "\n");
                    viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalHTMLViewer"), "");
                } else if (format.equalsIgnoreCase("xls")) {
                    JRXlsExporter jRXlsExporter = new JRXlsExporter();
                    fileName = fileName.substring(0, fileName.length() - 6) + "xls";
                    this.mainFrame.logOnConsole("Exporting xls to file... " + fileName + "\n");
                    viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalXLSViewer"), "");
                } else if (format.equalsIgnoreCase("java2D")) {
                    JRGraphics2DExporter jRGraphics2DExporter = new JRGraphics2DExporter();
                    this.mainFrame.logOnConsole("Exporting to Java2D \n");
                    viewer_program = null;
                } else if (format.equalsIgnoreCase("jrviewer")) {
                    this.mainFrame.logOnConsole("Viewing with JasperReports Viewer\n");
                    Object var13_25 = null;
                    viewer_program = null;
                } else if (format.equalsIgnoreCase("txt")) {
                    JRTxtExporter jRTxtExporter = new JRTxtExporter();
                    fileName = fileName.substring(0, fileName.length() - 6) + "txt";
                    this.mainFrame.logOnConsole("Exporting txt (experimental) to file... " + fileName + "\n");
                    viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalEditor"), "");
                }
                if (var13_27 != null) {
                    var13_27.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)fileName);
                    var13_27.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                    var13_27.exportReport();
                    break block65;
                }
                if (format.equalsIgnoreCase("jrviewer")) {
                    JasperViewer jasperViewer = new JasperViewer(print, false);
                    jasperViewer.setTitle("iReport JasperViewer");
                    jasperViewer.show();
                }
            }
            catch (Exception ex2) {
                this.mainFrame.logOnConsole("Error exporting print...\n");
                ex2.printStackTrace();
                this.mainFrame.logOnConsole(outputBuffer);
                outputBuffer = "";
            }
        }
        this.mainFrame.logOnConsole("Running time : " + (System.currentTimeMillis() - start) + "\n");
        Runtime rt = Runtime.getRuntime();
        if (viewer_program == null || viewer_program.equals("")) {
            if (format.equalsIgnoreCase("jrviewer")) {
                return;
            }
            this.mainFrame.logOnConsole("No external viewer specified for this type of print. Set it in the options frame!\n");
            return;
        }
        try {
            String execute_string = viewer_program + " " + fileName + "";
            this.mainFrame.logOnConsole("Executing: " + execute_string + "\n");
            rt.exec(execute_string);
        }
        catch (Exception ex) {
            this.mainFrame.logOnConsole("Error viewing report...\n");
            ex.printStackTrace();
            this.mainFrame.logOnConsole(outputBuffer + "\n");
            outputBuffer = "";
        }
        this.mainFrame.logOnConsole("Finished...\n");
    }

    public int getCommand() {
        return this.command;
    }

    public void setCommand(int command) {
        this.command = command;
    }

    public IReportConnection getIReportConnection() {
        return this.iReportConnection;
    }

    public void setIReportConnection(IReportConnection iReportConnection) {
        this.iReportConnection = iReportConnection;
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap properties) {
        this.properties = properties;
    }

    public String toString() {
        return this.status;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void parseException(String exception, Vector sourceLines) {
        String outString = "";
        StringTokenizer st = new StringTokenizer(exception, "\n");
        while (st.hasMoreElements()) {
            String line = st.nextToken();
            if (line.startsWith(this.javaFile)) {
                String lineCode;
                outString = outString + Misc.toHTML(line + "\n");
                String lineNumber = line.substring(this.javaFile.length() + 1);
                int ln = Integer.parseInt(lineNumber = lineNumber.substring(0, lineNumber.indexOf(58)));
                if (ln >= 3) {
                    ln -= 3;
                }
                String reference = "";
                if (sourceLines.size() >= ln && (lineCode = (String)sourceLines.elementAt(ln)).indexOf("            case") == 0 && lineCode.indexOf(" : // ") > 0) {
                    reference = lineCode.substring(lineCode.indexOf(" : // ") + 6).trim();
                }
                if (!st.hasMoreElements()) continue;
                try {
                    String error_line = st.nextToken();
                    if (error_line.startsWith("found")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    if (error_line.startsWith("required")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    if (error_line.startsWith("symbol")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    if (error_line.startsWith("location")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    String html = "";
                    for (int i = 0; i < error_line.length() && error_line.charAt(i) == ' '; ++i) {
                        html = html + "&nbsp;";
                    }
                    error_line = error_line.trim();
                    html = html + "<a href=\"http://error:" + this.jrf.getWindowID() + "/" + reference + "\">" + Misc.toHTML(error_line) + "</a><br>";
                    outString = outString + html;
                }
                catch (Exception ex) {
                    outString = outString + Misc.toHTML("Error parsing\n!");
                }
                continue;
            }
            if (line.startsWith("Warning :") && line.indexOf("y=") > 0 && line.indexOf("height=") > 0 && line.indexOf("band-height=") > 0) {
                outString = outString + "<a href=\"http://warning:" + this.jrf.getWindowID() + "\">" + Misc.toHTML(line) + "</a><br>";
                continue;
            }
            outString = outString + Misc.toHTML(line + "\n");
        }
        this.mainFrame.logOnConsole(outString, true);
        outputBuffer = "";
    }

    public JComponent searchButton(JComponent root, String text) {
        if (root instanceof JButton && ((JButton)root).getText() != null && ((JButton)root).getText().equals(text)) {
            return root;
        }
        for (int i = 0; i < root.getComponentCount(); ++i) {
            if (!(root.getComponent(i) instanceof JComponent)) continue;
            this.mainFrame.logOnConsole("" + (JComponent)root.getComponent(i) + "\n");
            JComponent res = this.searchButton((JComponent)root.getComponent(i), text);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        public void write(byte[] b) throws IOException {
            String aString = new String(b);
            outputBuffer = outputBuffer + aString;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            String aString = new String(b, off, len);
            outputBuffer = outputBuffer + aString;
        }
    }
}

