/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.gui.JDragTable;
import it.businesslogic.ireport.gui.JRFieldDialog;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.gui.JRVariableDialog;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class ValuesDialog
extends JDialog {
    private JButton jButtonDeleteField;
    private JButton jButtonDeleteParameter;
    private JButton jButtonDeleteVariable;
    private JButton jButtonModifyField;
    private JButton jButtonModifyParameter;
    private JButton jButtonModifyVariable;
    private JButton jButtonNewField;
    private JButton jButtonNewParameter;
    private JButton jButtonNewVariable;
    private JPanel jPanelButtons;
    private JPanel jPanelButtons1;
    private JPanel jPanelButtons2;
    private JPanel jPanelFields;
    private JPanel jPanelParameters;
    private JPanel jPanelVariables;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane;
    private JDragTable jTableFields;
    private JDragTable jTableParameters;
    private JDragTable jTableVariables;
    private JReportFrame jReportFrame;

    public ValuesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(420, 250);
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableParameters.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ValuesDialog.this.jTableParametersListSelectionValueChanged(e);
            }
        });
        dlsm = (DefaultListSelectionModel)this.jTableVariables.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ValuesDialog.this.jTableVariablesListSelectionValueChanged(e);
            }
        });
        dlsm = (DefaultListSelectionModel)this.jTableFields.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ValuesDialog.this.jTableFieldsListSelectionValueChanged(e);
            }
        });
        Misc.centerFrame(this);
    }

    public void jTableParametersListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableParameters.getSelectedRowCount() > 0) {
            this.jButtonModifyParameter.setEnabled(true);
            this.jButtonDeleteParameter.setEnabled(true);
        } else {
            this.jButtonModifyParameter.setEnabled(false);
            this.jButtonDeleteParameter.setEnabled(false);
        }
    }

    public void jTableVariablesListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableVariables.getSelectedRowCount() > 0) {
            this.jButtonModifyVariable.setEnabled(true);
            this.jButtonDeleteVariable.setEnabled(true);
        } else {
            this.jButtonModifyVariable.setEnabled(false);
            this.jButtonDeleteVariable.setEnabled(false);
        }
    }

    public void jTableFieldsListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableFields.getSelectedRowCount() > 0) {
            this.jButtonModifyField.setEnabled(true);
            this.jButtonDeleteField.setEnabled(true);
        } else {
            this.jButtonModifyField.setEnabled(false);
            this.jButtonDeleteField.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jPanelFields = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTableFields = new JDragTable();
        this.jPanelButtons2 = new JPanel();
        this.jButtonNewField = new JButton();
        this.jButtonModifyField = new JButton();
        this.jButtonDeleteField = new JButton();
        this.jPanelVariables = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTableVariables = new JDragTable();
        this.jPanelButtons1 = new JPanel();
        this.jButtonNewVariable = new JButton();
        this.jButtonModifyVariable = new JButton();
        this.jButtonDeleteVariable = new JButton();
        this.jPanelParameters = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableParameters = new JDragTable();
        this.jPanelButtons = new JPanel();
        this.jButtonNewParameter = new JButton();
        this.jButtonModifyParameter = new JButton();
        this.jButtonDeleteParameter = new JButton();
        this.setTitle("Values");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ValuesDialog.this.closeDialog(evt);
            }
        });
        this.jTabbedPane.setFont(new Font("Dialog", 0, 11));
        this.jTabbedPane.setName("");
        this.jPanelFields.setLayout(new BorderLayout());
        this.jScrollPane3.setBackground(new Color(255, 255, 255));
        this.jScrollPane3.setFont(new Font("Dialog", 0, 11));
        this.jTableFields.setModel(new DefaultTableModel(new Object[0][], new String[]{"Field name", "Class type"}){
            boolean[] canEdit = new boolean[]{false, false};

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableFields.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ValuesDialog.this.jTableFieldsMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jTableFields);
        this.jPanelFields.add((Component)this.jScrollPane3, "Center");
        this.jPanelButtons2.setLayout(null);
        this.jPanelButtons2.setMinimumSize(new Dimension(100, 10));
        this.jPanelButtons2.setPreferredSize(new Dimension(100, 10));
        this.jButtonNewField.setFont(new Font("Dialog", 0, 11));
        this.jButtonNewField.setText("New");
        this.jButtonNewField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesDialog.this.jButtonNewFieldActionPerformed(evt);
            }
        });
        this.jPanelButtons2.add(this.jButtonNewField);
        this.jButtonNewField.setBounds(4, 5, 92, 22);
        this.jButtonModifyField.setFont(new Font("Dialog", 0, 11));
        this.jButtonModifyField.setText("Modify");
        this.jButtonModifyField.setEnabled(false);
        this.jButtonModifyField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesDialog.this.jButtonModifyFieldActionPerformed(evt);
            }
        });
        this.jPanelButtons2.add(this.jButtonModifyField);
        this.jButtonModifyField.setBounds(4, 30, 92, 22);
        this.jButtonDeleteField.setFont(new Font("Dialog", 0, 11));
        this.jButtonDeleteField.setText("Delete");
        this.jButtonDeleteField.setEnabled(false);
        this.jButtonDeleteField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesDialog.this.jButtonDeleteFieldActionPerformed(evt);
            }
        });
        this.jPanelButtons2.add(this.jButtonDeleteField);
        this.jButtonDeleteField.setBounds(4, 56, 92, 22);
        this.jPanelFields.add((Component)this.jPanelButtons2, "East");
        this.jTabbedPane.addTab("Fields", this.jPanelFields);
        this.jPanelVariables.setLayout(new BorderLayout());
        this.jScrollPane2.setBackground(new Color(255, 255, 255));
        this.jScrollPane2.setFont(new Font("Dialog", 0, 11));
        this.jTableVariables.setModel(new DefaultTableModel(new Object[0][], new String[]{"Variable name", "Builtin"}){
            boolean[] canEdit = new boolean[]{false, false};

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableVariables.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ValuesDialog.this.jTableVariablesMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableVariables);
        this.jPanelVariables.add((Component)this.jScrollPane2, "Center");
        this.jPanelButtons1.setLayout(null);
        this.jPanelButtons1.setMinimumSize(new Dimension(100, 10));
        this.jPanelButtons1.setPreferredSize(new Dimension(100, 10));
        this.jButtonNewVariable.setFont(new Font("Dialog", 0, 11));
        this.jButtonNewVariable.setText("New");
        this.jButtonNewVariable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesDialog.this.jButtonNewVariableActionPerformed(evt);
            }
        });
        this.jPanelButtons1.add(this.jButtonNewVariable);
        this.jButtonNewVariable.setBounds(4, 5, 92, 22);
        this.jButtonModifyVariable.setFont(new Font("Dialog", 0, 11));
        this.jButtonModifyVariable.setText("Modify");
        this.jButtonModifyVariable.setEnabled(false);
        this.jButtonModifyVariable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesDialog.this.jButtonModifyVariableActionPerformed(evt);
            }
        });
        this.jPanelButtons1.add(this.jButtonModifyVariable);
        this.jButtonModifyVariable.setBounds(4, 30, 92, 22);
        this.jButtonDeleteVariable.setFont(new Font("Dialog", 0, 11));
        this.jButtonDeleteVariable.setText("Delete");
        this.jButtonDeleteVariable.setEnabled(false);
        this.jButtonDeleteVariable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesDialog.this.jButtonDeleteVariableActionPerformed(evt);
            }
        });
        this.jPanelButtons1.add(this.jButtonDeleteVariable);
        this.jButtonDeleteVariable.setBounds(4, 56, 92, 22);
        this.jPanelVariables.add((Component)this.jPanelButtons1, "East");
        this.jTabbedPane.addTab("Variables", this.jPanelVariables);
        this.jPanelParameters.setLayout(new BorderLayout(2, 2));
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setFont(new Font("Dialog", 0, 11));
        this.jTableParameters.setModel(new DefaultTableModel(new Object[0][], new String[]{"Parameter name", "Class type", "Is for prompting"}){
            boolean[] canEdit = new boolean[]{false, false, false};

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableParameters.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ValuesDialog.this.jTableParametersMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableParameters);
        this.jPanelParameters.add((Component)this.jScrollPane1, "Center");
        this.jPanelButtons.setLayout(null);
        this.jPanelButtons.setMinimumSize(new Dimension(100, 10));
        this.jPanelButtons.setPreferredSize(new Dimension(100, 10));
        this.jButtonNewParameter.setFont(new Font("Dialog", 0, 11));
        this.jButtonNewParameter.setText("New");
        this.jButtonNewParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesDialog.this.jButtonNewParameterActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonNewParameter);
        this.jButtonNewParameter.setBounds(4, 5, 92, 22);
        this.jButtonModifyParameter.setFont(new Font("Dialog", 0, 11));
        this.jButtonModifyParameter.setText("Modify");
        this.jButtonModifyParameter.setEnabled(false);
        this.jButtonModifyParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesDialog.this.jButtonModifyParameterActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonModifyParameter);
        this.jButtonModifyParameter.setBounds(4, 30, 92, 22);
        this.jButtonDeleteParameter.setFont(new Font("Dialog", 0, 11));
        this.jButtonDeleteParameter.setText("Delete");
        this.jButtonDeleteParameter.setEnabled(false);
        this.jButtonDeleteParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesDialog.this.jButtonDeleteParameterActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonDeleteParameter);
        this.jButtonDeleteParameter.setBounds(4, 56, 92, 22);
        this.jPanelParameters.add((Component)this.jPanelButtons, "East");
        this.jTabbedPane.addTab("Parameters", this.jPanelParameters);
        this.getContentPane().add((Component)this.jTabbedPane, "Center");
        this.pack();
    }

    private void jTableParametersMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1 && this.jTableParameters.getSelectedRow() >= 0) {
                this.jButtonModifyParameterActionPerformed(new ActionEvent(this.jButtonModifyParameter, 0, ""));
            }
        }
    }

    private void jTableVariablesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1 && this.jTableVariables.getSelectedRow() >= 0) {
                this.jButtonModifyVariableActionPerformed(new ActionEvent(this.jButtonModifyVariable, 0, ""));
            }
        }
    }

    private void jTableFieldsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1 && this.jTableFields.getSelectedRow() >= 0) {
                this.jButtonModifyFieldActionPerformed(new ActionEvent(this.jButtonModifyField, 0, ""));
            }
        }
    }

    private void jButtonDeleteFieldActionPerformed(ActionEvent evt) {
        this.jTableFields.getSelectedRows();
        int[] rows = this.jTableFields.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            this.getJReportFrame().getReport().removeField((JRField)this.jTableFields.getValueAt(rows[i], 0));
        }
        this.updateFields();
    }

    private void jButtonModifyFieldActionPerformed(ActionEvent evt) {
        JRField field = (JRField)this.jTableFields.getValueAt(this.jTableFields.getSelectedRow(), 0);
        Frame parent = Misc.frameFromComponent(this);
        JRFieldDialog jrpd = new JRFieldDialog(parent, true);
        jrpd.setField(field);
        jrpd.show();
        if (jrpd.getDialogResult() == 0) {
            field.setName(jrpd.getField().getName());
            field.setClassType(jrpd.getField().getClassType());
            field.setDescription(jrpd.getField().getDescription());
            this.updateFields();
        }
    }

    private void jButtonNewFieldActionPerformed(ActionEvent evt) {
        Frame parent = Misc.frameFromComponent(this);
        JRFieldDialog jrpd = new JRFieldDialog(parent, true);
        jrpd.show();
        if (jrpd.getDialogResult() == 0) {
            JRField field = jrpd.getField();
            this.getJReportFrame().getReport().addField(field);
            this.updateFields();
        }
    }

    private void jButtonDeleteVariableActionPerformed(ActionEvent evt) {
        this.jTableVariables.getSelectedRows();
        int[] rows = this.jTableVariables.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            if (((JRVariable)this.jTableVariables.getValueAt(rows[i], 0)).isBuiltin()) continue;
            this.getJReportFrame().getReport().removeVariable((JRVariable)this.jTableVariables.getValueAt(rows[i], 0));
        }
        this.updateVariables();
    }

    private void jButtonModifyVariableActionPerformed(ActionEvent evt) {
        JRVariable variable = (JRVariable)this.jTableVariables.getValueAt(this.jTableVariables.getSelectedRow(), 0);
        if (variable.isBuiltin()) {
            JOptionPane.showMessageDialog(this, "You can't modify or delete builtin variables!", "Invalid operation!", 2);
            return;
        }
        Frame parent = Misc.frameFromComponent(this);
        JRVariableDialog jrpd = new JRVariableDialog(this.getJReportFrame().getReport(), parent, true);
        jrpd.setVariable(variable);
        jrpd.show();
        if (jrpd.getDialogResult() == 0) {
            variable.setName(jrpd.getVariable().getName());
            variable.setClassType(jrpd.getVariable().getClassType());
            variable.setCalculation(jrpd.getVariable().getCalculation());
            variable.setResetType(jrpd.getVariable().getResetType());
            variable.setResetGroup(jrpd.getVariable().getResetGroup());
            variable.setExpression(jrpd.getVariable().getExpression());
            variable.setInitialValueExpression(jrpd.getVariable().getInitialValueExpression());
            this.updateVariables();
        }
    }

    private void jButtonNewVariableActionPerformed(ActionEvent evt) {
        Frame parent = Misc.frameFromComponent(this);
        JRVariableDialog jrpd = new JRVariableDialog(this.getJReportFrame().getReport(), parent, true);
        jrpd.show();
        if (jrpd.getDialogResult() == 0) {
            JRVariable variable = jrpd.getVariable();
            this.getJReportFrame().getReport().addVariable(variable);
            this.updateVariables();
        }
    }

    private void jButtonDeleteParameterActionPerformed(ActionEvent evt) {
        this.jTableParameters.getSelectedRows();
        int[] rows = this.jTableParameters.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            this.getJReportFrame().getReport().removeParameter((JRParameter)this.jTableParameters.getValueAt(rows[i], 0));
        }
        this.updateParameters();
    }

    private void jButtonModifyParameterActionPerformed(ActionEvent evt) {
        JRParameter parameter = (JRParameter)this.jTableParameters.getValueAt(this.jTableParameters.getSelectedRow(), 0);
        Frame parent = Misc.frameFromComponent(this);
        JRParameterDialog jrpd = new JRParameterDialog(parent, true);
        jrpd.setParameter(parameter);
        jrpd.show();
        if (jrpd.getDialogResult() == 0) {
            parameter.setName(jrpd.getParameter().getName());
            parameter.setClassType(jrpd.getParameter().getClassType());
            parameter.setDescription(jrpd.getParameter().getDescription());
            parameter.setDefaultValueExpression(jrpd.getParameter().getDefaultValueExpression());
            this.updateParameters();
        }
    }

    private void jButtonNewParameterActionPerformed(ActionEvent evt) {
        Frame parent = Misc.frameFromComponent(this);
        JRParameterDialog jrpd = new JRParameterDialog(parent, true);
        jrpd.show();
        if (jrpd.getDialogResult() == 0) {
            JRParameter parameter = jrpd.getParameter();
            this.getJReportFrame().getReport().addParameter(parameter);
            this.updateParameters();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        new ValuesDialog((Frame)new JFrame(), true).show();
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        if (jReportFrame == null) {
            this.setVisible(false);
            return;
        }
        if (this.isVisible()) {
            this.setTitle(jReportFrame.getReport().getName() + " values...");
            this.updateParameters();
            this.updateFields();
            this.updateVariables();
        }
    }

    public void updateParameters() {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
        dtm.setRowCount(0);
        Enumeration e = this.jReportFrame.getReport().getParameters().elements();
        while (e.hasMoreElements()) {
            JRParameter parameter = (JRParameter)e.nextElement();
            Vector<Object> row = new Vector<Object>();
            row.addElement(parameter);
            row.addElement(parameter.getClassType());
            row.addElement(parameter.isIsForPrompting() + "");
            dtm.addRow(row);
        }
    }

    public void updateFields() {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        dtm.setRowCount(0);
        Enumeration e = this.jReportFrame.getReport().getFields().elements();
        while (e.hasMoreElements()) {
            JRField field = (JRField)e.nextElement();
            Vector<Object> row = new Vector<Object>();
            row.addElement(field);
            row.addElement(field.getClassType());
            dtm.addRow(row);
        }
    }

    public void updateVariables() {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableVariables.getModel();
        dtm.setRowCount(0);
        Enumeration e = this.jReportFrame.getReport().getVariables().elements();
        while (e.hasMoreElements()) {
            JRVariable variable = (JRVariable)e.nextElement();
            Vector<Object> row = new Vector<Object>();
            row.addElement(variable);
            row.addElement(variable.isBuiltin() ? "yes" : "no");
            dtm.addRow(row);
        }
    }

    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        super.setVisible(visible);
        if (visible) {
            this.setJReportFrame(this.jReportFrame);
        }
    }

    public void modifyParameter(JRParameter p) {
        this.jTabbedPane.setSelectedComponent(this.jPanelParameters);
        DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            if (dtm.getValueAt(i, 0) != p) continue;
            this.jTableParameters.setRowSelectionInterval(i, i);
            this.jButtonModifyParameterActionPerformed(new ActionEvent(this.jButtonModifyParameter, 0, this.jButtonModifyParameter.getName()));
            return;
        }
    }

    public void gotoTab(String tab) {
        if (tab.equals("Parameters")) {
            this.jTabbedPane.setSelectedIndex(2);
        } else if (tab.equals("Fields")) {
            this.jTabbedPane.setSelectedIndex(0);
        } else if (tab.equals("Variables")) {
            this.jTabbedPane.setSelectedIndex(1);
        }
    }
}

