/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.barcode;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.Barcode128;
import com.lowagie.text.pdf.Barcode39;
import com.lowagie.text.pdf.BarcodeEAN;
import com.lowagie.text.pdf.BarcodeEANSUPP;
import com.lowagie.text.pdf.BarcodeInter25;
import com.lowagie.text.pdf.BarcodePostnet;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class Chap0907 {
    public static void main(String[] args) {
        System.out.println("Chapter 9 example 7: Barcodes without ttf");
        Document document = new Document(PageSize.A4, 50.0f, 50.0f, 50.0f, 50.0f);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream("c:\\copy\\Chap0907.pdf"));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            Barcode39 code39 = new Barcode39();
            code39.setCode("CODE39-1234567890");
            code39.setStartStopText(false);
            Image image39 = code39.createImageWithBarcode(cb, null, null);
            Barcode39 code39ext = new Barcode39();
            code39ext.setCode("The willows.");
            code39ext.setStartStopText(false);
            code39ext.setExtended(true);
            Image image39ext = code39ext.createImageWithBarcode(cb, null, null);
            Barcode128 code128 = new Barcode128();
            code128.setCode("1Z234786 hello");
            Image image128 = code128.createImageWithBarcode(cb, null, null);
            BarcodeEAN codeEAN = new BarcodeEAN();
            codeEAN.setCodeType(1);
            codeEAN.setCode("9780201615883");
            Image imageEAN = codeEAN.createImageWithBarcode(cb, null, null);
            BarcodeInter25 code25 = new BarcodeInter25();
            code25.setGenerateChecksum(true);
            code25.setCode("41-1200076041-001");
            Image image25 = code25.createImageWithBarcode(cb, null, null);
            BarcodePostnet codePost = new BarcodePostnet();
            codePost.setCode("12345");
            Image imagePost = codePost.createImageWithBarcode(cb, null, null);
            BarcodePostnet codePlanet = new BarcodePostnet();
            codePlanet.setCode("50201402356");
            codePlanet.setCodeType(8);
            Image imagePlanet = codePlanet.createImageWithBarcode(cb, null, null);
            PdfTemplate tp = cb.createTemplate(0.0f, 0.0f);
            PdfTemplate ean = codeEAN.createTemplateWithBarcode(cb, null, Color.blue);
            BarcodeEAN codeSUPP = new BarcodeEAN();
            codeSUPP.setCodeType(6);
            codeSUPP.setCode("54995");
            codeSUPP.setBaseline(-2.0f);
            BarcodeEANSUPP eanSupp = new BarcodeEANSUPP((Barcode)codeEAN, (Barcode)codeSUPP);
            Image imageEANSUPP = eanSupp.createImageWithBarcode(cb, null, Color.blue);
            PdfPTable table = new PdfPTable(2);
            table.setWidthPercentage(100.0f);
            table.getDefaultCell().setBorder(0);
            table.getDefaultCell().setHorizontalAlignment(1);
            table.getDefaultCell().setVerticalAlignment(5);
            table.getDefaultCell().setFixedHeight(70.0f);
            table.addCell("CODE 39");
            table.addCell(new Phrase(new Chunk(image39, 0.0f, 0.0f)));
            table.addCell("CODE 39 EXTENDED");
            table.addCell(new Phrase(new Chunk(image39ext, 0.0f, 0.0f)));
            table.addCell("CODE 128");
            table.addCell(new Phrase(new Chunk(image128, 0.0f, 0.0f)));
            table.addCell("CODE EAN");
            table.addCell(new Phrase(new Chunk(imageEAN, 0.0f, 0.0f)));
            table.addCell("CODE EAN\nWITH\nSUPPLEMENTAL 5");
            table.addCell(new Phrase(new Chunk(imageEANSUPP, 0.0f, 0.0f)));
            table.addCell("CODE INTERLEAVED");
            table.addCell(new Phrase(new Chunk(image25, 0.0f, 0.0f)));
            table.addCell("CODE POSTNET");
            table.addCell(new Phrase(new Chunk(imagePost, 0.0f, 0.0f)));
            table.addCell("CODE PLANET");
            table.addCell(new Phrase(new Chunk(imagePlanet, 0.0f, 0.0f)));
            document.add((Element)table);
        }
        catch (Exception de) {
            de.printStackTrace();
        }
        document.close();
    }
}

