/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BandsDialog
extends JDialog {
    private JReportFrame jReportFrame = null;
    private JCheckBox jCheckBoxSplitAllowed;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jListBands;
    private JNumberField jNumberFieldHeight;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelButtons;
    private JPanel jPanelFields;
    private JRTextExpressionArea jRTextExpressionArea;
    private JScrollPane jScrollPane1;

    public BandsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(520, 250);
        Misc.centerFrame(this);
        this.jListBands.setModel(new DefaultListModel());
        this.jRTextExpressionArea.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                BandsDialog.this.jRTextExpressionAreaTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                BandsDialog.this.jRTextExpressionAreaTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                BandsDialog.this.jRTextExpressionAreaTextChanged();
            }
        });
    }

    private void jRTextExpressionAreaTextChanged() {
        if (this.jListBands.getSelectedValue() != null && this.jListBands.getSelectedValue() instanceof Band) {
            Band selectedBand = (Band)this.jListBands.getSelectedValue();
            selectedBand.setPrintWhenExpression(this.jRTextExpressionArea.getText());
        }
    }

    public void jTableBandsListSelectionValueChanged(ListSelectionEvent e) {
    }

    public void updateBands() {
        Object selected = this.jListBands.getSelectedValue();
        boolean isSelected = false;
        ((DefaultListModel)this.jListBands.getModel()).removeAllElements();
        if (this.jReportFrame == null) {
            return;
        }
        Enumeration e = this.jReportFrame.getReport().getBands().elements();
        while (e.hasMoreElements()) {
            Band band = (Band)e.nextElement();
            ((DefaultListModel)this.jListBands.getModel()).addElement(band);
            if (selected != band) continue;
            this.jListBands.setSelectedValue(selected, true);
            isSelected = true;
        }
        if (!isSelected && this.jReportFrame.getReport().getBands().size() > 0) {
            this.jListBands.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jPanelFields = new JPanel();
        this.jPanelButtons = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jNumberFieldHeight = new JNumberField();
        this.jCheckBoxSplitAllowed = new JCheckBox();
        this.jRTextExpressionArea = new JRTextExpressionArea();
        this.jScrollPane1 = new JScrollPane();
        this.jListBands = new JList();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                BandsDialog.this.closeDialog(evt);
            }
        });
        this.jPanelFields.setLayout(new BorderLayout(4, 4));
        this.jPanelButtons.setLayout(new BorderLayout());
        this.jPanelButtons.setBorder(new TitledBorder(new EtchedBorder(), "Band properties", 0, 0, new Font("Dialog", 0, 11)));
        this.jPanelButtons.setMinimumSize(new Dimension(100, 10));
        this.jPanelButtons.setPreferredSize(new Dimension(100, 10));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel3.setLayout(null);
        this.jPanel3.setPreferredSize(new Dimension(10, 55));
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setText("Print When Expression");
        this.jPanel3.add(this.jLabel1);
        this.jLabel1.setBounds(2, 36, 122, 18);
        this.jLabel2.setFont(new Font("Dialog", 0, 11));
        this.jLabel2.setText("Band height");
        this.jPanel3.add(this.jLabel2);
        this.jLabel2.setBounds(2, 10, 96, 18);
        this.jNumberFieldHeight.setHorizontalAlignment(4);
        this.jNumberFieldHeight.setText("0");
        try {
            this.jNumberFieldHeight.setDecimals(0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.jNumberFieldHeight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BandsDialog.this.jNumberFieldHeightActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jNumberFieldHeight);
        this.jNumberFieldHeight.setBounds(98, 10, 50, 20);
        this.jCheckBoxSplitAllowed.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxSplitAllowed.setSelected(true);
        this.jCheckBoxSplitAllowed.setText("Split allowed");
        this.jCheckBoxSplitAllowed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BandsDialog.this.jCheckBoxSplitAllowedActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jCheckBoxSplitAllowed);
        this.jCheckBoxSplitAllowed.setBounds(172, 8, 114, 23);
        this.jPanel2.add((Component)this.jPanel3, "North");
        this.jRTextExpressionArea.setBorder(new EtchedBorder());
        this.jRTextExpressionArea.setElectricScroll(0);
        this.jRTextExpressionArea.setMinimumSize(new Dimension(0, 0));
        this.jRTextExpressionArea.setPreferredSize(new Dimension(0, 0));
        this.jPanel2.add((Component)this.jRTextExpressionArea, "Center");
        this.jPanelButtons.add((Component)this.jPanel2, "Center");
        this.jPanelFields.add((Component)this.jPanelButtons, "Center");
        this.getContentPane().add((Component)this.jPanelFields, "Center");
        this.jScrollPane1.setToolTipText("");
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setPreferredSize(new Dimension(150, 131));
        this.jListBands.setBorder(new EtchedBorder());
        this.jListBands.setFont(new Font("Dialog", 0, 11));
        this.jListBands.setSelectionMode(0);
        this.jListBands.setToolTipText("List of bands");
        this.jListBands.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jListBands.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                BandsDialog.this.jListBandsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListBands);
        this.getContentPane().add((Component)this.jScrollPane1, "West");
        this.pack();
    }

    private void jCheckBoxSplitAllowedActionPerformed(ActionEvent evt) {
        Band b = (Band)this.jListBands.getSelectedValue();
        if (b != null) {
            b.setSplitAllowed(this.jCheckBoxSplitAllowed.isSelected());
        }
    }

    private void jNumberFieldHeightActionPerformed(ActionEvent evt) {
        Band b = (Band)this.jListBands.getSelectedValue();
        int delta = (int)this.jNumberFieldHeight.getValue() - b.getHeight();
        if (delta != 0) {
            Report report = this.getJReportFrame().getReport();
            int min_height = 0;
            int band_h = this.getJReportFrame().getReport().getBandYLocation(b) + 10;
            if (delta < -(b.getHeight() - min_height)) {
                delta = -(b.getHeight() - min_height);
            }
            if (!b.getName().equals("background") && report.getDesignHeightNoBG() + delta > report.getHeight()) {
                delta = report.getHeight() - report.getDesignHeightNoBG();
            } else if (b.getName().equals("background") && b.getHeight() + delta > report.getWidth() - report.getTopMargin() - report.getBottomMargin()) {
                delta = report.getWidth() - b.getHeight() - report.getTopMargin() - report.getBottomMargin();
            }
            b.setHeight(b.getHeight() + delta);
            int edge_y = Math.min(report.getBandYLocation(b) + b.getHeight(), report.getBandYLocation(b) + b.getHeight() - delta);
            Enumeration e = report.getElements().elements();
            while (e.hasMoreElements()) {
                ReportElement re = (ReportElement)e.nextElement();
                if (re.position.y < edge_y + 10) continue;
                int space_before_band = band_h - re.position.y - re.height;
                if (band_h <= report.getBandYLocation(re.getBand()) + 10) {
                    space_before_band = 0;
                }
                re.setPosition(new Point(re.getPosition().x, re.getPosition().y + delta));
            }
            System.out.println("Repaint");
            this.getJReportFrame().setIsDocDirty(true);
            this.getJReportFrame().getReportPanel().repaint();
        }
    }

    private void jListBandsValueChanged(ListSelectionEvent evt) {
        if (this.jListBands.getModel().getSize() == 0) {
            try {
                this.jNumberFieldHeight.setValue(0);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.jRTextExpressionArea.setText("");
            this.jCheckBoxSplitAllowed.setSelected(false);
            return;
        }
        if (this.jListBands.getSelectedIndex() < 0) {
            this.jListBands.setSelectedIndex(0);
            return;
        }
        Band selectedBand = (Band)this.jListBands.getSelectedValue();
        try {
            this.jNumberFieldHeight.setValue(selectedBand.getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jRTextExpressionArea.setText(selectedBand.getPrintWhenExpression());
        this.jCheckBoxSplitAllowed.setSelected(selectedBand.isSplitAllowed());
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new BandsDialog((Frame)new JFrame(), true).show();
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        if (jReportFrame == null) {
            this.setVisible(false);
            return;
        }
        this.setTitle(jReportFrame.getReport().getName() + " bands...");
        if (this.isVisible()) {
            this.updateBands();
        }
    }

    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        super.setVisible(visible);
        if (visible) {
            this.setJReportFrame(this.jReportFrame);
        }
    }

    public void setSelectedBand(String bandName) {
        for (int i = 0; i < this.jListBands.getModel().getSize(); ++i) {
            Band b = (Band)this.jListBands.getModel().getElementAt(i);
            if (!b.getName().equals(bandName)) continue;
            this.jListBands.setSelectedIndex(i);
            return;
        }
    }
}

