/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class JRGroupDialog
extends JDialog {
    private String groupName;
    private String expression;
    private int minHeightStartNewPage = 0;
    private int headerBandHeight = 0;
    private int footerBandHeight = 0;
    private boolean startNewPage = false;
    private boolean startNewColumn = false;
    private boolean printHeaderEachPage = false;
    private boolean resetPageNumber = false;
    private JReportFrame jReportFrame = null;
    private JTextField jTextFieldName;
    private JButton jButtonCancel;
    private JLabel jLabel1;
    private JCheckBox jCheckBoxPrintHeaderEachPage;
    private JLabel jLabel3;
    private JNumberField jNumberFieldMinStartNewPage;
    private JCheckBox jCheckBoxStartNewPage;
    private JNumberField jNumberFieldHeaderBand;
    private JCheckBox jCheckBoxResetPageNumber;
    private JLabel jLabel7;
    private JCheckBox jCheckBoxStartNewColumn;
    private JButton jButtonOK;
    private JNumberField jNumberFieldFooterBand;
    private JRTextExpressionArea jRTextExpressionArea;
    private JLabel jLabel6;
    private JLabel jLabel5;
    private int dialogResult;

    public JRGroupDialog(JReportFrame jReportFrame, boolean modal) {
        super((Frame)null, modal);
        this.initComponents();
        this.jReportFrame = jReportFrame;
        this.setSize(350, 344);
        this.jRTextExpressionArea.setText("");
        Misc.centerFrame(this);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jCheckBoxStartNewColumn = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jRTextExpressionArea = new JRTextExpressionArea();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jCheckBoxStartNewPage = new JCheckBox();
        this.jCheckBoxResetPageNumber = new JCheckBox();
        this.jCheckBoxPrintHeaderEachPage = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jNumberFieldMinStartNewPage = new JNumberField();
        this.jLabel6 = new JLabel();
        this.jNumberFieldHeaderBand = new JNumberField();
        this.jLabel7 = new JLabel();
        this.jNumberFieldFooterBand = new JNumberField();
        this.getContentPane().setLayout(null);
        this.setTitle("Add/modify group");
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRGroupDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setText("Group name");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(4, 4, 250, 15);
        this.jTextFieldName.setFont(new Font("Dialog", 0, 11));
        this.getContentPane().add(this.jTextFieldName);
        this.jTextFieldName.setBounds(4, 20, 332, 22);
        this.jCheckBoxStartNewColumn.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxStartNewColumn.setText("Start on a new column");
        this.getContentPane().add(this.jCheckBoxStartNewColumn);
        this.jCheckBoxStartNewColumn.setBounds(6, 44, 166, 23);
        this.jLabel3.setFont(new Font("Dialog", 0, 11));
        this.jLabel3.setText("Group expression");
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(4, 116, 250, 15);
        this.jRTextExpressionArea.setBorder(new EtchedBorder());
        this.getContentPane().add(this.jRTextExpressionArea);
        this.jRTextExpressionArea.setBounds(4, 134, 328, 78);
        this.jButtonCancel.setFont(new Font("Dialog", 0, 11));
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRGroupDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jButtonCancel);
        this.jButtonCancel.setBounds(252, 286, 86, 25);
        this.jButtonOK.setFont(new Font("Dialog", 0, 11));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRGroupDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jButtonOK);
        this.jButtonOK.setBounds(178, 286, 70, 25);
        this.jCheckBoxStartNewPage.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxStartNewPage.setText("Start on a new page");
        this.getContentPane().add(this.jCheckBoxStartNewPage);
        this.jCheckBoxStartNewPage.setBounds(6, 62, 166, 23);
        this.jCheckBoxResetPageNumber.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxResetPageNumber.setText("Reset page number");
        this.getContentPane().add(this.jCheckBoxResetPageNumber);
        this.jCheckBoxResetPageNumber.setBounds(176, 44, 162, 23);
        this.jCheckBoxPrintHeaderEachPage.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxPrintHeaderEachPage.setText("Print header on each page");
        this.getContentPane().add(this.jCheckBoxPrintHeaderEachPage);
        this.jCheckBoxPrintHeaderEachPage.setBounds(176, 62, 162, 23);
        this.jLabel5.setFont(new Font("Dialog", 0, 11));
        this.jLabel5.setText("Min height to start new page");
        this.getContentPane().add(this.jLabel5);
        this.jLabel5.setBounds(6, 92, 144, 15);
        this.jNumberFieldMinStartNewPage.setHorizontalAlignment(4);
        try {
            this.jNumberFieldMinStartNewPage.setDecimals(0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.getContentPane().add(this.jNumberFieldMinStartNewPage);
        this.jNumberFieldMinStartNewPage.setBounds(150, 88, 48, 20);
        this.jLabel6.setFont(new Font("Dialog", 0, 11));
        this.jLabel6.setText("Group header band height");
        this.getContentPane().add(this.jLabel6);
        this.jLabel6.setBounds(8, 226, 144, 15);
        this.jNumberFieldHeaderBand.setHorizontalAlignment(4);
        try {
            this.jNumberFieldHeaderBand.setDecimals(0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            this.jNumberFieldHeaderBand.setValue(50.0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.getContentPane().add(this.jNumberFieldHeaderBand);
        this.jNumberFieldHeaderBand.setBounds(152, 222, 48, 20);
        this.jLabel7.setFont(new Font("Dialog", 0, 11));
        this.jLabel7.setText("Group footer band height");
        this.getContentPane().add(this.jLabel7);
        this.jLabel7.setBounds(8, 248, 144, 15);
        this.jNumberFieldFooterBand.setHorizontalAlignment(4);
        try {
            this.jNumberFieldFooterBand.setDecimals(0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            this.jNumberFieldFooterBand.setValue(50.0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.getContentPane().add(this.jNumberFieldFooterBand);
        this.jNumberFieldFooterBand.setBounds(152, 244, 48, 20);
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Please insert a valid group name!", "Invalid name!", 2);
            return;
        }
        this.setGroupName(this.jTextFieldName.getText());
        this.setHeaderBandHeight((int)this.jNumberFieldHeaderBand.getValue());
        this.setFooterBandHeight((int)this.jNumberFieldFooterBand.getValue());
        this.setMinHeightStartNewPage((int)this.jNumberFieldMinStartNewPage.getValue());
        this.setStartNewColumn(this.jCheckBoxStartNewColumn.isSelected());
        this.setStartNewPage(this.jCheckBoxStartNewPage.isSelected());
        this.setPrintHeaderEachPage(this.jCheckBoxPrintHeaderEachPage.isSelected());
        this.setResetPageNumber(this.jCheckBoxResetPageNumber.isSelected());
        this.setExpression(this.jRTextExpressionArea.getText());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new JRParameterDialog((Frame)new JFrame(), true).show();
    }

    public void setGroup(Group group) {
        this.jTextFieldName.setText(new String(group.getName()));
        this.jCheckBoxStartNewPage.setSelected(group.isIsStartNewPage());
        this.jCheckBoxStartNewColumn.setSelected(group.isIsStartNewColumn());
        this.jCheckBoxPrintHeaderEachPage.setSelected(group.isIsReprintHeaderOnEachPage());
        this.jCheckBoxResetPageNumber.setSelected(group.isIsResetPageNumber());
        this.jRTextExpressionArea.setText(new String(group.getGroupExpression().trim()));
        try {
            this.jNumberFieldMinStartNewPage.setValue(group.getMinHeightToStartNewPage());
            this.jNumberFieldHeaderBand.setValue(group.getGroupHeader().getHeight());
            this.jNumberFieldFooterBand.setValue(group.getGroupFooter().getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public int getFooterBandHeight() {
        return this.footerBandHeight;
    }

    public void setFooterBandHeight(int footerBandHeight) {
        this.footerBandHeight = footerBandHeight;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public int getHeaderBandHeight() {
        return this.headerBandHeight;
    }

    public void setHeaderBandHeight(int headerBandHeight) {
        this.headerBandHeight = headerBandHeight;
    }

    public int getMinHeightStartNewPage() {
        return this.minHeightStartNewPage;
    }

    public void setMinHeightStartNewPage(int minHeightStartNewPage) {
        this.minHeightStartNewPage = minHeightStartNewPage;
    }

    public boolean isPrintHeaderEachPage() {
        return this.printHeaderEachPage;
    }

    public void setPrintHeaderEachPage(boolean printHeaderEachPage) {
        this.printHeaderEachPage = printHeaderEachPage;
    }

    public boolean isResetPageNumber() {
        return this.resetPageNumber;
    }

    public void setResetPageNumber(boolean resetPageNumber) {
        this.resetPageNumber = resetPageNumber;
    }

    public boolean isStartNewColumn() {
        return this.startNewColumn;
    }

    public void setStartNewColumn(boolean startNewColumn) {
        this.startNewColumn = startNewColumn;
    }

    public boolean isStartNewPage() {
        return this.startNewPage;
    }

    public void setStartNewPage(boolean startNewPage) {
        this.startNewPage = startNewPage;
    }
}

