/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.HighLowDataset;
import org.jfree.data.XYDataset;
import org.jfree.util.PublicCloneable;

public class HighLowItemLabelGenerator
implements XYItemLabelGenerator,
XYToolTipGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private DateFormat dateFormatter;

    public HighLowItemLabelGenerator() {
        this(DateFormat.getInstance());
    }

    public HighLowItemLabelGenerator(DateFormat formatter) {
        this.dateFormatter = formatter;
    }

    public String generateToolTip(XYDataset data, int series, int item) {
        String result = null;
        if (data instanceof HighLowDataset) {
            HighLowDataset d = (HighLowDataset)data;
            Number high = d.getHighValue(series, item);
            Number low = d.getLowValue(series, item);
            Number open = d.getOpenValue(series, item);
            Number close = d.getCloseValue(series, item);
            Number x = d.getXValue(series, item);
            result = d.getSeriesName(series);
            if (x != null) {
                Date date = new Date(x.longValue());
                result = result + "--> Date=" + this.dateFormatter.format(date);
                if (high != null) {
                    result = result + " High=" + high.toString();
                }
                if (low != null) {
                    result = result + " Low=" + low.toString();
                }
                if (open != null) {
                    result = result + " Open=" + open.toString();
                }
                if (close != null) {
                    result = result + " Close=" + close.toString();
                }
            }
        }
        return result;
    }

    public String generateItemLabel(XYDataset dataset, int series, int category) {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        HighLowItemLabelGenerator clone = (HighLowItemLabelGenerator)super.clone();
        if (this.dateFormatter != null) {
            clone.dateFormatter = (DateFormat)this.dateFormatter.clone();
        }
        return clone;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof HighLowItemLabelGenerator) {
            HighLowItemLabelGenerator generator = (HighLowItemLabelGenerator)o;
            return this.dateFormatter.equals(generator.dateFormatter);
        }
        return false;
    }
}

